/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public class ClientboundAddEntityPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundAddEntityPacket> STREAM_CODEC = Packet.codec(ClientboundAddEntityPacket::write, ClientboundAddEntityPacket::new);
    private final int id;
    private final UUID uuid;
    private final EntityType<?> type;
    private final double x;
    private final double y;
    private final double z;
    private final Vec3 movement;
    private final byte xRot;
    private final byte yRot;
    private final byte yHeadRot;
    private final int data;

    public ClientboundAddEntityPacket(Entity var0, ServerEntity var1) {
        this(var0, var1, 0);
    }

    public ClientboundAddEntityPacket(Entity var0, ServerEntity var1, int var2) {
        this(var0.getId(), var0.getUUID(), var1.getPositionBase().x(), var1.getPositionBase().y(), var1.getPositionBase().z(), var1.getLastSentXRot(), var1.getLastSentYRot(), var0.getType(), var2, var1.getLastSentMovement(), var1.getLastSentYHeadRot());
    }

    public ClientboundAddEntityPacket(Entity var0, int var1, BlockPos var2) {
        this(var0.getId(), var0.getUUID(), var2.getX(), var2.getY(), var2.getZ(), var0.getXRot(), var0.getYRot(), var0.getType(), var1, var0.getDeltaMovement(), var0.getYHeadRot());
    }

    public ClientboundAddEntityPacket(int var0, UUID var1, double var2, double var4, double var6, float var8, float var9, EntityType<?> var10, int var11, Vec3 var12, double var13) {
        this.id = var0;
        this.uuid = var1;
        this.x = var2;
        this.y = var4;
        this.z = var6;
        this.movement = var12;
        this.xRot = Mth.packDegrees(var8);
        this.yRot = Mth.packDegrees(var9);
        this.yHeadRot = Mth.packDegrees((float)var13);
        this.type = var10;
        this.data = var11;
    }

    private ClientboundAddEntityPacket(RegistryFriendlyByteBuf var0) {
        this.id = var0.readVarInt();
        this.uuid = var0.readUUID();
        this.type = (EntityType)ByteBufCodecs.registry(Registries.ENTITY_TYPE).decode(var0);
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.movement = var0.readLpVec3();
        this.xRot = var0.readByte();
        this.yRot = var0.readByte();
        this.yHeadRot = var0.readByte();
        this.data = var0.readVarInt();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.id);
        var0.writeUUID(this.uuid);
        ByteBufCodecs.registry(Registries.ENTITY_TYPE).encode(var0, this.type);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeLpVec3(this.movement);
        var0.writeByte(this.xRot);
        var0.writeByte(this.yRot);
        var0.writeByte(this.yHeadRot);
        var0.writeVarInt(this.data);
    }

    @Override
    public PacketType<ClientboundAddEntityPacket> type() {
        return GamePacketTypes.CLIENTBOUND_ADD_ENTITY;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleAddEntity(this);
    }

    public int getId() {
        return this.id;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public EntityType<?> getType() {
        return this.type;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vec3 getMovement() {
        return this.movement;
    }

    public float getXRot() {
        return Mth.unpackDegrees(this.xRot);
    }

    public float getYRot() {
        return Mth.unpackDegrees(this.yRot);
    }

    public float getYHeadRot() {
        return Mth.unpackDegrees(this.yHeadRot);
    }

    public int getData() {
        return this.data;
    }
}

