/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import org.jspecify.annotations.Nullable;

public class ClientboundEntityEventPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundEntityEventPacket> STREAM_CODEC = Packet.codec(ClientboundEntityEventPacket::write, ClientboundEntityEventPacket::new);
    private final int entityId;
    private final byte eventId;

    public ClientboundEntityEventPacket(Entity var0, byte var1) {
        this.entityId = var0.getId();
        this.eventId = var1;
    }

    private ClientboundEntityEventPacket(FriendlyByteBuf var0) {
        this.entityId = var0.readInt();
        this.eventId = var0.readByte();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeInt(this.entityId);
        var0.writeByte(this.eventId);
    }

    @Override
    public PacketType<ClientboundEntityEventPacket> type() {
        return GamePacketTypes.CLIENTBOUND_ENTITY_EVENT;
    }

    @Override
    public void handle(ClientGamePacketListener var0) {
        var0.handleEntityEvent(this);
    }

    public @Nullable Entity getEntity(Level var0) {
        return var0.getEntity(this.entityId);
    }

    public byte getEventId() {
        return this.eventId;
    }
}

