/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class ServerboundInteractPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundInteractPacket> STREAM_CODEC = Packet.codec(ServerboundInteractPacket::write, ServerboundInteractPacket::new);
    private final int entityId;
    private final Action action;
    private final boolean usingSecondaryAction;
    static final Action ATTACK_ACTION = new Action(){

        @Override
        public ActionType getType() {
            return ActionType.ATTACK;
        }

        @Override
        public void dispatch(Handler var0) {
            var0.onAttack();
        }

        @Override
        public void write(FriendlyByteBuf var0) {
        }
    };

    private ServerboundInteractPacket(int var0, boolean var1, Action var2) {
        this.entityId = var0;
        this.action = var2;
        this.usingSecondaryAction = var1;
    }

    public static ServerboundInteractPacket createAttackPacket(Entity var0, boolean var1) {
        return new ServerboundInteractPacket(var0.getId(), var1, ATTACK_ACTION);
    }

    public static ServerboundInteractPacket createInteractionPacket(Entity var0, boolean var1, InteractionHand var2) {
        return new ServerboundInteractPacket(var0.getId(), var1, new InteractionAction(var2));
    }

    public static ServerboundInteractPacket createInteractionPacket(Entity var0, boolean var1, InteractionHand var2, Vec3 var3) {
        return new ServerboundInteractPacket(var0.getId(), var1, new InteractionAtLocationAction(var2, var3));
    }

    private ServerboundInteractPacket(FriendlyByteBuf var0) {
        this.entityId = var0.readVarInt();
        ActionType var1 = var0.readEnum(ActionType.class);
        this.action = var1.reader.apply(var0);
        this.usingSecondaryAction = var0.readBoolean();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeVarInt(this.entityId);
        var0.writeEnum(this.action.getType());
        this.action.write(var0);
        var0.writeBoolean(this.usingSecondaryAction);
    }

    @Override
    public PacketType<ServerboundInteractPacket> type() {
        return GamePacketTypes.SERVERBOUND_INTERACT;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handleInteract(this);
    }

    public @Nullable Entity getTarget(ServerLevel var0) {
        return var0.getEntityOrPart(this.entityId);
    }

    public boolean isUsingSecondaryAction() {
        return this.usingSecondaryAction;
    }

    public boolean isWithinRange(ServerPlayer var0, AABB var1, double var2) {
        if (this.action.getType() == ActionType.ATTACK) {
            return var0.isWithinAttackRange(var1, var2);
        }
        return var0.isWithinEntityInteractionRange(var1, var2);
    }

    public void dispatch(Handler var0) {
        this.action.dispatch(var0);
    }

    static interface Action {
        public ActionType getType();

        public void dispatch(Handler var1);

        public void write(FriendlyByteBuf var1);
    }

    static class InteractionAction
    implements Action {
        private final InteractionHand hand;

        InteractionAction(InteractionHand var0) {
            this.hand = var0;
        }

        private InteractionAction(FriendlyByteBuf var0) {
            this.hand = var0.readEnum(InteractionHand.class);
        }

        @Override
        public ActionType getType() {
            return ActionType.INTERACT;
        }

        @Override
        public void dispatch(Handler var0) {
            var0.onInteraction(this.hand);
        }

        @Override
        public void write(FriendlyByteBuf var0) {
            var0.writeEnum(this.hand);
        }
    }

    static class InteractionAtLocationAction
    implements Action {
        private final InteractionHand hand;
        private final Vec3 location;

        InteractionAtLocationAction(InteractionHand var0, Vec3 var1) {
            this.hand = var0;
            this.location = var1;
        }

        private InteractionAtLocationAction(FriendlyByteBuf var0) {
            this.location = new Vec3(var0.readFloat(), var0.readFloat(), var0.readFloat());
            this.hand = var0.readEnum(InteractionHand.class);
        }

        @Override
        public ActionType getType() {
            return ActionType.INTERACT_AT;
        }

        @Override
        public void dispatch(Handler var0) {
            var0.onInteraction(this.hand, this.location);
        }

        @Override
        public void write(FriendlyByteBuf var0) {
            var0.writeFloat((float)this.location.x);
            var0.writeFloat((float)this.location.y);
            var0.writeFloat((float)this.location.z);
            var0.writeEnum(this.hand);
        }
    }

    static enum ActionType {
        INTERACT(InteractionAction::new),
        ATTACK(var0 -> ATTACK_ACTION),
        INTERACT_AT(InteractionAtLocationAction::new);

        final Function<FriendlyByteBuf, Action> reader;

        private ActionType(Function var2) {
            this.reader = var2;
        }
    }

    public static interface Handler {
        public void onInteraction(InteractionHand var1);

        public void onInteraction(InteractionHand var1, Vec3 var2);

        public void onAttack();
    }
}

