/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public class ServerboundPlayerActionPacket
implements Packet<ServerGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ServerboundPlayerActionPacket> STREAM_CODEC = Packet.codec(ServerboundPlayerActionPacket::write, ServerboundPlayerActionPacket::new);
    private final BlockPos pos;
    private final Direction direction;
    private final Action action;
    private final int sequence;

    public ServerboundPlayerActionPacket(Action var0, BlockPos var1, Direction var2, int var3) {
        this.action = var0;
        this.pos = var1.immutable();
        this.direction = var2;
        this.sequence = var3;
    }

    public ServerboundPlayerActionPacket(Action var0, BlockPos var1, Direction var2) {
        this(var0, var1, var2, 0);
    }

    private ServerboundPlayerActionPacket(FriendlyByteBuf var0) {
        this.action = var0.readEnum(Action.class);
        this.pos = var0.readBlockPos();
        this.direction = Direction.from3DDataValue(var0.readUnsignedByte());
        this.sequence = var0.readVarInt();
    }

    private void write(FriendlyByteBuf var0) {
        var0.writeEnum(this.action);
        var0.writeBlockPos(this.pos);
        var0.writeByte(this.direction.get3DDataValue());
        var0.writeVarInt(this.sequence);
    }

    @Override
    public PacketType<ServerboundPlayerActionPacket> type() {
        return GamePacketTypes.SERVERBOUND_PLAYER_ACTION;
    }

    @Override
    public void handle(ServerGamePacketListener var0) {
        var0.handlePlayerAction(this);
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public Action getAction() {
        return this.action;
    }

    public int getSequence() {
        return this.sequence;
    }

    public static enum Action {
        START_DESTROY_BLOCK,
        ABORT_DESTROY_BLOCK,
        STOP_DESTROY_BLOCK,
        DROP_ALL_ITEMS,
        DROP_ITEM,
        RELEASE_USE_ITEM,
        SWAP_ITEM_WITH_OFFHAND,
        STAB;

    }
}

