/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class FileToIdConverter {
    private final String prefix;
    private final String extension;

    public FileToIdConverter(String var0, String var1) {
        this.prefix = var0;
        this.extension = var1;
    }

    public static FileToIdConverter json(String var0) {
        return new FileToIdConverter(var0, ".json");
    }

    public static FileToIdConverter registry(ResourceKey<? extends Registry<?>> var0) {
        return FileToIdConverter.json(Registries.elementsDirPath(var0));
    }

    public Identifier idToFile(Identifier var0) {
        return var0.withPath(this.prefix + "/" + var0.getPath() + this.extension);
    }

    public Identifier fileToId(Identifier var0) {
        String var1 = var0.getPath();
        return var0.withPath(var1.substring(this.prefix.length() + 1, var1.length() - this.extension.length()));
    }

    public Map<Identifier, Resource> listMatchingResources(ResourceManager var02) {
        return var02.listResources(this.prefix, var0 -> var0.getPath().endsWith(this.extension));
    }

    public Map<Identifier, List<Resource>> listMatchingResourceStacks(ResourceManager var02) {
        return var02.listResourceStacks(this.prefix, var0 -> var0.getPath().endsWith(this.extension));
    }
}

