/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.MapMaker;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;

public class ResourceKey<T> {
    private static final ConcurrentMap<InternKey, ResourceKey<?>> VALUES = new MapMaker().weakValues().makeMap();
    private final Identifier registryName;
    private final Identifier identifier;

    public static <T> Codec<ResourceKey<T>> codec(ResourceKey<? extends Registry<T>> var0) {
        return Identifier.CODEC.xmap(var1 -> ResourceKey.create(var0, var1), ResourceKey::identifier);
    }

    public static <T> StreamCodec<ByteBuf, ResourceKey<T>> streamCodec(ResourceKey<? extends Registry<T>> var0) {
        return Identifier.STREAM_CODEC.map(var1 -> ResourceKey.create(var0, var1), ResourceKey::identifier);
    }

    public static <T> ResourceKey<T> create(ResourceKey<? extends Registry<T>> var0, Identifier var1) {
        return ResourceKey.create(var0.identifier, var1);
    }

    public static <T> ResourceKey<Registry<T>> createRegistryKey(Identifier var0) {
        return ResourceKey.create(Registries.ROOT_REGISTRY_NAME, var0);
    }

    private static <T> ResourceKey<T> create(Identifier var02, Identifier var1) {
        return VALUES.computeIfAbsent(new InternKey(var02, var1), var0 -> new ResourceKey(var0.registry, var0.identifier));
    }

    private ResourceKey(Identifier var0, Identifier var1) {
        this.registryName = var0;
        this.identifier = var1;
    }

    public String toString() {
        return "ResourceKey[" + String.valueOf(this.registryName) + " / " + String.valueOf(this.identifier) + "]";
    }

    public boolean isFor(ResourceKey<? extends Registry<?>> var0) {
        return this.registryName.equals(var0.identifier());
    }

    public <E> Optional<ResourceKey<E>> cast(ResourceKey<? extends Registry<E>> var0) {
        return this.isFor(var0) ? Optional.of(this) : Optional.empty();
    }

    public Identifier identifier() {
        return this.identifier;
    }

    public Identifier registry() {
        return this.registryName;
    }

    public ResourceKey<Registry<T>> registryKey() {
        return ResourceKey.createRegistryKey(this.registryName);
    }

    static final class InternKey
    extends Record {
        final Identifier registry;
        final Identifier identifier;

        InternKey(Identifier var0, Identifier var1) {
            this.registry = var0;
            this.identifier = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InternKey.class, "registry;identifier", "registry", "identifier"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InternKey.class, "registry;identifier", "registry", "identifier"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InternKey.class, "registry;identifier", "registry", "identifier"}, this, var0);
        }

        public Identifier registry() {
            return this.registry;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }
}

