/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.TreeNodePosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerAdvancementManager
extends SimpleJsonResourceReloadListener<Advancement> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public Map<Identifier, AdvancementHolder> advancements = new HashMap<Identifier, AdvancementHolder>();
    private AdvancementTree tree = new AdvancementTree();
    private final HolderLookup.Provider registries;

    public ServerAdvancementManager(HolderLookup.Provider holderlookup_a) {
        super(holderlookup_a, Advancement.CODEC, Registries.ADVANCEMENT);
        this.registries = holderlookup_a;
    }

    @Override
    protected void apply(Map<Identifier, Advancement> map, ResourceManager iresourcemanager, ProfilerFiller gameprofilerfiller) {
        ImmutableMap.Builder immutablemap_builder = ImmutableMap.builder();
        map.forEach((minecraftkey, advancement) -> {
            if (SpigotConfig.disabledAdvancements != null && (SpigotConfig.disabledAdvancements.contains("*") || SpigotConfig.disabledAdvancements.contains(minecraftkey.toString()) || SpigotConfig.disabledAdvancements.contains(minecraftkey.getNamespace()))) {
                return;
            }
            this.validate((Identifier)minecraftkey, (Advancement)advancement);
            immutablemap_builder.put(minecraftkey, (Object)new AdvancementHolder((Identifier)minecraftkey, (Advancement)advancement));
        });
        this.advancements = new HashMap<Identifier, AdvancementHolder>((Map<Identifier, AdvancementHolder>)immutablemap_builder.buildOrThrow());
        AdvancementTree advancementtree = new AdvancementTree();
        advancementtree.addAll(this.advancements.values());
        for (AdvancementNode advancementnode : advancementtree.roots()) {
            if (!advancementnode.holder().value().display().isPresent()) continue;
            TreeNodePosition.run(advancementnode);
        }
        this.tree = advancementtree;
    }

    private void validate(Identifier minecraftkey, Advancement advancement) {
        ProblemReporter.Collector problemreporter_a = new ProblemReporter.Collector();
        advancement.validate(problemreporter_a, this.registries);
        if (!problemreporter_a.isEmpty()) {
            LOGGER.warn("Found validation problems in advancement {}: \n{}", (Object)minecraftkey, (Object)problemreporter_a.getReport());
        }
    }

    public @Nullable AdvancementHolder get(Identifier minecraftkey) {
        return this.advancements.get(minecraftkey);
    }

    public AdvancementTree tree() {
        return this.tree;
    }

    public Collection<AdvancementHolder> getAllAdvancements() {
        return this.advancements.values();
    }
}

