/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.chase;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Scanner;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.io.IOUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ChaseClient {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int RECONNECT_INTERVAL_SECONDS = 5;
    private final String serverHost;
    private final int serverPort;
    private final MinecraftServer server;
    private volatile boolean wantsToRun;
    private @Nullable Socket socket;
    private @Nullable Thread thread;

    public ChaseClient(String var0, int var1, MinecraftServer var2) {
        this.serverHost = var0;
        this.serverPort = var1;
        this.server = var2;
    }

    public void start() {
        if (this.thread != null && this.thread.isAlive()) {
            LOGGER.warn("Remote control client was asked to start, but it is already running. Will ignore.");
        }
        this.wantsToRun = true;
        this.thread = new Thread(this::run, "chase-client");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.wantsToRun = false;
        IOUtils.closeQuietly((Socket)this.socket);
        this.socket = null;
        this.thread = null;
    }

    public void run() {
        String var0 = this.serverHost + ":" + this.serverPort;
        while (this.wantsToRun) {
            try {
                LOGGER.info("Connecting to remote control server {}", (Object)var0);
                this.socket = new Socket(this.serverHost, this.serverPort);
                LOGGER.info("Connected to remote control server! Will continuously execute the command broadcasted by that server.");
                try (BufferedReader var1 = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.US_ASCII));){
                    while (this.wantsToRun) {
                        String var2 = var1.readLine();
                        if (var2 == null) {
                            LOGGER.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)var0, (Object)5);
                            break;
                        }
                        this.handleMessage(var2);
                    }
                }
                catch (IOException var12) {
                    LOGGER.warn("Lost connection to remote control server {}. Will retry in {}s.", (Object)var0, (Object)5);
                }
            }
            catch (IOException var1) {
                LOGGER.warn("Failed to connect to remote control server {}. Will retry in {}s.", (Object)var0, (Object)5);
            }
            if (!this.wantsToRun) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void handleMessage(String var0) {
        try (Scanner var1 = new Scanner(new StringReader(var0));){
            var1.useLocale(Locale.ROOT);
            String var2 = var1.next();
            if ("t".equals(var2)) {
                this.handleTeleport(var1);
            } else {
                LOGGER.warn("Unknown message type '{}'", (Object)var2);
            }
        }
        catch (NoSuchElementException var12) {
            LOGGER.warn("Could not parse message '{}', ignoring", (Object)var0);
        }
    }

    private void handleTeleport(Scanner var02) {
        this.parseTarget(var02).ifPresent(var0 -> this.executeCommand(String.format(Locale.ROOT, "execute in %s run tp @s %.3f %.3f %.3f %.3f %.3f", var0.level.identifier(), var0.pos.x, var0.pos.y, var0.pos.z, Float.valueOf(var0.rot.y), Float.valueOf(var0.rot.x))));
    }

    private Optional<TeleportTarget> parseTarget(Scanner var0) {
        ResourceKey var1 = (ResourceKey)ChaseCommand.DIMENSION_NAMES.get((Object)var0.next());
        if (var1 == null) {
            return Optional.empty();
        }
        float var2 = var0.nextFloat();
        float var3 = var0.nextFloat();
        float var4 = var0.nextFloat();
        float var5 = var0.nextFloat();
        float var6 = var0.nextFloat();
        return Optional.of(new TeleportTarget(var1, new Vec3(var2, var3, var4), new Vec2(var6, var5)));
    }

    private void executeCommand(String var0) {
        this.server.execute(() -> {
            List<ServerPlayer> var1 = this.server.getPlayerList().getPlayers();
            if (var1.isEmpty()) {
                return;
            }
            ServerPlayer var2 = var1.get(0);
            ServerLevel var3 = this.server.overworld();
            CommandSourceStack var4 = new CommandSourceStack(var2.commandSource(), Vec3.atLowerCornerOf(var3.getRespawnData().pos()), Vec2.ZERO, var3, LevelBasedPermissionSet.OWNER, "", CommonComponents.EMPTY, this.server, var2);
            Commands var5 = this.server.getCommands();
            var5.performPrefixedCommand(var4, var0);
        });
    }

    static final class TeleportTarget
    extends Record {
        final ResourceKey<Level> level;
        final Vec3 pos;
        final Vec2 rot;

        TeleportTarget(ResourceKey<Level> var0, Vec3 var1, Vec2 var2) {
            this.level = var0;
            this.pos = var1;
            this.rot = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{TeleportTarget.class, "level;pos;rot", "level", "pos", "rot"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{TeleportTarget.class, "level;pos;rot", "level", "pos", "rot"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{TeleportTarget.class, "level;pos;rot", "level", "pos", "rot"}, this, var0);
        }

        public ResourceKey<Level> level() {
            return this.level;
        }

        public Vec3 pos() {
            return this.pos;
        }

        public Vec2 rot() {
            return this.rot;
        }
    }
}

