/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public class AttributeCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.attribute.failed.entity", var0));
    private static final Dynamic2CommandExceptionType ERROR_NO_SUCH_ATTRIBUTE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.attribute.failed.no_attribute", var0, var1));
    private static final Dynamic3CommandExceptionType ERROR_NO_SUCH_MODIFIER = new Dynamic3CommandExceptionType((var0, var1, var2) -> Component.translatableEscape("commands.attribute.failed.no_modifier", var1, var0, var2));
    private static final Dynamic3CommandExceptionType ERROR_MODIFIER_ALREADY_PRESENT = new Dynamic3CommandExceptionType((var0, var1, var2) -> Component.translatableEscape("commands.attribute.failed.modifier_already_present", var2, var1, var0));

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var12) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("attribute").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("target", EntityArgument.entity()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("attribute", ResourceArgument.resource(var12, Registries.ATTRIBUTE)).then(((LiteralArgumentBuilder)Commands.literal("get").executes(var0 -> AttributeCommand.getAttributeValue((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> AttributeCommand.getAttributeValue((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("base").then(Commands.literal("set").then(Commands.argument("value", DoubleArgumentType.doubleArg()).executes(var0 -> AttributeCommand.setAttributeBase((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value")))))).then(((LiteralArgumentBuilder)Commands.literal("get").executes(var0 -> AttributeCommand.getAttributeBase((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> AttributeCommand.getAttributeBase((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale")))))).then(Commands.literal("reset").executes(var0 -> AttributeCommand.resetAttributeBase((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("modifier").then(Commands.literal("add").then(Commands.argument("id", IdentifierArgument.id()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("value", DoubleArgumentType.doubleArg()).then(Commands.literal("add_value").executes(var0 -> AttributeCommand.addModifier((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value"), AttributeModifier.Operation.ADD_VALUE)))).then(Commands.literal("add_multiplied_base").executes(var0 -> AttributeCommand.addModifier((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value"), AttributeModifier.Operation.ADD_MULTIPLIED_BASE)))).then(Commands.literal("add_multiplied_total").executes(var0 -> AttributeCommand.addModifier((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"value"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL))))))).then(Commands.literal("remove").then(Commands.argument("id", IdentifierArgument.id()).suggests((var0, var1) -> SharedSuggestionProvider.suggestResource(AttributeCommand.getAttributeModifiers(EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute")), var1)).executes(var0 -> AttributeCommand.removeModifier((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id")))))).then(Commands.literal("value").then(Commands.literal("get").then(((RequiredArgumentBuilder)Commands.argument("id", IdentifierArgument.id()).suggests((var0, var1) -> SharedSuggestionProvider.suggestResource(AttributeCommand.getAttributeModifiers(EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute")), var1)).executes(var0 -> AttributeCommand.getAttributeModifier((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), 1.0))).then(Commands.argument("scale", DoubleArgumentType.doubleArg()).executes(var0 -> AttributeCommand.getAttributeModifier((CommandSourceStack)var0.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)var0, "target"), ResourceArgument.getAttribute((CommandContext<CommandSourceStack>)var0, "attribute"), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), DoubleArgumentType.getDouble((CommandContext)var0, (String)"scale"))))))))))));
    }

    private static AttributeInstance getAttributeInstance(Entity var0, Holder<Attribute> var1) throws CommandSyntaxException {
        AttributeInstance var2 = AttributeCommand.getLivingEntity(var0).getAttributes().getInstance(var1);
        if (var2 == null) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)var0.getName(), (Object)AttributeCommand.getAttributeDescription(var1));
        }
        return var2;
    }

    private static LivingEntity getLivingEntity(Entity var0) throws CommandSyntaxException {
        if (!(var0 instanceof LivingEntity)) {
            throw ERROR_NOT_LIVING_ENTITY.create((Object)var0.getName());
        }
        return (LivingEntity)var0;
    }

    private static LivingEntity getEntityWithAttribute(Entity var0, Holder<Attribute> var1) throws CommandSyntaxException {
        LivingEntity var2 = AttributeCommand.getLivingEntity(var0);
        if (!var2.getAttributes().hasAttribute(var1)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)var0.getName(), (Object)AttributeCommand.getAttributeDescription(var1));
        }
        return var2;
    }

    private static int getAttributeValue(CommandSourceStack var0, Entity var1, Holder<Attribute> var2, double var3) throws CommandSyntaxException {
        LivingEntity var5 = AttributeCommand.getEntityWithAttribute(var1, var2);
        double var6 = var5.getAttributeValue(var2);
        var0.sendSuccess(() -> Component.translatable("commands.attribute.value.get.success", AttributeCommand.getAttributeDescription(var2), var1.getName(), var6), false);
        return (int)(var6 * var3);
    }

    private static int getAttributeBase(CommandSourceStack var0, Entity var1, Holder<Attribute> var2, double var3) throws CommandSyntaxException {
        LivingEntity var5 = AttributeCommand.getEntityWithAttribute(var1, var2);
        double var6 = var5.getAttributeBaseValue(var2);
        var0.sendSuccess(() -> Component.translatable("commands.attribute.base_value.get.success", AttributeCommand.getAttributeDescription(var2), var1.getName(), var6), false);
        return (int)(var6 * var3);
    }

    private static int getAttributeModifier(CommandSourceStack var0, Entity var1, Holder<Attribute> var2, Identifier var3, double var4) throws CommandSyntaxException {
        LivingEntity var6 = AttributeCommand.getEntityWithAttribute(var1, var2);
        AttributeMap var7 = var6.getAttributes();
        if (!var7.hasModifier(var2, var3)) {
            throw ERROR_NO_SUCH_MODIFIER.create((Object)var1.getName(), (Object)AttributeCommand.getAttributeDescription(var2), (Object)var3);
        }
        double var8 = var7.getModifierValue(var2, var3);
        var0.sendSuccess(() -> Component.translatable("commands.attribute.modifier.value.get.success", Component.translationArg(var3), AttributeCommand.getAttributeDescription(var2), var1.getName(), var8), false);
        return (int)(var8 * var4);
    }

    private static Stream<Identifier> getAttributeModifiers(Entity var0, Holder<Attribute> var1) throws CommandSyntaxException {
        AttributeInstance var2 = AttributeCommand.getAttributeInstance(var0, var1);
        return var2.getModifiers().stream().map(AttributeModifier::id);
    }

    private static int setAttributeBase(CommandSourceStack var0, Entity var1, Holder<Attribute> var2, double var3) throws CommandSyntaxException {
        AttributeCommand.getAttributeInstance(var1, var2).setBaseValue(var3);
        var0.sendSuccess(() -> Component.translatable("commands.attribute.base_value.set.success", AttributeCommand.getAttributeDescription(var2), var1.getName(), var3), false);
        return 1;
    }

    private static int resetAttributeBase(CommandSourceStack var0, Entity var1, Holder<Attribute> var2) throws CommandSyntaxException {
        LivingEntity var3 = AttributeCommand.getLivingEntity(var1);
        if (!var3.getAttributes().resetBaseValue(var2)) {
            throw ERROR_NO_SUCH_ATTRIBUTE.create((Object)var1.getName(), (Object)AttributeCommand.getAttributeDescription(var2));
        }
        double var4 = var3.getAttributeBaseValue(var2);
        var0.sendSuccess(() -> Component.translatable("commands.attribute.base_value.reset.success", AttributeCommand.getAttributeDescription(var2), var1.getName(), var4), false);
        return 1;
    }

    private static int addModifier(CommandSourceStack var0, Entity var1, Holder<Attribute> var2, Identifier var3, double var4, AttributeModifier.Operation var6) throws CommandSyntaxException {
        AttributeInstance var7 = AttributeCommand.getAttributeInstance(var1, var2);
        AttributeModifier var8 = new AttributeModifier(var3, var4, var6);
        if (var7.hasModifier(var3)) {
            throw ERROR_MODIFIER_ALREADY_PRESENT.create((Object)var1.getName(), (Object)AttributeCommand.getAttributeDescription(var2), (Object)var3);
        }
        var7.addPermanentModifier(var8);
        var0.sendSuccess(() -> Component.translatable("commands.attribute.modifier.add.success", Component.translationArg(var3), AttributeCommand.getAttributeDescription(var2), var1.getName()), false);
        return 1;
    }

    private static int removeModifier(CommandSourceStack var0, Entity var1, Holder<Attribute> var2, Identifier var3) throws CommandSyntaxException {
        AttributeInstance var4 = AttributeCommand.getAttributeInstance(var1, var2);
        if (var4.removeModifier(var3)) {
            var0.sendSuccess(() -> Component.translatable("commands.attribute.modifier.remove.success", Component.translationArg(var3), AttributeCommand.getAttributeDescription(var2), var1.getName()), false);
            return 1;
        }
        throw ERROR_NO_SUCH_MODIFIER.create((Object)var1.getName(), (Object)AttributeCommand.getAttributeDescription(var2), (Object)var3);
    }

    private static Component getAttributeDescription(Holder<Attribute> var0) {
        return Component.translatable(var0.value().getDescriptionId());
    }
}

