/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.player.Player;

public class BossBarCommands {
    private static final DynamicCommandExceptionType ERROR_ALREADY_EXISTS = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.bossbar.create.failed", var0));
    private static final DynamicCommandExceptionType ERROR_DOESNT_EXIST = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.bossbar.unknown", var0));
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.players.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_NAME_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.name.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_COLOR_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.color.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_STYLE_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.style.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_VALUE_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.value.unchanged"));
    private static final SimpleCommandExceptionType ERROR_NO_MAX_CHANGE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.max.unchanged"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_HIDDEN = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.visibility.unchanged.hidden"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_VISIBLE = new SimpleCommandExceptionType((Message)Component.translatable("commands.bossbar.set.visibility.unchanged.visible"));
    public static final SuggestionProvider<CommandSourceStack> SUGGEST_BOSS_BAR = (var0, var1) -> SharedSuggestionProvider.suggestResource(((CommandSourceStack)var0.getSource()).getServer().getCustomBossEvents().getIds(), var1);

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("bossbar").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("add").then(Commands.argument("id", IdentifierArgument.id()).then(Commands.argument("name", ComponentArgument.textComponent(var1)).executes(var0 -> BossBarCommands.createBar((CommandSourceStack)var0.getSource(), IdentifierArgument.getId((CommandContext<CommandSourceStack>)var0, "id"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "name"))))))).then(Commands.literal("remove").then(Commands.argument("id", IdentifierArgument.id()).suggests(SUGGEST_BOSS_BAR).executes(var0 -> BossBarCommands.removeBar((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0)))))).then(Commands.literal("list").executes(var0 -> BossBarCommands.listBars((CommandSourceStack)var0.getSource())))).then(Commands.literal("set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("id", IdentifierArgument.id()).suggests(SUGGEST_BOSS_BAR).then(Commands.literal("name").then(Commands.argument("name", ComponentArgument.textComponent(var1)).executes(var0 -> BossBarCommands.setName((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "name")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("color").then(Commands.literal("pink").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.PINK)))).then(Commands.literal("blue").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.BLUE)))).then(Commands.literal("red").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.RED)))).then(Commands.literal("green").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.GREEN)))).then(Commands.literal("yellow").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.YELLOW)))).then(Commands.literal("purple").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.PURPLE)))).then(Commands.literal("white").executes(var0 -> BossBarCommands.setColor((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarColor.WHITE))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("style").then(Commands.literal("progress").executes(var0 -> BossBarCommands.setStyle((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarOverlay.PROGRESS)))).then(Commands.literal("notched_6").executes(var0 -> BossBarCommands.setStyle((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarOverlay.NOTCHED_6)))).then(Commands.literal("notched_10").executes(var0 -> BossBarCommands.setStyle((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarOverlay.NOTCHED_10)))).then(Commands.literal("notched_12").executes(var0 -> BossBarCommands.setStyle((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarOverlay.NOTCHED_12)))).then(Commands.literal("notched_20").executes(var0 -> BossBarCommands.setStyle((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BossEvent.BossBarOverlay.NOTCHED_20))))).then(Commands.literal("value").then(Commands.argument("value", IntegerArgumentType.integer((int)0)).executes(var0 -> BossBarCommands.setValue((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), IntegerArgumentType.getInteger((CommandContext)var0, (String)"value")))))).then(Commands.literal("max").then(Commands.argument("max", IntegerArgumentType.integer((int)1)).executes(var0 -> BossBarCommands.setMax((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), IntegerArgumentType.getInteger((CommandContext)var0, (String)"max")))))).then(Commands.literal("visible").then(Commands.argument("visible", BoolArgumentType.bool()).executes(var0 -> BossBarCommands.setVisible((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), BoolArgumentType.getBool((CommandContext)var0, (String)"visible")))))).then(((LiteralArgumentBuilder)Commands.literal("players").executes(var0 -> BossBarCommands.setPlayers((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), Collections.emptyList()))).then(Commands.argument("targets", EntityArgument.players()).executes(var0 -> BossBarCommands.setPlayers((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0), EntityArgument.getOptionalPlayers((CommandContext<CommandSourceStack>)var0, "targets")))))))).then(Commands.literal("get").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("id", IdentifierArgument.id()).suggests(SUGGEST_BOSS_BAR).then(Commands.literal("value").executes(var0 -> BossBarCommands.getValue((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("max").executes(var0 -> BossBarCommands.getMax((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("visible").executes(var0 -> BossBarCommands.getVisible((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0))))).then(Commands.literal("players").executes(var0 -> BossBarCommands.getPlayers((CommandSourceStack)var0.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var0))))))));
    }

    private static int getValue(CommandSourceStack var0, CustomBossEvent var1) {
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.get.value", var1.getDisplayName(), var1.getValue()), true);
        return var1.getValue();
    }

    private static int getMax(CommandSourceStack var0, CustomBossEvent var1) {
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.get.max", var1.getDisplayName(), var1.getMax()), true);
        return var1.getMax();
    }

    private static int getVisible(CommandSourceStack var0, CustomBossEvent var1) {
        if (var1.isVisible()) {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.get.visible.visible", var1.getDisplayName()), true);
            return 1;
        }
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.get.visible.hidden", var1.getDisplayName()), true);
        return 0;
    }

    private static int getPlayers(CommandSourceStack var0, CustomBossEvent var1) {
        if (var1.getPlayers().isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.get.players.none", var1.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.get.players.some", var1.getDisplayName(), var1.getPlayers().size(), ComponentUtils.formatList(var1.getPlayers(), Player::getDisplayName)), true);
        }
        return var1.getPlayers().size();
    }

    private static int setVisible(CommandSourceStack var0, CustomBossEvent var1, boolean var2) throws CommandSyntaxException {
        if (var1.isVisible() == var2) {
            if (var2) {
                throw ERROR_ALREADY_VISIBLE.create();
            }
            throw ERROR_ALREADY_HIDDEN.create();
        }
        var1.setVisible(var2);
        if (var2) {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.visible.success.visible", var1.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.visible.success.hidden", var1.getDisplayName()), true);
        }
        return 0;
    }

    private static int setValue(CommandSourceStack var0, CustomBossEvent var1, int var2) throws CommandSyntaxException {
        if (var1.getValue() == var2) {
            throw ERROR_NO_VALUE_CHANGE.create();
        }
        var1.setValue(var2);
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.value.success", var1.getDisplayName(), var2), true);
        return var2;
    }

    private static int setMax(CommandSourceStack var0, CustomBossEvent var1, int var2) throws CommandSyntaxException {
        if (var1.getMax() == var2) {
            throw ERROR_NO_MAX_CHANGE.create();
        }
        var1.setMax(var2);
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.max.success", var1.getDisplayName(), var2), true);
        return var2;
    }

    private static int setColor(CommandSourceStack var0, CustomBossEvent var1, BossEvent.BossBarColor var2) throws CommandSyntaxException {
        if (var1.getColor().equals(var2)) {
            throw ERROR_NO_COLOR_CHANGE.create();
        }
        var1.setColor(var2);
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.color.success", var1.getDisplayName()), true);
        return 0;
    }

    private static int setStyle(CommandSourceStack var0, CustomBossEvent var1, BossEvent.BossBarOverlay var2) throws CommandSyntaxException {
        if (var1.getOverlay().equals(var2)) {
            throw ERROR_NO_STYLE_CHANGE.create();
        }
        var1.setOverlay(var2);
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.style.success", var1.getDisplayName()), true);
        return 0;
    }

    private static int setName(CommandSourceStack var0, CustomBossEvent var1, Component var2) throws CommandSyntaxException {
        MutableComponent var3 = ComponentUtils.updateForEntity(var0, var2, null, 0);
        if (var1.getName().equals(var3)) {
            throw ERROR_NO_NAME_CHANGE.create();
        }
        var1.setName(var3);
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.name.success", var1.getDisplayName()), true);
        return 0;
    }

    private static int setPlayers(CommandSourceStack var0, CustomBossEvent var1, Collection<ServerPlayer> var2) throws CommandSyntaxException {
        boolean var3 = var1.setPlayers(var2);
        if (!var3) {
            throw ERROR_NO_PLAYER_CHANGE.create();
        }
        if (var1.getPlayers().isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.players.success.none", var1.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.set.players.success.some", var1.getDisplayName(), var2.size(), ComponentUtils.formatList(var2, Player::getDisplayName)), true);
        }
        return var1.getPlayers().size();
    }

    private static int listBars(CommandSourceStack var0) {
        Collection<CustomBossEvent> var1 = var0.getServer().getCustomBossEvents().getEvents();
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.list.bars.none"), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.bossbar.list.bars.some", var1.size(), ComponentUtils.formatList(var1, CustomBossEvent::getDisplayName)), false);
        }
        return var1.size();
    }

    private static int createBar(CommandSourceStack var0, Identifier var1, Component var2) throws CommandSyntaxException {
        CustomBossEvents var3 = var0.getServer().getCustomBossEvents();
        if (var3.get(var1) != null) {
            throw ERROR_ALREADY_EXISTS.create((Object)var1.toString());
        }
        CustomBossEvent var4 = var3.create(var1, ComponentUtils.updateForEntity(var0, var2, null, 0));
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.create.success", var4.getDisplayName()), true);
        return var3.getEvents().size();
    }

    private static int removeBar(CommandSourceStack var0, CustomBossEvent var1) {
        CustomBossEvents var2 = var0.getServer().getCustomBossEvents();
        var1.removeAllPlayers();
        var2.remove(var1);
        var0.sendSuccess(() -> Component.translatable("commands.bossbar.remove.success", var1.getDisplayName()), true);
        return var2.getEvents().size();
    }

    public static CustomBossEvent getBossBar(CommandContext<CommandSourceStack> var0) throws CommandSyntaxException {
        Identifier var1 = IdentifierArgument.getId(var0, "id");
        CustomBossEvent var2 = ((CommandSourceStack)var0.getSource()).getServer().getCustomBossEvents().get(var1);
        if (var2 == null) {
            throw ERROR_DOESNT_EXIST.create((Object)var1.toString());
        }
        return var2;
    }
}

