/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.ticks.LevelTicks;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CloneCommands {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.clone.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.clone.failed"));
    public static final Predicate<BlockInWorld> FILTER_AIR = var0 -> !var0.getState().isAir();

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("clone").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(CloneCommands.beginEndDestinationAndModeSuffix(var1, var0 -> ((CommandSourceStack)var0.getSource()).getLevel()))).then(Commands.literal("from").then(Commands.argument("sourceDimension", DimensionArgument.dimension()).then(CloneCommands.beginEndDestinationAndModeSuffix(var1, var0 -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)var0, "sourceDimension")))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> beginEndDestinationAndModeSuffix(CommandBuildContext var02, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> var1) {
        return Commands.argument("begin", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("end", BlockPosArgument.blockPos()).then(CloneCommands.destinationAndStrictSuffix(var02, var1, var0 -> ((CommandSourceStack)var0.getSource()).getLevel()))).then(Commands.literal("to").then(Commands.argument("targetDimension", DimensionArgument.dimension()).then(CloneCommands.destinationAndStrictSuffix(var02, var1, var0 -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)var0, "targetDimension"))))));
    }

    private static DimensionAndPosition getLoadedDimensionAndPosition(CommandContext<CommandSourceStack> var0, ServerLevel var1, String var2) throws CommandSyntaxException {
        BlockPos var3 = BlockPosArgument.getLoadedBlockPos(var0, var1, var2);
        return new DimensionAndPosition(var1, var3);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> destinationAndStrictSuffix(CommandBuildContext var0, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> var12, InCommandFunction<CommandContext<CommandSourceStack>, ServerLevel> var2) {
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var3 = var1 -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)var1, (ServerLevel)var12.apply((CommandContext<CommandSourceStack>)var1), "begin");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var4 = var1 -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)var1, (ServerLevel)var12.apply((CommandContext<CommandSourceStack>)var1), "end");
        InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var5 = var1 -> CloneCommands.getLoadedDimensionAndPosition((CommandContext<CommandSourceStack>)var1, (ServerLevel)var2.apply((CommandContext<CommandSourceStack>)var1), "destination");
        return CloneCommands.modeSuffix(var0, var3, var4, var5, false, Commands.argument("destination", BlockPosArgument.blockPos())).then(CloneCommands.modeSuffix(var0, var3, var4, var5, true, Commands.literal("strict")));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> modeSuffix(CommandBuildContext var03, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var1, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var2, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var3, boolean var42, ArgumentBuilder<CommandSourceStack, ?> var5) {
        return var5.executes(var4 -> CloneCommands.clone((CommandSourceStack)var4.getSource(), (DimensionAndPosition)var1.apply(var4), (DimensionAndPosition)var2.apply(var4), (DimensionAndPosition)var3.apply(var4), var0 -> true, Mode.NORMAL, var42)).then(CloneCommands.wrapWithCloneMode(var1, var2, var3, var02 -> var0 -> true, var42, Commands.literal("replace"))).then(CloneCommands.wrapWithCloneMode(var1, var2, var3, var0 -> FILTER_AIR, var42, Commands.literal("masked"))).then(Commands.literal("filtered").then(CloneCommands.wrapWithCloneMode(var1, var2, var3, var0 -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)var0, "filter"), var42, Commands.argument("filter", BlockPredicateArgument.blockPredicate(var03)))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithCloneMode(InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var0, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var1, InCommandFunction<CommandContext<CommandSourceStack>, DimensionAndPosition> var2, InCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> var3, boolean var4, ArgumentBuilder<CommandSourceStack, ?> var52) {
        return var52.executes(var5 -> CloneCommands.clone((CommandSourceStack)var5.getSource(), (DimensionAndPosition)var0.apply(var5), (DimensionAndPosition)var1.apply(var5), (DimensionAndPosition)var2.apply(var5), (Predicate)var3.apply(var5), Mode.NORMAL, var4)).then(Commands.literal("force").executes(var5 -> CloneCommands.clone((CommandSourceStack)var5.getSource(), (DimensionAndPosition)var0.apply(var5), (DimensionAndPosition)var1.apply(var5), (DimensionAndPosition)var2.apply(var5), (Predicate)var3.apply(var5), Mode.FORCE, var4))).then(Commands.literal("move").executes(var5 -> CloneCommands.clone((CommandSourceStack)var5.getSource(), (DimensionAndPosition)var0.apply(var5), (DimensionAndPosition)var1.apply(var5), (DimensionAndPosition)var2.apply(var5), (Predicate)var3.apply(var5), Mode.MOVE, var4))).then(Commands.literal("normal").executes(var5 -> CloneCommands.clone((CommandSourceStack)var5.getSource(), (DimensionAndPosition)var0.apply(var5), (DimensionAndPosition)var1.apply(var5), (DimensionAndPosition)var2.apply(var5), (Predicate)var3.apply(var5), Mode.NORMAL, var4)));
    }

    private static int clone(CommandSourceStack var0, DimensionAndPosition var1, DimensionAndPosition var2, DimensionAndPosition var3, Predicate<BlockInWorld> var4, Mode var5, boolean var6) throws CommandSyntaxException {
        int var16;
        BlockPos var7 = var1.position();
        BlockPos var8 = var2.position();
        BoundingBox var9 = BoundingBox.fromCorners(var7, var8);
        BlockPos var10 = var3.position();
        BlockPos var11 = var10.offset(var9.getLength());
        BoundingBox var12 = BoundingBox.fromCorners(var10, var11);
        ServerLevel var13 = var1.dimension();
        ServerLevel var14 = var3.dimension();
        if (!var5.canOverlap() && var13 == var14 && var12.intersects(var9)) {
            throw ERROR_OVERLAP.create();
        }
        int var15 = var9.getXSpan() * var9.getYSpan() * var9.getZSpan();
        if (var15 > (var16 = var0.getLevel().getGameRules().get(GameRules.MAX_BLOCK_MODIFICATIONS).intValue())) {
            throw ERROR_AREA_TOO_LARGE.create((Object)var16, (Object)var15);
        }
        if (!var13.hasChunksAt(var7, var8) || !var14.hasChunksAt(var10, var11)) {
            throw BlockPosArgument.ERROR_NOT_LOADED.create();
        }
        if (var14.isDebug()) {
            throw ERROR_FAILED.create();
        }
        ArrayList var17 = Lists.newArrayList();
        ArrayList var18 = Lists.newArrayList();
        ArrayList var19 = Lists.newArrayList();
        LinkedList var20 = Lists.newLinkedList();
        int var21 = 0;
        try (ProblemReporter.ScopedCollector var22 = new ProblemReporter.ScopedCollector(LOGGER);){
            Object var29;
            int var25;
            int var24;
            BlockPos var23 = new BlockPos(var12.minX() - var9.minX(), var12.minY() - var9.minY(), var12.minZ() - var9.minZ());
            for (var24 = var9.minZ(); var24 <= var9.maxZ(); ++var24) {
                for (var25 = var9.minY(); var25 <= var9.maxY(); ++var25) {
                    for (int var26 = var9.minX(); var26 <= var9.maxX(); ++var26) {
                        BlockPos var27 = new BlockPos(var26, var25, var24);
                        Object var28 = var27.offset(var23);
                        var29 = new BlockInWorld(var13, var27, false);
                        BlockState var30 = ((BlockInWorld)var29).getState();
                        if (!var4.test((BlockInWorld)var29)) continue;
                        BlockEntity var31 = var13.getBlockEntity(var27);
                        if (var31 != null) {
                            TagValueOutput var32 = TagValueOutput.createWithContext(var22.forChild(var31.problemPath()), var0.registryAccess());
                            var31.saveCustomOnly(var32);
                            CloneBlockEntityInfo var33 = new CloneBlockEntityInfo(var32.buildResult(), var31.components());
                            var18.add(new CloneBlockInfo((BlockPos)var28, var30, var33, var14.getBlockState((BlockPos)var28)));
                            var20.addLast(var27);
                            continue;
                        }
                        if (var30.isSolidRender() || var30.isCollisionShapeFullBlock(var13, var27)) {
                            var17.add(new CloneBlockInfo((BlockPos)var28, var30, null, var14.getBlockState((BlockPos)var28)));
                            var20.addLast(var27);
                            continue;
                        }
                        var19.add(new CloneBlockInfo((BlockPos)var28, var30, null, var14.getBlockState((BlockPos)var28)));
                        var20.addFirst(var27);
                    }
                }
            }
            var24 = 2 | (var6 ? 816 : 0);
            if (var5 == Mode.MOVE) {
                for (BlockPos var26 : var20) {
                    var13.setBlock(var26, Blocks.BARRIER.defaultBlockState(), var24 | 0x330);
                }
                var25 = var6 ? var24 : 3;
                for (BlockPos var27 : var20) {
                    var13.setBlock(var27, Blocks.AIR.defaultBlockState(), var25);
                }
            }
            ArrayList var252 = Lists.newArrayList();
            var252.addAll(var17);
            var252.addAll(var18);
            var252.addAll(var19);
            List var26 = Lists.reverse((List)var252);
            for (Object var28 : var26) {
                var14.setBlock(((CloneBlockInfo)var28).pos, Blocks.BARRIER.defaultBlockState(), var24 | 0x330);
            }
            for (Object var28 : var252) {
                if (!var14.setBlock(((CloneBlockInfo)var28).pos, ((CloneBlockInfo)var28).state, var24)) continue;
                ++var21;
            }
            for (Object var28 : var18) {
                var29 = var14.getBlockEntity(((CloneBlockInfo)var28).pos);
                if (((CloneBlockInfo)var28).blockEntityInfo != null && var29 != null) {
                    ((BlockEntity)var29).loadCustomOnly(TagValueInput.create(var22.forChild(((BlockEntity)var29).problemPath()), (HolderLookup.Provider)var14.registryAccess(), ((CloneBlockInfo)var28).blockEntityInfo.tag));
                    ((BlockEntity)var29).setComponents(((CloneBlockInfo)var28).blockEntityInfo.components);
                    ((BlockEntity)var29).setChanged();
                }
                var14.setBlock(((CloneBlockInfo)var28).pos, ((CloneBlockInfo)var28).state, var24);
            }
            if (!var6) {
                for (Object var28 : var26) {
                    var14.updateNeighboursOnBlockSet(((CloneBlockInfo)var28).pos, ((CloneBlockInfo)var28).previousStateAtDestination);
                }
            }
            ((LevelTicks)var14.getBlockTicks()).copyAreaFrom(var13.getBlockTicks(), var9, var23);
        }
        if (var21 == 0) {
            throw ERROR_FAILED.create();
        }
        int var34 = var21;
        var0.sendSuccess(() -> Component.translatable("commands.clone.success", var34), true);
        return var21;
    }

    record DimensionAndPosition(ServerLevel dimension, BlockPos position) {
    }

    static enum Mode {
        FORCE(true),
        MOVE(true),
        NORMAL(false);

        private final boolean canOverlap;

        private Mode(boolean var2) {
            this.canOverlap = var2;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }
    }

    static final class CloneBlockEntityInfo
    extends Record {
        final CompoundTag tag;
        final DataComponentMap components;

        CloneBlockEntityInfo(CompoundTag var0, DataComponentMap var1) {
            this.tag = var0;
            this.components = var1;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CloneBlockEntityInfo.class, "tag;components", "tag", "components"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CloneBlockEntityInfo.class, "tag;components", "tag", "components"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CloneBlockEntityInfo.class, "tag;components", "tag", "components"}, this, var0);
        }

        public CompoundTag tag() {
            return this.tag;
        }

        public DataComponentMap components() {
            return this.components;
        }
    }

    static final class CloneBlockInfo
    extends Record {
        final BlockPos pos;
        final BlockState state;
        final @Nullable CloneBlockEntityInfo blockEntityInfo;
        final BlockState previousStateAtDestination;

        CloneBlockInfo(BlockPos var0, BlockState var1, @Nullable CloneBlockEntityInfo var2, BlockState var3) {
            this.pos = var0;
            this.state = var1;
            this.blockEntityInfo = var2;
            this.previousStateAtDestination = var3;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{CloneBlockInfo.class, "pos;state;blockEntityInfo;previousStateAtDestination", "pos", "state", "blockEntityInfo", "previousStateAtDestination"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{CloneBlockInfo.class, "pos;state;blockEntityInfo;previousStateAtDestination", "pos", "state", "blockEntityInfo", "previousStateAtDestination"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{CloneBlockInfo.class, "pos;state;blockEntityInfo;previousStateAtDestination", "pos", "state", "blockEntityInfo", "previousStateAtDestination"}, this, var0);
        }

        public BlockPos pos() {
            return this.pos;
        }

        public BlockState state() {
            return this.state;
        }

        public @Nullable CloneBlockEntityInfo blockEntityInfo() {
            return this.blockEntityInfo;
        }

        public BlockState previousStateAtDestination() {
            return this.previousStateAtDestination;
        }
    }
}

