/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.Path;

public class DebugPathCommand {
    private static final SimpleCommandExceptionType ERROR_NOT_MOB = new SimpleCommandExceptionType((Message)Component.literal("Source is not a mob"));
    private static final SimpleCommandExceptionType ERROR_NO_PATH = new SimpleCommandExceptionType((Message)Component.literal("Path not found"));
    private static final SimpleCommandExceptionType ERROR_NOT_COMPLETE = new SimpleCommandExceptionType((Message)Component.literal("Target not reached"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("debugpath").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("to", BlockPosArgument.blockPos()).executes(var0 -> DebugPathCommand.fillBlocks((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "to"))))));
    }

    private static int fillBlocks(CommandSourceStack var0, BlockPos var1) throws CommandSyntaxException {
        Entity var2 = var0.getEntity();
        if (!(var2 instanceof Mob)) {
            throw ERROR_NOT_MOB.create();
        }
        Mob var3 = (Mob)var2;
        GroundPathNavigation var4 = new GroundPathNavigation(var3, var0.getLevel());
        Path var5 = ((PathNavigation)var4).createPath(var1, 0);
        if (var5 == null) {
            throw ERROR_NO_PATH.create();
        }
        if (!var5.canReach()) {
            throw ERROR_NOT_COMPLETE.create();
        }
        var0.sendSuccess(() -> Component.literal("Made path"), true);
        return 1;
    }
}

