/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.enchant.failed.entity", var0));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.enchant.failed.itemless", var0));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.enchant.failed.incompatible", var0));
    private static final Dynamic2CommandExceptionType ERROR_LEVEL_TOO_HIGH = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.enchant.failed.level", var0, var1));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.translatable("commands.enchant.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("enchant").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument("enchantment", ResourceArgument.resource(var1, Registries.ENCHANTMENT)).executes(var0 -> EnchantCommand.enchant((CommandSourceStack)var0.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "targets"), ResourceArgument.getEnchantment((CommandContext<CommandSourceStack>)var0, "enchantment"), 1))).then(Commands.argument("level", IntegerArgumentType.integer((int)0)).executes(var0 -> EnchantCommand.enchant((CommandSourceStack)var0.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "targets"), ResourceArgument.getEnchantment((CommandContext<CommandSourceStack>)var0, "enchantment"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"level"))))))));
    }

    private static int enchant(CommandSourceStack var0, Collection<? extends Entity> var1, Holder<Enchantment> var2, int var3) throws CommandSyntaxException {
        Enchantment var4 = var2.value();
        if (var3 > var4.getMaxLevel()) {
            throw ERROR_LEVEL_TOO_HIGH.create((Object)var3, (Object)var4.getMaxLevel());
        }
        int var5 = 0;
        for (Entity entity : var1) {
            if (entity instanceof LivingEntity) {
                LivingEntity var8 = (LivingEntity)entity;
                ItemStack var9 = var8.getMainHandItem();
                if (!var9.isEmpty()) {
                    if (var4.canEnchant(var9) && EnchantmentHelper.isEnchantmentCompatible(EnchantmentHelper.getEnchantmentsForCrafting(var9).keySet(), var2)) {
                        var9.enchant(var2, var3);
                        ++var5;
                        continue;
                    }
                    if (var1.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)var9.getHoverName().getString());
                }
                if (var1.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)var8.getName().getString());
            }
            if (var1.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.getName().getString());
        }
        if (var5 == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.enchant.success.single", Enchantment.getFullname(var1, var3), ((Entity)var3.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.enchant.success.multiple", Enchantment.getFullname(var1, var3), var3.size()), true);
        }
        return var5;
    }
}

