/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.HeightmapTypeArgument;
import net.minecraft.commands.arguments.IdentifierArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.RangeArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.SlotsArgument;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.SwizzleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.item.FunctionArgument;
import net.minecraft.commands.arguments.item.ItemPredicateArgument;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.CustomModifierExecutor;
import net.minecraft.commands.execution.ExecutionControl;
import net.minecraft.commands.execution.tasks.CallFunction;
import net.minecraft.commands.execution.tasks.FallthroughTask;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.commands.BossBarCommands;
import net.minecraft.server.commands.FunctionCommand;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.StopwatchCommand;
import net.minecraft.server.commands.SummonCommand;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.DataCommands;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.Container;
import net.minecraft.world.Stopwatch;
import net.minecraft.world.Stopwatches;
import net.minecraft.world.entity.Attackable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SlotProvider;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.inventory.SlotRange;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.ScoreAccess;
import net.minecraft.world.scores.ScoreHolder;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ExecuteCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TEST_AREA = 32768;
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.execute.blocks.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_CONDITIONAL_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.execute.conditional.fail"));
    private static final DynamicCommandExceptionType ERROR_CONDITIONAL_FAILED_COUNT = new DynamicCommandExceptionType(var0 -> Component.translatableEscape("commands.execute.conditional.fail_count", var0));
    @VisibleForTesting
    public static final Dynamic2CommandExceptionType ERROR_FUNCTION_CONDITION_INSTANTATION_FAILURE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.execute.function.instantiationFailure", var0, var1));

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        LiteralCommandNode<CommandSourceStack> var2 = var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal("execute").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))));
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("execute").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("run").redirect(var02.getRoot()))).then(ExecuteCommand.addConditionals(var2, Commands.literal("if"), true, var1))).then(ExecuteCommand.addConditionals(var2, Commands.literal("unless"), false, var1))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var0, "targets")) {
                var1.add(((CommandSourceStack)var0.getSource()).withEntity(entity));
            }
            return var1;
        })))).then(Commands.literal("at").then(Commands.argument("targets", EntityArgument.entities()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var0, "targets")) {
                var1.add(((CommandSourceStack)var0.getSource()).withLevel((ServerLevel)entity.level()).withPosition(entity.position()).withRotation(entity.getRotationVector()));
            }
            return var1;
        })))).then(((LiteralArgumentBuilder)Commands.literal("store").then(ExecuteCommand.wrapStores(var2, Commands.literal("result"), true))).then(ExecuteCommand.wrapStores(var2, Commands.literal("success"), false)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("positioned").then(Commands.argument("pos", Vec3Argument.vec3()).redirect(var2, var0 -> ((CommandSourceStack)var0.getSource()).withPosition(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos")).withAnchor(EntityAnchorArgument.Anchor.FEET)))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var0, "targets")) {
                var1.add(((CommandSourceStack)var0.getSource()).withPosition(entity.position()));
            }
            return var1;
        })))).then(Commands.literal("over").then(Commands.argument("heightmap", HeightmapTypeArgument.heightmap()).redirect(var2, var0 -> {
            Vec3 var1 = ((CommandSourceStack)var0.getSource()).getPosition();
            ServerLevel var2 = ((CommandSourceStack)var0.getSource()).getLevel();
            double var3 = var1.x();
            double var5 = var1.z();
            if (!var2.hasChunk(SectionPos.blockToSectionCoord(var3), SectionPos.blockToSectionCoord(var5))) {
                throw BlockPosArgument.ERROR_NOT_LOADED.create();
            }
            int var7 = var2.getHeight(HeightmapTypeArgument.getHeightmap((CommandContext<CommandSourceStack>)var0, "heightmap"), Mth.floor(var3), Mth.floor(var5));
            return ((CommandSourceStack)var0.getSource()).withPosition(new Vec3(var3, var7, var5));
        }))))).then(((LiteralArgumentBuilder)Commands.literal("rotated").then(Commands.argument("rot", RotationArgument.rotation()).redirect(var2, var0 -> ((CommandSourceStack)var0.getSource()).withRotation(RotationArgument.getRotation((CommandContext<CommandSourceStack>)var0, "rot").getRotation((CommandSourceStack)var0.getSource()))))).then(Commands.literal("as").then(Commands.argument("targets", EntityArgument.entities()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var0, "targets")) {
                var1.add(((CommandSourceStack)var0.getSource()).withRotation(entity.getRotationVector()));
            }
            return var1;
        }))))).then(((LiteralArgumentBuilder)Commands.literal("facing").then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(Commands.argument("anchor", EntityAnchorArgument.anchor()).fork(var2, var0 -> {
            ArrayList var1 = Lists.newArrayList();
            EntityAnchorArgument.Anchor var2 = EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)var0, "anchor");
            for (Entity entity : EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var0, "targets")) {
                var1.add(((CommandSourceStack)var0.getSource()).facing(entity, var2));
            }
            return var1;
        }))))).then(Commands.argument("pos", Vec3Argument.vec3()).redirect(var2, var0 -> ((CommandSourceStack)var0.getSource()).facing(Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos")))))).then(Commands.literal("align").then(Commands.argument("axes", SwizzleArgument.swizzle()).redirect(var2, var0 -> ((CommandSourceStack)var0.getSource()).withPosition(((CommandSourceStack)var0.getSource()).getPosition().align(SwizzleArgument.getSwizzle((CommandContext<CommandSourceStack>)var0, "axes"))))))).then(Commands.literal("anchored").then(Commands.argument("anchor", EntityAnchorArgument.anchor()).redirect(var2, var0 -> ((CommandSourceStack)var0.getSource()).withAnchor(EntityAnchorArgument.getAnchor((CommandContext<CommandSourceStack>)var0, "anchor")))))).then(Commands.literal("in").then(Commands.argument("dimension", DimensionArgument.dimension()).redirect(var2, var0 -> ((CommandSourceStack)var0.getSource()).withLevel(DimensionArgument.getDimension((CommandContext<CommandSourceStack>)var0, "dimension")))))).then(Commands.literal("summon").then(Commands.argument("entity", ResourceArgument.resource(var1, Registries.ENTITY_TYPE)).suggests(SuggestionProviders.cast(SuggestionProviders.SUMMONABLE_ENTITIES)).redirect(var2, var0 -> ExecuteCommand.spawnEntityAndRedirect((CommandSourceStack)var0.getSource(), ResourceArgument.getSummonableEntityType((CommandContext<CommandSourceStack>)var0, "entity")))))).then(ExecuteCommand.createRelationOperations(var2, Commands.literal("on")))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapStores(LiteralCommandNode<CommandSourceStack> var0, LiteralArgumentBuilder<CommandSourceStack> var12, boolean var2) {
        var12.then(Commands.literal("score").then(Commands.argument("targets", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(Commands.argument("objective", ObjectiveArgument.objective()).redirect(var0, var1 -> ExecuteCommand.storeValue((CommandSourceStack)var1.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)var1, "targets"), ObjectiveArgument.getObjective((CommandContext<CommandSourceStack>)var1, "objective"), var2)))));
        var12.then(Commands.literal("bossbar").then(((RequiredArgumentBuilder)Commands.argument("id", IdentifierArgument.id()).suggests(BossBarCommands.SUGGEST_BOSS_BAR).then(Commands.literal("value").redirect(var0, var1 -> ExecuteCommand.storeValue((CommandSourceStack)var1.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var1), true, var2)))).then(Commands.literal("max").redirect(var0, var1 -> ExecuteCommand.storeValue((CommandSourceStack)var1.getSource(), BossBarCommands.getBossBar((CommandContext<CommandSourceStack>)var1), false, var2)))));
        for (DataCommands.DataProvider var4 : DataCommands.TARGET_PROVIDERS) {
            var4.wrap((ArgumentBuilder<CommandSourceStack, ?>)var12, var3 -> var3.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).then(Commands.literal("int").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> ExecuteCommand.storeData((CommandSourceStack)var2.getSource(), var4.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path"), var1 -> IntTag.valueOf((int)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(Commands.literal("float").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> ExecuteCommand.storeData((CommandSourceStack)var2.getSource(), var4.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path"), var1 -> FloatTag.valueOf((float)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(Commands.literal("short").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> ExecuteCommand.storeData((CommandSourceStack)var2.getSource(), var4.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path"), var1 -> ShortTag.valueOf((short)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(Commands.literal("long").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> ExecuteCommand.storeData((CommandSourceStack)var2.getSource(), var4.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path"), var1 -> LongTag.valueOf((long)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))).then(Commands.literal("double").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> ExecuteCommand.storeData((CommandSourceStack)var2.getSource(), var4.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path"), var1 -> DoubleTag.valueOf((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale")), var2))))).then(Commands.literal("byte").then(Commands.argument("scale", DoubleArgumentType.doubleArg()).redirect((CommandNode)var0, var2 -> ExecuteCommand.storeData((CommandSourceStack)var2.getSource(), var4.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path"), var1 -> ByteTag.valueOf((byte)((double)var1 * DoubleArgumentType.getDouble((CommandContext)var2, (String)"scale"))), var2))))));
        }
        return var12;
    }

    private static CommandSourceStack storeValue(CommandSourceStack var0, Collection<ScoreHolder> var1, Objective var2, boolean var3) {
        ServerScoreboard var42 = var0.getServer().getScoreboard();
        return var0.withCallback((var4, var5) -> {
            for (ScoreHolder var7 : var1) {
                ScoreAccess var8 = var42.getOrCreatePlayerScore(var7, var2);
                int var9 = var3 ? var5 : (var4 ? 1 : 0);
                var8.set(var9);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandSourceStack storeValue(CommandSourceStack var0, CustomBossEvent var1, boolean var2, boolean var32) {
        return var0.withCallback((var3, var4) -> {
            int var5;
            int n = var32 ? var4 : (var5 = var3 ? 1 : 0);
            if (var2) {
                var1.setValue(var5);
            } else {
                var1.setMax(var5);
            }
        }, CommandResultCallback::chain);
    }

    private static CommandSourceStack storeData(CommandSourceStack var0, DataAccessor var1, NbtPathArgument.NbtPath var2, IntFunction<Tag> var3, boolean var42) {
        return var0.withCallback((var4, var5) -> {
            try {
                CompoundTag var6 = var1.getData();
                int var7 = var42 ? var5 : (var4 ? 1 : 0);
                var2.set(var6, (Tag)var3.apply(var7));
                var1.setData(var6);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }, CommandResultCallback::chain);
    }

    private static boolean isChunkLoaded(ServerLevel var0, BlockPos var1) {
        ChunkPos var2 = new ChunkPos(var1);
        LevelChunk var3 = var0.getChunkSource().getChunkNow(var2.x, var2.z);
        if (var3 != null) {
            return var3.getFullStatus() == FullChunkStatus.ENTITY_TICKING && var0.areEntitiesLoaded(var2.toLong());
        }
        return false;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditionals(CommandNode<CommandSourceStack> var03, LiteralArgumentBuilder<CommandSourceStack> var12, boolean var2, CommandBuildContext var32) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var12.then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(var03, Commands.argument("block", BlockPredicateArgument.blockPredicate(var32)), var2, var0 -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)var0, "block").test(new BlockInWorld(((CommandSourceStack)var0.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos"), true))))))).then(Commands.literal("biome").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(ExecuteCommand.addConditional(var03, Commands.argument("biome", ResourceOrTagArgument.resourceOrTag(var32, Registries.BIOME)), var2, var0 -> ResourceOrTagArgument.getResourceOrTag((CommandContext<CommandSourceStack>)var0, "biome", Registries.BIOME).test(((CommandSourceStack)var0.getSource()).getLevel().getBiome(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos")))))))).then(Commands.literal("loaded").then(ExecuteCommand.addConditional(var03, Commands.argument("pos", BlockPosArgument.blockPos()), var2, var0 -> ExecuteCommand.isChunkLoaded(((CommandSourceStack)var0.getSource()).getLevel(), BlockPosArgument.getBlockPos((CommandContext<CommandSourceStack>)var0, "pos")))))).then(Commands.literal("dimension").then(ExecuteCommand.addConditional(var03, Commands.argument("dimension", DimensionArgument.dimension()), var2, var0 -> DimensionArgument.getDimension((CommandContext<CommandSourceStack>)var0, "dimension") == ((CommandSourceStack)var0.getSource()).getLevel())))).then(Commands.literal("score").then(Commands.argument("target", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targetObjective", ObjectiveArgument.objective()).then(Commands.literal("=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(var03, Commands.argument("sourceObjective", ObjectiveArgument.objective()), var2, var02 -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)var02, (int var0, int var1) -> var0 == var1)))))).then(Commands.literal("<").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(var03, Commands.argument("sourceObjective", ObjectiveArgument.objective()), var2, var02 -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)var02, (int var0, int var1) -> var0 < var1)))))).then(Commands.literal("<=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(var03, Commands.argument("sourceObjective", ObjectiveArgument.objective()), var2, var02 -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)var02, (int var0, int var1) -> var0 <= var1)))))).then(Commands.literal(">").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(var03, Commands.argument("sourceObjective", ObjectiveArgument.objective()), var2, var02 -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)var02, (int var0, int var1) -> var0 > var1)))))).then(Commands.literal(">=").then(Commands.argument("source", ScoreHolderArgument.scoreHolder()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).then(ExecuteCommand.addConditional(var03, Commands.argument("sourceObjective", ObjectiveArgument.objective()), var2, var02 -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)var02, (int var0, int var1) -> var0 >= var1)))))).then(Commands.literal("matches").then(ExecuteCommand.addConditional(var03, Commands.argument("range", RangeArgument.intRange()), var2, var0 -> ExecuteCommand.checkScore((CommandContext<CommandSourceStack>)var0, RangeArgument.Ints.getRange((CommandContext<CommandSourceStack>)var0, "range"))))))))).then(Commands.literal("blocks").then(Commands.argument("start", BlockPosArgument.blockPos()).then(Commands.argument("end", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("destination", BlockPosArgument.blockPos()).then(ExecuteCommand.addIfBlocksConditional(var03, Commands.literal("all"), var2, false))).then(ExecuteCommand.addIfBlocksConditional(var03, Commands.literal("masked"), var2, true))))))).then(Commands.literal("entity").then(((RequiredArgumentBuilder)Commands.argument("entities", EntityArgument.entities()).fork(var03, var1 -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)var1, var2, !EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var1, "entities").isEmpty()))).executes(ExecuteCommand.createNumericConditionalHandler(var2, var0 -> EntityArgument.getOptionalEntities((CommandContext<CommandSourceStack>)var0, "entities").size()))))).then(Commands.literal("predicate").then(ExecuteCommand.addConditional(var03, Commands.argument("predicate", ResourceOrIdArgument.lootPredicate(var32)), var2, var0 -> ExecuteCommand.checkCustomPredicate((CommandSourceStack)var0.getSource(), ResourceOrIdArgument.getLootPredicate((CommandContext<CommandSourceStack>)var0, "predicate")))))).then(Commands.literal("function").then(Commands.argument("name", FunctionArgument.functions()).suggests(FunctionCommand.SUGGEST_FUNCTION).fork(var03, (RedirectModifier)new ExecuteIfFunctionCustomModifier(var2))))).then(((LiteralArgumentBuilder)Commands.literal("items").then(Commands.literal("entity").then(Commands.argument("entities", EntityArgument.entities()).then(Commands.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)Commands.argument("item_predicate", ItemPredicateArgument.itemPredicate(var32)).fork(var03, var1 -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)var1, var2, ExecuteCommand.countItems(EntityArgument.getEntities((CommandContext<CommandSourceStack>)var1, "entities"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)var1, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)var1, "item_predicate")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(var2, var0 -> ExecuteCommand.countItems(EntityArgument.getEntities((CommandContext<CommandSourceStack>)var0, "entities"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)var0, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)var0, "item_predicate"))))))))).then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(Commands.argument("slots", SlotsArgument.slots()).then(((RequiredArgumentBuilder)Commands.argument("item_predicate", ItemPredicateArgument.itemPredicate(var32)).fork(var03, var1 -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)var1, var2, ExecuteCommand.countItems((CommandSourceStack)var1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var1, "pos"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)var1, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)var1, "item_predicate")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(var2, var0 -> ExecuteCommand.countItems((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos"), SlotsArgument.getSlots((CommandContext<CommandSourceStack>)var0, "slots"), ItemPredicateArgument.getItemPredicate((CommandContext<CommandSourceStack>)var0, "item_predicate")))))))))).then(Commands.literal("stopwatch").then(Commands.argument("id", IdentifierArgument.id()).suggests(StopwatchCommand.SUGGEST_STOPWATCHES).then(ExecuteCommand.addConditional(var03, Commands.argument("range", RangeArgument.floatRange()), var2, var0 -> ExecuteCommand.checkStopwatch((CommandContext<CommandSourceStack>)var0, RangeArgument.Floats.getRange((CommandContext<CommandSourceStack>)var0, "range"))))));
        for (DataCommands.DataProvider var5 : DataCommands.SOURCE_PROVIDERS) {
            var12.then(var5.wrap((ArgumentBuilder<CommandSourceStack, ?>)Commands.literal("data"), var3 -> var3.then(((RequiredArgumentBuilder)Commands.argument("path", NbtPathArgument.nbtPath()).fork(var03, var2 -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)var2, var2, ExecuteCommand.checkMatchingData(var5.access((CommandContext<CommandSourceStack>)var2), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var2, "path")) > 0))).executes(ExecuteCommand.createNumericConditionalHandler(var2, var1 -> ExecuteCommand.checkMatchingData(var5.access((CommandContext<CommandSourceStack>)var1), NbtPathArgument.getPath((CommandContext<CommandSourceStack>)var1, "path")))))));
        }
        return var12;
    }

    private static int countItems(Iterable<? extends SlotProvider> var0, SlotRange var1, Predicate<ItemStack> var2) {
        int var3 = 0;
        for (SlotProvider slotProvider : var0) {
            IntList var6 = var1.slots();
            for (int var7 = 0; var7 < var6.size(); ++var7) {
                ItemStack var10;
                int var8 = var6.getInt(var7);
                SlotAccess var9 = slotProvider.getSlot(var8);
                if (var9 == null || !var2.test(var10 = var9.get())) continue;
                var3 += var10.getCount();
            }
        }
        return var3;
    }

    private static int countItems(CommandSourceStack var0, BlockPos var1, SlotRange var2, Predicate<ItemStack> var3) throws CommandSyntaxException {
        int var4 = 0;
        Container var5 = ItemCommands.getContainer(var0, var1, ItemCommands.ERROR_SOURCE_NOT_A_CONTAINER);
        int var6 = var5.getContainerSize();
        IntList var7 = var2.slots();
        for (int var8 = 0; var8 < var7.size(); ++var8) {
            ItemStack var10;
            int var9 = var7.getInt(var8);
            if (var9 < 0 || var9 >= var6 || !var3.test(var10 = var5.getItem(var9))) continue;
            var4 += var10.getCount();
        }
        return var4;
    }

    private static Command<CommandSourceStack> createNumericConditionalHandler(boolean var0, CommandNumericPredicate var12) {
        if (var0) {
            return var1 -> {
                int var2 = var12.test((CommandContext<CommandSourceStack>)var1);
                if (var2 > 0) {
                    ((CommandSourceStack)var1.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass_count", var2), false);
                    return var2;
                }
                throw ERROR_CONDITIONAL_FAILED.create();
            };
        }
        return var1 -> {
            int var2 = var12.test((CommandContext<CommandSourceStack>)var1);
            if (var2 == 0) {
                ((CommandSourceStack)var1.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)var2);
        };
    }

    private static int checkMatchingData(DataAccessor var0, NbtPathArgument.NbtPath var1) throws CommandSyntaxException {
        return var1.countMatching(var0.getData());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> var0, IntBiPredicate var1) throws CommandSyntaxException {
        ScoreHolder var2 = ScoreHolderArgument.getName(var0, "target");
        Objective var3 = ObjectiveArgument.getObjective(var0, "targetObjective");
        ScoreHolder var4 = ScoreHolderArgument.getName(var0, "source");
        Objective var5 = ObjectiveArgument.getObjective(var0, "sourceObjective");
        ServerScoreboard var6 = ((CommandSourceStack)var0.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo var7 = var6.getPlayerScoreInfo(var2, var3);
        ReadOnlyScoreInfo var8 = var6.getPlayerScoreInfo(var4, var5);
        if (var7 == null || var8 == null) {
            return false;
        }
        return var1.test(var7.value(), var8.value());
    }

    private static boolean checkScore(CommandContext<CommandSourceStack> var0, MinMaxBounds.Ints var1) throws CommandSyntaxException {
        ScoreHolder var2 = ScoreHolderArgument.getName(var0, "target");
        Objective var3 = ObjectiveArgument.getObjective(var0, "targetObjective");
        ServerScoreboard var4 = ((CommandSourceStack)var0.getSource()).getServer().getScoreboard();
        ReadOnlyScoreInfo var5 = var4.getPlayerScoreInfo(var2, var3);
        if (var5 == null) {
            return false;
        }
        return var1.matches(var5.value());
    }

    private static boolean checkStopwatch(CommandContext<CommandSourceStack> var0, MinMaxBounds.Doubles var1) throws CommandSyntaxException {
        Identifier var2 = IdentifierArgument.getId(var0, "id");
        Stopwatches var3 = ((CommandSourceStack)var0.getSource()).getServer().getStopwatches();
        Stopwatch var4 = var3.get(var2);
        if (var4 == null) {
            throw StopwatchCommand.ERROR_DOES_NOT_EXIST.create((Object)var2);
        }
        long var5 = Stopwatches.currentTime();
        double var7 = var4.elapsedSeconds(var5);
        return var1.matches(var7);
    }

    private static boolean checkCustomPredicate(CommandSourceStack var0, Holder<LootItemCondition> var1) {
        ServerLevel var2 = var0.getLevel();
        LootParams var3 = new LootParams.Builder(var2).withParameter(LootContextParams.ORIGIN, var0.getPosition()).withOptionalParameter(LootContextParams.THIS_ENTITY, var0.getEntity()).create(LootContextParamSets.COMMAND);
        LootContext var4 = new LootContext.Builder(var3).create(Optional.empty());
        var4.pushVisitedElement(LootContext.createVisitedEntry(var1.value()));
        return var1.value().test(var4);
    }

    private static Collection<CommandSourceStack> expect(CommandContext<CommandSourceStack> var0, boolean var1, boolean var2) {
        if (var2 == var1) {
            return Collections.singleton((CommandSourceStack)var0.getSource());
        }
        return Collections.emptyList();
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addConditional(CommandNode<CommandSourceStack> var0, ArgumentBuilder<CommandSourceStack, ?> var1, boolean var22, CommandPredicate var3) {
        return var1.fork(var0, var2 -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)var2, var22, var3.test((CommandContext<CommandSourceStack>)var2))).executes(var2 -> {
            if (var22 == var3.test((CommandContext<CommandSourceStack>)var2)) {
                ((CommandSourceStack)var2.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
                return 1;
            }
            throw ERROR_CONDITIONAL_FAILED.create();
        });
    }

    private static ArgumentBuilder<CommandSourceStack, ?> addIfBlocksConditional(CommandNode<CommandSourceStack> var0, ArgumentBuilder<CommandSourceStack, ?> var12, boolean var22, boolean var3) {
        return var12.fork(var0, var2 -> ExecuteCommand.expect((CommandContext<CommandSourceStack>)var2, var22, ExecuteCommand.checkRegions((CommandContext<CommandSourceStack>)var2, var3).isPresent())).executes(var22 ? var1 -> ExecuteCommand.checkIfRegions((CommandContext<CommandSourceStack>)var1, var3) : var1 -> ExecuteCommand.checkUnlessRegions((CommandContext<CommandSourceStack>)var1, var3));
    }

    private static int checkIfRegions(CommandContext<CommandSourceStack> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = ExecuteCommand.checkRegions(var0, var1);
        if (var2.isPresent()) {
            ((CommandSourceStack)var0.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass_count", var2.getAsInt()), false);
            return var2.getAsInt();
        }
        throw ERROR_CONDITIONAL_FAILED.create();
    }

    private static int checkUnlessRegions(CommandContext<CommandSourceStack> var0, boolean var1) throws CommandSyntaxException {
        OptionalInt var2 = ExecuteCommand.checkRegions(var0, var1);
        if (var2.isPresent()) {
            throw ERROR_CONDITIONAL_FAILED_COUNT.create((Object)var2.getAsInt());
        }
        ((CommandSourceStack)var0.getSource()).sendSuccess(() -> Component.translatable("commands.execute.conditional.pass"), false);
        return 1;
    }

    private static OptionalInt checkRegions(CommandContext<CommandSourceStack> var0, boolean var1) throws CommandSyntaxException {
        return ExecuteCommand.checkRegions(((CommandSourceStack)var0.getSource()).getLevel(), BlockPosArgument.getLoadedBlockPos(var0, "start"), BlockPosArgument.getLoadedBlockPos(var0, "end"), BlockPosArgument.getLoadedBlockPos(var0, "destination"), var1);
    }

    private static OptionalInt checkRegions(ServerLevel var0, BlockPos var1, BlockPos var2, BlockPos var3, boolean var4) throws CommandSyntaxException {
        BoundingBox var5 = BoundingBox.fromCorners(var1, var2);
        BoundingBox var6 = BoundingBox.fromCorners(var3, var3.offset(var5.getLength()));
        BlockPos var7 = new BlockPos(var6.minX() - var5.minX(), var6.minY() - var5.minY(), var6.minZ() - var5.minZ());
        int var8 = var5.getXSpan() * var5.getYSpan() * var5.getZSpan();
        if (var8 > 32768) {
            throw ERROR_AREA_TOO_LARGE.create((Object)32768, (Object)var8);
        }
        int var9 = 0;
        RegistryAccess var10 = var0.registryAccess();
        try (ProblemReporter.ScopedCollector var11 = new ProblemReporter.ScopedCollector(LOGGER);){
            for (int var12 = var5.minZ(); var12 <= var5.maxZ(); ++var12) {
                for (int var13 = var5.minY(); var13 <= var5.maxY(); ++var13) {
                    for (int var14 = var5.minX(); var14 <= var5.maxX(); ++var14) {
                        BlockPos var15 = new BlockPos(var14, var13, var12);
                        BlockPos var16 = var15.offset(var7);
                        BlockState var17 = var0.getBlockState(var15);
                        if (var4 && var17.is(Blocks.AIR)) continue;
                        if (var17 != var0.getBlockState(var16)) {
                            OptionalInt optionalInt = OptionalInt.empty();
                            return optionalInt;
                        }
                        BlockEntity var18 = var0.getBlockEntity(var15);
                        BlockEntity var19 = var0.getBlockEntity(var16);
                        if (var18 != null) {
                            OptionalInt optionalInt;
                            if (var19 == null) {
                                optionalInt = OptionalInt.empty();
                                return optionalInt;
                            }
                            if (var19.getType() != var18.getType()) {
                                optionalInt = OptionalInt.empty();
                                return optionalInt;
                            }
                            if (!var18.components().equals(var19.components())) {
                                optionalInt = OptionalInt.empty();
                                return optionalInt;
                            }
                            TagValueOutput var20 = TagValueOutput.createWithContext(var11.forChild(var18.problemPath()), var10);
                            var18.saveCustomOnly(var20);
                            CompoundTag var21 = var20.buildResult();
                            TagValueOutput var22 = TagValueOutput.createWithContext(var11.forChild(var19.problemPath()), var10);
                            var19.saveCustomOnly(var22);
                            CompoundTag var23 = var22.buildResult();
                            if (!var21.equals(var23)) {
                                OptionalInt optionalInt2 = OptionalInt.empty();
                                return optionalInt2;
                            }
                        }
                        ++var9;
                    }
                }
            }
        }
        return OptionalInt.of(var9);
    }

    private static RedirectModifier<CommandSourceStack> expandOneToOneEntityRelation(Function<Entity, Optional<Entity>> var0) {
        return var12 -> {
            CommandSourceStack var2 = (CommandSourceStack)var12.getSource();
            Entity var3 = var2.getEntity();
            if (var3 == null) {
                return List.of();
            }
            return ((Optional)var0.apply(var3)).filter(var0 -> !var0.isRemoved()).map(var1 -> List.of(var2.withEntity((Entity)var1))).orElse(List.of());
        };
    }

    private static RedirectModifier<CommandSourceStack> expandOneToManyEntityRelation(Function<Entity, Stream<Entity>> var0) {
        return var1 -> {
            CommandSourceStack var2 = (CommandSourceStack)var1.getSource();
            Entity var3 = var2.getEntity();
            if (var3 == null) {
                return List.of();
            }
            return ((Stream)var0.apply(var3)).filter(var0 -> !var0.isRemoved()).map(var2::withEntity).toList();
        };
    }

    private static LiteralArgumentBuilder<CommandSourceStack> createRelationOperations(CommandNode<CommandSourceStack> var02, LiteralArgumentBuilder<CommandSourceStack> var1) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)var1.then(Commands.literal("owner").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof OwnableEntity) {
                OwnableEntity var1 = (OwnableEntity)((Object)var0);
                optional = Optional.ofNullable(var1.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("leasher").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Leashable) {
                Leashable var1 = (Leashable)((Object)var0);
                optional = Optional.ofNullable(var1.getLeashHolder());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("target").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Targeting) {
                Targeting var1 = (Targeting)((Object)var0);
                optional = Optional.ofNullable(var1.getTarget());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("attacker").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof Attackable) {
                Attackable var1 = (Attackable)((Object)var0);
                optional = Optional.ofNullable(var1.getLastAttacker());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("vehicle").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> Optional.ofNullable(var0.getVehicle()))))).then(Commands.literal("controller").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> Optional.ofNullable(var0.getControllingPassenger()))))).then(Commands.literal("origin").fork(var02, ExecuteCommand.expandOneToOneEntityRelation(var0 -> {
            Optional<Object> optional;
            if (var0 instanceof TraceableEntity) {
                TraceableEntity var1 = (TraceableEntity)((Object)var0);
                optional = Optional.ofNullable(var1.getOwner());
            } else {
                optional = Optional.empty();
            }
            return optional;
        })))).then(Commands.literal("passengers").fork(var02, ExecuteCommand.expandOneToManyEntityRelation(var0 -> var0.getPassengers().stream())));
    }

    private static CommandSourceStack spawnEntityAndRedirect(CommandSourceStack var0, Holder.Reference<EntityType<?>> var1) throws CommandSyntaxException {
        Entity var2 = SummonCommand.createEntity(var0, var1, var0.getPosition(), new CompoundTag(), true);
        return var0.withEntity(var2);
    }

    /*
     * Exception decompiling
     */
    public static <T extends ExecutionCommandSource<T>> void scheduleFunctionConditionsAndTest(T var0, List<T> var1, Function<T, T> var2, IntPredicate var3, ContextChain<T> var4, @Nullable CompoundTag var5, ExecutionControl<T> var6, InCommandFunction<CommandContext<T>, Collection<CommandFunction<T>>> var7, ChainModifiers var8) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ void lambda$scheduleFunctionConditionsAndTest$87(List var0, ExecutionCommandSource var1, ExecutionControl var2) {
        for (InstantiatedFunction var4 : var0) {
            var2.queueNext(new CallFunction<ExecutionCommandSource>(var4, var2.currentFrame().returnValueConsumer(), true).bind(var1));
        }
        var2.queueNext(FallthroughTask.instance());
    }

    private static /* synthetic */ void lambda$scheduleFunctionConditionsAndTest$86(IntPredicate var0, List var1, ExecutionCommandSource var2, boolean var3, int var4) {
        if (var0.test(var4)) {
            var1.add(var2);
        }
    }

    @FunctionalInterface
    static interface CommandPredicate {
        public boolean test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    @FunctionalInterface
    static interface CommandNumericPredicate {
        public int test(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;
    }

    static class ExecuteIfFunctionCustomModifier
    implements CustomModifierExecutor.ModifierAdapter<CommandSourceStack> {
        private final IntPredicate check;

        ExecuteIfFunctionCustomModifier(boolean var02) {
            this.check = var02 ? var0 -> var0 != 0 : var0 -> var0 == 0;
        }

        @Override
        public void apply(CommandSourceStack var02, List<CommandSourceStack> var1, ContextChain<CommandSourceStack> var2, ChainModifiers var3, ExecutionControl<CommandSourceStack> var4) {
            ExecuteCommand.scheduleFunctionConditionsAndTest(var02, var1, FunctionCommand::modifySenderForExecution, this.check, var2, null, var4, var0 -> FunctionArgument.getFunctions((CommandContext<CommandSourceStack>)var0, "name"), var3);
        }
    }

    @FunctionalInterface
    static interface IntBiPredicate {
        public boolean test(int var1, int var2);
    }
}

