/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.objects.PlayerSprite;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.ProfileResolver;
import net.minecraft.util.Util;
import net.minecraft.world.item.component.ResolvableProfile;

public class FetchProfileCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("fetchprofile").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("name").then(Commands.argument("name", StringArgumentType.greedyString()).executes(var0 -> FetchProfileCommand.resolveName((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"name")))))).then(Commands.literal("id").then(Commands.argument("id", UuidArgument.uuid()).executes(var0 -> FetchProfileCommand.resolveId((CommandSourceStack)var0.getSource(), UuidArgument.getUuid((CommandContext<CommandSourceStack>)var0, "id")))))));
    }

    private static void reportResolvedProfile(CommandSourceStack var0, GameProfile var12, String var2, Component var3) {
        ResolvableProfile var42 = ResolvableProfile.createResolved(var12);
        ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)var42).ifSuccess(var4 -> {
            String var52 = var4.toString();
            MutableComponent var6 = Component.object(new PlayerSprite(var42, true));
            ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)var6).ifSuccess(var5 -> {
                String var6 = var5.toString();
                var0.sendSuccess(() -> {
                    Object var5 = ComponentUtils.formatList(List.of(Component.translatable("commands.fetchprofile.copy_component").withStyle(var1 -> var1.withClickEvent(new ClickEvent.CopyToClipboard(var52))), Component.translatable("commands.fetchprofile.give_item").withStyle(var1 -> var1.withClickEvent(new ClickEvent.RunCommand("give @s minecraft:player_head[profile=" + var52 + "]"))), Component.translatable("commands.fetchprofile.summon_mannequin").withStyle(var1 -> var1.withClickEvent(new ClickEvent.RunCommand("summon minecraft:mannequin ~ ~ ~ {profile:" + var52 + "}"))), Component.translatable("commands.fetchprofile.copy_text", var6.withStyle(ChatFormatting.WHITE)).withStyle(var1 -> var1.withClickEvent(new ClickEvent.CopyToClipboard(var6)))), CommonComponents.SPACE, var0 -> ComponentUtils.wrapInSquareBrackets(var0.withStyle(ChatFormatting.GREEN)));
                    return Component.translatable(var2, var3, var5);
                }, false);
            }).ifError(var1 -> var0.sendFailure(Component.translatable("commands.fetchprofile.failed_to_serialize", var1.message())));
        }).ifError(var1 -> var0.sendFailure(Component.translatable("commands.fetchprofile.failed_to_serialize", var1.message())));
    }

    private static int resolveName(CommandSourceStack var0, String var1) {
        MinecraftServer var2 = var0.getServer();
        ProfileResolver var3 = var2.services().profileResolver();
        Util.nonCriticalIoPool().execute(() -> {
            MutableComponent var4 = Component.literal(var1);
            Optional<GameProfile> var5 = var3.fetchByName(var1);
            var2.execute(() -> var5.ifPresentOrElse(var2 -> FetchProfileCommand.reportResolvedProfile(var0, var2, "commands.fetchprofile.name.success", var4), () -> var0.sendFailure(Component.translatable("commands.fetchprofile.name.failure", var4))));
        });
        return 1;
    }

    private static int resolveId(CommandSourceStack var0, UUID var1) {
        MinecraftServer var2 = var0.getServer();
        ProfileResolver var3 = var2.services().profileResolver();
        Util.nonCriticalIoPool().execute(() -> {
            Component var4 = Component.translationArg(var1);
            Optional<GameProfile> var5 = var3.fetchById(var1);
            var2.execute(() -> var5.ifPresentOrElse(var2 -> FetchProfileCommand.reportResolvedProfile(var0, var2, "commands.fetchprofile.id.success", var4), () -> var0.sendFailure(Component.translatable("commands.fetchprofile.id.failure", var4))));
        });
        return 1;
    }
}

