/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockPredicateArgument;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.InCommandFunction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.jspecify.annotations.Nullable;

public class FillCommand {
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> Component.translatableEscape("commands.fill.toobig", var0, var1));
    static final BlockInput HOLLOW_CORE = new BlockInput(Blocks.AIR.defaultBlockState(), Collections.emptySet(), null);
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.fill.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var03, CommandBuildContext var1) {
        var03.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("fill").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("from", BlockPosArgument.blockPos()).then(Commands.argument("to", BlockPosArgument.blockPos()).then(FillCommand.wrapWithMode(var1, Commands.argument("block", BlockStateArgument.block(var1)), var0 -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "from"), var0 -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "to"), var0 -> BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), var0 -> null).then(((LiteralArgumentBuilder)Commands.literal("replace").executes(var0 -> FillCommand.fillBlocks((CommandSourceStack)var0.getSource(), BoundingBox.fromCorners(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "to")), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), Mode.REPLACE, null, false))).then(FillCommand.wrapWithMode(var1, Commands.argument("filter", BlockPredicateArgument.blockPredicate(var1)), var0 -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "from"), var0 -> BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "to"), var0 -> BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), var0 -> BlockPredicateArgument.getBlockPredicate((CommandContext<CommandSourceStack>)var0, "filter")))).then(Commands.literal("keep").executes(var02 -> FillCommand.fillBlocks((CommandSourceStack)var02.getSource(), BoundingBox.fromCorners(BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var02, "from"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var02, "to")), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var02, "block"), Mode.REPLACE, var0 -> var0.getLevel().isEmptyBlock(var0.getPos()), false))))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> wrapWithMode(CommandBuildContext var0, ArgumentBuilder<CommandSourceStack, ?> var1, InCommandFunction<CommandContext<CommandSourceStack>, BlockPos> var2, InCommandFunction<CommandContext<CommandSourceStack>, BlockPos> var3, InCommandFunction<CommandContext<CommandSourceStack>, BlockInput> var42, NullableCommandFunction<CommandContext<CommandSourceStack>, Predicate<BlockInWorld>> var5) {
        return var1.executes(var4 -> FillCommand.fillBlocks((CommandSourceStack)var4.getSource(), BoundingBox.fromCorners((Vec3i)var2.apply(var4), (Vec3i)var3.apply(var4)), (BlockInput)var42.apply(var4), Mode.REPLACE, (Predicate)var5.apply(var4), false)).then(Commands.literal("outline").executes(var4 -> FillCommand.fillBlocks((CommandSourceStack)var4.getSource(), BoundingBox.fromCorners((Vec3i)var2.apply(var4), (Vec3i)var3.apply(var4)), (BlockInput)var42.apply(var4), Mode.OUTLINE, (Predicate)var5.apply(var4), false))).then(Commands.literal("hollow").executes(var4 -> FillCommand.fillBlocks((CommandSourceStack)var4.getSource(), BoundingBox.fromCorners((Vec3i)var2.apply(var4), (Vec3i)var3.apply(var4)), (BlockInput)var42.apply(var4), Mode.HOLLOW, (Predicate)var5.apply(var4), false))).then(Commands.literal("destroy").executes(var4 -> FillCommand.fillBlocks((CommandSourceStack)var4.getSource(), BoundingBox.fromCorners((Vec3i)var2.apply(var4), (Vec3i)var3.apply(var4)), (BlockInput)var42.apply(var4), Mode.DESTROY, (Predicate)var5.apply(var4), false))).then(Commands.literal("strict").executes(var4 -> FillCommand.fillBlocks((CommandSourceStack)var4.getSource(), BoundingBox.fromCorners((Vec3i)var2.apply(var4), (Vec3i)var3.apply(var4)), (BlockInput)var42.apply(var4), Mode.REPLACE, (Predicate)var5.apply(var4), true)));
    }

    private static int fillBlocks(CommandSourceStack var0, BoundingBox var1, BlockInput var2, Mode var3, @Nullable Predicate<BlockInWorld> var4, boolean var5) throws CommandSyntaxException {
        final class UpdatedPosition
        extends Record {
            final BlockPos pos;
            final BlockState oldState;

            UpdatedPosition(BlockPos var0, BlockState var1) {
                this.pos = var0;
                this.oldState = var1;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{UpdatedPosition.class, "pos;oldState", "pos", "oldState"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UpdatedPosition.class, "pos;oldState", "pos", "oldState"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UpdatedPosition.class, "pos;oldState", "pos", "oldState"}, this, var0);
            }

            public BlockPos pos() {
                return this.pos;
            }

            public BlockState oldState() {
                return this.oldState;
            }
        }
        int var7;
        int var6 = var1.getXSpan() * var1.getYSpan() * var1.getZSpan();
        if (var6 > (var7 = var0.getLevel().getGameRules().get(GameRules.MAX_BLOCK_MODIFICATIONS).intValue())) {
            throw ERROR_AREA_TOO_LARGE.create((Object)var7, (Object)var6);
        }
        ArrayList var8 = Lists.newArrayList();
        ServerLevel var9 = var0.getLevel();
        if (var9.isDebug()) {
            throw ERROR_FAILED.create();
        }
        int var10 = 0;
        for (BlockPos blockPos : BlockPos.betweenClosed(var1.minX(), var1.minY(), var1.minZ(), var1.maxX(), var1.maxY(), var1.maxZ())) {
            BlockInput var15;
            if (var4 != null && !var4.test(new BlockInWorld(var9, blockPos, true))) continue;
            BlockState var13 = var9.getBlockState(blockPos);
            boolean var14 = false;
            if (var3.affector.affect(var9, blockPos)) {
                var14 = true;
            }
            if ((var15 = var3.filter.filter(var1, blockPos, var2, var9)) == null) {
                if (!var14) continue;
                ++var10;
                continue;
            }
            if (!var15.place(var9, blockPos, 2 | (var5 ? 816 : 256))) {
                if (!var14) continue;
                ++var10;
                continue;
            }
            if (!var5) {
                var8.add(new UpdatedPosition(blockPos.immutable(), var13));
            }
            ++var10;
        }
        for (UpdatedPosition updatedPosition : var8) {
            var9.updateNeighboursOnBlockSet(updatedPosition.pos, updatedPosition.oldState);
        }
        if (var10 == 0) {
            throw ERROR_FAILED.create();
        }
        int var11 = var10;
        var0.sendSuccess(() -> Component.translatable("commands.fill.success", var11), true);
        return var10;
    }

    @FunctionalInterface
    static interface NullableCommandFunction<T, R> {
        public @Nullable R apply(T var1) throws CommandSyntaxException;
    }

    static enum Mode {
        REPLACE(Affector.NOOP, Filter.NOOP),
        OUTLINE(Affector.NOOP, (var0, var1, var2, var3) -> {
            if (var1.getX() == var0.minX() || var1.getX() == var0.maxX() || var1.getY() == var0.minY() || var1.getY() == var0.maxY() || var1.getZ() == var0.minZ() || var1.getZ() == var0.maxZ()) {
                return var2;
            }
            return null;
        }),
        HOLLOW(Affector.NOOP, (var0, var1, var2, var3) -> {
            if (var1.getX() == var0.minX() || var1.getX() == var0.maxX() || var1.getY() == var0.minY() || var1.getY() == var0.maxY() || var1.getZ() == var0.minZ() || var1.getZ() == var0.maxZ()) {
                return var2;
            }
            return HOLLOW_CORE;
        }),
        DESTROY((var0, var1) -> var0.destroyBlock(var1, true), Filter.NOOP);

        public final Filter filter;
        public final Affector affector;

        private Mode(Affector var2, Filter var3) {
            this.affector = var2;
            this.filter = var3;
        }
    }

    @FunctionalInterface
    public static interface Affector {
        public static final Affector NOOP = (var0, var1) -> false;

        public boolean affect(ServerLevel var1, BlockPos var2);
    }

    @FunctionalInterface
    public static interface Filter {
        public static final Filter NOOP = (var0, var1, var2, var3) -> var2;

        public @Nullable BlockInput filter(BoundingBox var1, BlockPos var2, BlockInput var3, ServerLevel var4);
    }
}

