/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GiveCommand {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher, CommandBuildContext commandbuildcontext) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("give").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item(commandbuildcontext)).executes(commandcontext -> GiveCommand.giveItem((CommandSourceStack)commandcontext.getSource(), ItemArgument.getItem(commandcontext, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), 1))).then(Commands.argument("count", IntegerArgumentType.integer((int)1)).executes(commandcontext -> GiveCommand.giveItem((CommandSourceStack)commandcontext.getSource(), ItemArgument.getItem(commandcontext, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"count"))))))));
    }

    private static int giveItem(CommandSourceStack commandlistenerwrapper, ItemInput argumentpredicateitemstack, Collection<ServerPlayer> collection, int i) throws CommandSyntaxException {
        ItemStack itemstack = argumentpredicateitemstack.createItemStack(1, false);
        int j = itemstack.getMaxStackSize();
        int k = j * 100;
        if (i > k) {
            commandlistenerwrapper.sendFailure(Component.translatable("commands.give.failed.toomanyitems", k, itemstack.getDisplayName()));
            return 0;
        }
        for (ServerPlayer entityplayer : collection) {
            int l = i;
            while (l > 0) {
                int i1 = Math.min(j, l);
                l -= i1;
                ItemStack itemstack1 = argumentpredicateitemstack.createItemStack(i1, false);
                boolean flag = entityplayer.getInventory().add(itemstack1);
                if (flag && itemstack1.isEmpty()) {
                    ItemEntity entityitem = entityplayer.drop(itemstack, false, false, false);
                    if (entityitem != null) {
                        entityitem.makeFakeItem();
                    }
                    entityplayer.level().playSound((Entity)null, entityplayer.getX(), entityplayer.getY(), entityplayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((entityplayer.getRandom().nextFloat() - entityplayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    entityplayer.containerMenu.broadcastChanges();
                    continue;
                }
                ItemEntity entityitem1 = entityplayer.drop(itemstack1, false);
                if (entityitem1 == null) continue;
                entityitem1.setNoPickUpDelay();
                entityitem1.setTarget(entityplayer.getUUID());
            }
        }
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.give.success.single", i, itemstack.getDisplayName(), ((ServerPlayer)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.give.success.single", i, itemstack.getDisplayName(), collection.size()), true);
        }
        return collection.size();
    }
}

