/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class KickCommand {
    private static final SimpleCommandExceptionType ERROR_KICKING_OWNER = new SimpleCommandExceptionType((Message)Component.translatable("commands.kick.owner.failed"));
    private static final SimpleCommandExceptionType ERROR_SINGLEPLAYER = new SimpleCommandExceptionType((Message)Component.translatable("commands.kick.singleplayer.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("kick").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(var0 -> KickCommand.kickPlayers((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), Component.translatable("multiplayer.disconnect.kicked")))).then(Commands.argument("reason", MessageArgument.message()).executes(var0 -> KickCommand.kickPlayers((CommandSourceStack)var0.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "targets"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)var0, "reason")))))));
    }

    private static int kickPlayers(CommandSourceStack var0, Collection<ServerPlayer> var1, Component var2) throws CommandSyntaxException {
        if (!var0.getServer().isPublished()) {
            throw ERROR_SINGLEPLAYER.create();
        }
        int var3 = 0;
        for (ServerPlayer var5 : var1) {
            if (var0.getServer().isSingleplayerOwner(var5.nameAndId())) continue;
            var5.connection.disconnect(var2);
            var0.sendSuccess(() -> Component.translatable("commands.kick.success", var5.getDisplayName(), var2), true);
            ++var3;
        }
        if (var3 == 0) {
            throw ERROR_KICKING_OWNER.create();
        }
        return var3;
    }
}

