/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.net.InetAddresses;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.players.IpBanList;

public class PardonIpCommand {
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("commands.pardonip.invalid"));
    private static final SimpleCommandExceptionType ERROR_NOT_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.pardonip.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("pardon-ip").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(Commands.argument("target", StringArgumentType.word()).suggests((var0, var1) -> SharedSuggestionProvider.suggest(((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getIpBans().getUserList(), var1)).executes(var0 -> PardonIpCommand.unban((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"target"))))));
    }

    private static int unban(CommandSourceStack var0, String var1) throws CommandSyntaxException {
        if (!InetAddresses.isInetAddress((String)var1)) {
            throw ERROR_INVALID.create();
        }
        IpBanList var2 = var0.getServer().getPlayerList().getIpBans();
        if (!var2.isBanned(var1)) {
            throw ERROR_NOT_BANNED.create();
        }
        var2.remove(var1);
        var0.sendSuccess(() -> Component.translatable("commands.pardonip.success", var1), true);
        return 1;
    }
}

