/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class ParticleCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.particle.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("particle").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((RequiredArgumentBuilder)Commands.argument("name", ParticleArgument.particle(var1)).executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), ((CommandSourceStack)var0.getSource()).getPosition(), Vec3.ZERO, 0.0f, 0, false, ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(((RequiredArgumentBuilder)Commands.argument("pos", Vec3Argument.vec3()).executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos"), Vec3.ZERO, 0.0f, 0, false, ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(Commands.argument("delta", Vec3Argument.vec3(false)).then(Commands.argument("speed", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("count", IntegerArgumentType.integer((int)0)).executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), false, ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(((LiteralArgumentBuilder)Commands.literal("force").executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true, ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(Commands.argument("viewers", EntityArgument.players()).executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "viewers")))))).then(((LiteralArgumentBuilder)Commands.literal("normal").executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), false, ((CommandSourceStack)var0.getSource()).getServer().getPlayerList().getPlayers()))).then(Commands.argument("viewers", EntityArgument.players()).executes(var0 -> ParticleCommand.sendParticles((CommandSourceStack)var0.getSource(), ParticleArgument.getParticle((CommandContext<CommandSourceStack>)var0, "name"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "pos"), Vec3Argument.getVec3((CommandContext<CommandSourceStack>)var0, "delta"), FloatArgumentType.getFloat((CommandContext)var0, (String)"speed"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), false, EntityArgument.getPlayers((CommandContext<CommandSourceStack>)var0, "viewers"))))))))))));
    }

    private static int sendParticles(CommandSourceStack var0, ParticleOptions var1, Vec3 var2, Vec3 var3, float var4, int var5, boolean var6, Collection<ServerPlayer> var7) throws CommandSyntaxException {
        int var8 = 0;
        for (ServerPlayer var10 : var7) {
            if (!var0.getLevel().sendParticles(var10, var1, var6, false, var2.x, var2.y, var2.z, var5, var3.x, var3.y, var3.z, var4)) continue;
            ++var8;
        }
        if (var8 == 0) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(() -> Component.translatable("commands.particle.success", BuiltInRegistries.PARTICLE_TYPE.getKey(var1.getType()).toString()), true);
        return var8;
    }
}

