/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class RaidCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("raid").requires(Commands.hasPermission(Commands.LEVEL_ADMINS))).then(Commands.literal("start").then(Commands.argument("omenlvl", IntegerArgumentType.integer((int)0)).executes(var0 -> RaidCommand.start((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"omenlvl")))))).then(Commands.literal("stop").executes(var0 -> RaidCommand.stop((CommandSourceStack)var0.getSource())))).then(Commands.literal("check").executes(var0 -> RaidCommand.check((CommandSourceStack)var0.getSource())))).then(Commands.literal("sound").then(Commands.argument("type", ComponentArgument.textComponent(var1)).executes(var0 -> RaidCommand.playSound((CommandSourceStack)var0.getSource(), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "type")))))).then(Commands.literal("spawnleader").executes(var0 -> RaidCommand.spawnLeader((CommandSourceStack)var0.getSource())))).then(Commands.literal("setomen").then(Commands.argument("level", IntegerArgumentType.integer((int)0)).executes(var0 -> RaidCommand.setRaidOmenLevel((CommandSourceStack)var0.getSource(), IntegerArgumentType.getInteger((CommandContext)var0, (String)"level")))))).then(Commands.literal("glow").executes(var0 -> RaidCommand.glow((CommandSourceStack)var0.getSource())))));
    }

    private static int glow(CommandSourceStack var0) throws CommandSyntaxException {
        Raid var1 = RaidCommand.getRaid(var0.getPlayerOrException());
        if (var1 != null) {
            Set<Raider> var2 = var1.getAllRaiders();
            for (Raider var4 : var2) {
                var4.addEffect(new MobEffectInstance(MobEffects.GLOWING, 1000, 1));
            }
        }
        return 1;
    }

    private static int setRaidOmenLevel(CommandSourceStack var0, int var1) throws CommandSyntaxException {
        Raid var2 = RaidCommand.getRaid(var0.getPlayerOrException());
        if (var2 != null) {
            int var3 = var2.getMaxRaidOmenLevel();
            if (var1 > var3) {
                var0.sendFailure(Component.literal("Sorry, the max raid omen level you can set is " + var3));
            } else {
                int var4 = var2.getRaidOmenLevel();
                var2.setRaidOmenLevel(var1);
                var0.sendSuccess(() -> Component.literal("Changed village's raid omen level from " + var4 + " to " + var1), false);
            }
        } else {
            var0.sendFailure(Component.literal("No raid found here"));
        }
        return 1;
    }

    private static int spawnLeader(CommandSourceStack var0) {
        var0.sendSuccess(() -> Component.literal("Spawned a raid captain"), false);
        Raider var1 = EntityType.PILLAGER.create(var0.getLevel(), EntitySpawnReason.COMMAND);
        if (var1 == null) {
            var0.sendFailure(Component.literal("Pillager failed to spawn"));
            return 0;
        }
        var1.setPatrolLeader(true);
        var1.setItemSlot(EquipmentSlot.HEAD, Raid.getOminousBannerInstance(var0.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        var1.setPos(var0.getPosition().x, var0.getPosition().y, var0.getPosition().z);
        var1.finalizeSpawn(var0.getLevel(), var0.getLevel().getCurrentDifficultyAt(BlockPos.containing(var0.getPosition())), EntitySpawnReason.COMMAND, null);
        var0.getLevel().addFreshEntityWithPassengers(var1);
        return 1;
    }

    private static int playSound(CommandSourceStack var0, @Nullable Component var1) {
        if (var1 != null && var1.getString().equals("local")) {
            ServerLevel var2 = var0.getLevel();
            Vec3 var3 = var0.getPosition().add(5.0, 0.0, 0.0);
            var2.playSeededSound(null, var3.x, var3.y, var3.z, SoundEvents.RAID_HORN, SoundSource.NEUTRAL, 2.0f, 1.0f, var2.random.nextLong());
        }
        return 1;
    }

    private static int start(CommandSourceStack var0, int var1) throws CommandSyntaxException {
        ServerPlayer var2 = var0.getPlayerOrException();
        BlockPos var3 = var2.blockPosition();
        if (var2.level().isRaided(var3)) {
            var0.sendFailure(Component.literal("Raid already started close by"));
            return -1;
        }
        Raids var4 = var2.level().getRaids();
        Raid var5 = var4.createOrExtendRaid(var2, var2.blockPosition());
        if (var5 != null) {
            var5.setRaidOmenLevel(var1);
            var4.setDirty();
            var0.sendSuccess(() -> Component.literal("Created a raid in your local village"), false);
        } else {
            var0.sendFailure(Component.literal("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int stop(CommandSourceStack var0) throws CommandSyntaxException {
        ServerPlayer var1 = var0.getPlayerOrException();
        BlockPos var2 = var1.blockPosition();
        Raid var3 = var1.level().getRaidAt(var2);
        if (var3 != null) {
            var3.stop();
            var0.sendSuccess(() -> Component.literal("Stopped raid"), false);
            return 1;
        }
        var0.sendFailure(Component.literal("No raid here"));
        return -1;
    }

    private static int check(CommandSourceStack var0) throws CommandSyntaxException {
        Raid var1 = RaidCommand.getRaid(var0.getPlayerOrException());
        if (var1 != null) {
            StringBuilder var2 = new StringBuilder();
            var2.append("Found a started raid! ");
            var0.sendSuccess(() -> Component.literal(var2.toString()), false);
            StringBuilder var3 = new StringBuilder();
            var3.append("Num groups spawned: ");
            var3.append(var1.getGroupsSpawned());
            var3.append(" Raid omen level: ");
            var3.append(var1.getRaidOmenLevel());
            var3.append(" Num mobs: ");
            var3.append(var1.getTotalRaidersAlive());
            var3.append(" Raid health: ");
            var3.append(var1.getHealthOfLivingRaiders());
            var3.append(" / ");
            var3.append(var1.getTotalHealth());
            var0.sendSuccess(() -> Component.literal(var3.toString()), false);
            return 1;
        }
        var0.sendFailure(Component.literal("Found no started raids"));
        return 0;
    }

    private static @Nullable Raid getRaid(ServerPlayer var0) {
        return var0.level().getRaidAt(var0.blockPosition());
    }
}

