/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.blocks.BlockInput;
import net.minecraft.commands.arguments.blocks.BlockStateArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.jspecify.annotations.Nullable;

public class SetBlockCommand {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var12) {
        Predicate<BlockInWorld> var2 = var0 -> var0.getLevel().isEmptyBlock(var0.getPos());
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("setblock").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("block", BlockStateArgument.block(var12)).executes(var0 -> SetBlockCommand.setBlock((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), Mode.REPLACE, null, false))).then(Commands.literal("destroy").executes(var0 -> SetBlockCommand.setBlock((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), Mode.DESTROY, null, false)))).then(Commands.literal("keep").executes(var1 -> SetBlockCommand.setBlock((CommandSourceStack)var1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var1, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var1, "block"), Mode.REPLACE, var2, false)))).then(Commands.literal("replace").executes(var0 -> SetBlockCommand.setBlock((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), Mode.REPLACE, null, false)))).then(Commands.literal("strict").executes(var0 -> SetBlockCommand.setBlock((CommandSourceStack)var0.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)var0, "pos"), BlockStateArgument.getBlock((CommandContext<CommandSourceStack>)var0, "block"), Mode.REPLACE, null, true)))))));
    }

    private static int setBlock(CommandSourceStack var0, BlockPos var1, BlockInput var2, Mode var3, @Nullable Predicate<BlockInWorld> var4, boolean var5) throws CommandSyntaxException {
        boolean var7;
        ServerLevel var6 = var0.getLevel();
        if (var6.isDebug()) {
            throw ERROR_FAILED.create();
        }
        if (var4 != null && !var4.test(new BlockInWorld(var6, var1, true))) {
            throw ERROR_FAILED.create();
        }
        if (var3 == Mode.DESTROY) {
            var6.destroyBlock(var1, true);
            var7 = !var2.getState().isAir() || !var6.getBlockState(var1).isAir();
        } else {
            var7 = true;
        }
        BlockState var8 = var6.getBlockState(var1);
        if (var7 && !var2.place(var6, var1, 2 | (var5 ? 816 : 256))) {
            throw ERROR_FAILED.create();
        }
        if (!var5) {
            var6.updateNeighboursOnBlockSet(var1, var8);
        }
        var0.sendSuccess(() -> Component.translatable("commands.setblock.success", var1.getX(), var1.getY(), var1.getZ()), true);
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }
}

