/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.RotationArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec2;
import org.bukkit.event.player.PlayerSpawnChangeEvent;

public class SetSpawnCommand {
    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("spawnpoint").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), Collections.singleton(((CommandSourceStack)commandcontext.getSource()).getPlayerOrException()), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), WorldCoordinates.ZERO_ROTATION))).then(((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPos.containing(((CommandSourceStack)commandcontext.getSource()).getPosition()), WorldCoordinates.ZERO_ROTATION))).then(((RequiredArgumentBuilder)Commands.argument("pos", BlockPosArgument.blockPos()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), WorldCoordinates.ZERO_ROTATION))).then(Commands.argument("rotation", RotationArgument.rotation()).executes(commandcontext -> SetSpawnCommand.setSpawn((CommandSourceStack)commandcontext.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandcontext, "targets"), BlockPosArgument.getSpawnablePos((CommandContext<CommandSourceStack>)commandcontext, "pos"), RotationArgument.getRotation((CommandContext<CommandSourceStack>)commandcontext, "rotation"))))))));
    }

    private static int setSpawn(CommandSourceStack commandlistenerwrapper, Collection<ServerPlayer> collection, BlockPos blockposition, Coordinates ivectorposition) {
        ResourceKey<Level> resourcekey = commandlistenerwrapper.getLevel().dimension();
        Vec2 vec2f = ivectorposition.getRotation(commandlistenerwrapper);
        float f = Mth.wrapDegrees(vec2f.y);
        float f1 = Mth.clamp(vec2f.x, -90.0f, 90.0f);
        for (ServerPlayer entityplayer : collection) {
            entityplayer.setRespawnPosition(new ServerPlayer.RespawnConfig(LevelData.RespawnData.of(resourcekey, blockposition, f, f1), true), false, PlayerSpawnChangeEvent.Cause.COMMAND);
        }
        String s = resourcekey.identifier().toString();
        if (collection.size() == 1) {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.single", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f), Float.valueOf(f1), s, ((ServerPlayer)collection.iterator().next()).getDisplayName()), true);
        } else {
            commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.spawnpoint.success.multiple", blockposition.getX(), blockposition.getY(), blockposition.getZ(), Float.valueOf(f), Float.valueOf(f1), s, collection.size()), true);
        }
        return collection.size();
    }
}

