/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ColorArgument;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.commands.arguments.TeamArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;

public class TeamCommand {
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_EXISTS = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.add.duplicate"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.empty.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_NAME = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.name.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_COLOR = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.color.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYFIRE_ENABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.friendlyfire.alreadyEnabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYFIRE_DISABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.friendlyfire.alreadyDisabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_ENABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.seeFriendlyInvisibles.alreadyEnabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_DISABLED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.seeFriendlyInvisibles.alreadyDisabled"));
    private static final SimpleCommandExceptionType ERROR_TEAM_NAMETAG_VISIBLITY_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.nametagVisibility.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_DEATH_MESSAGE_VISIBLITY_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.deathMessageVisibility.unchanged"));
    private static final SimpleCommandExceptionType ERROR_TEAM_COLLISION_UNCHANGED = new SimpleCommandExceptionType((Message)Component.translatable("commands.team.option.collisionRule.unchanged"));

    public static void register(CommandDispatcher<CommandSourceStack> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("team").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((LiteralArgumentBuilder)Commands.literal("list").executes(var0 -> TeamCommand.listTeams((CommandSourceStack)var0.getSource()))).then(Commands.argument("team", TeamArgument.team()).executes(var0 -> TeamCommand.listMembers((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team")))))).then(Commands.literal("add").then(((RequiredArgumentBuilder)Commands.argument("team", StringArgumentType.word()).executes(var0 -> TeamCommand.createTeam((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"team")))).then(Commands.argument("displayName", ComponentArgument.textComponent(var1)).executes(var0 -> TeamCommand.createTeam((CommandSourceStack)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"team"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "displayName"))))))).then(Commands.literal("remove").then(Commands.argument("team", TeamArgument.team()).executes(var0 -> TeamCommand.deleteTeam((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team")))))).then(Commands.literal("empty").then(Commands.argument("team", TeamArgument.team()).executes(var0 -> TeamCommand.emptyTeam((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team")))))).then(Commands.literal("join").then(((RequiredArgumentBuilder)Commands.argument("team", TeamArgument.team()).executes(var0 -> TeamCommand.joinTeam((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Collections.singleton(((CommandSourceStack)var0.getSource()).getEntityOrException())))).then(Commands.argument("members", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).executes(var0 -> TeamCommand.joinTeam((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)var0, "members"))))))).then(Commands.literal("leave").then(Commands.argument("members", ScoreHolderArgument.scoreHolders()).suggests(ScoreHolderArgument.SUGGEST_SCORE_HOLDERS).executes(var0 -> TeamCommand.leaveTeam((CommandSourceStack)var0.getSource(), ScoreHolderArgument.getNamesWithDefaultWildcard((CommandContext<CommandSourceStack>)var0, "members")))))).then(Commands.literal("modify").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("team", TeamArgument.team()).then(Commands.literal("displayName").then(Commands.argument("displayName", ComponentArgument.textComponent(var1)).executes(var0 -> TeamCommand.setDisplayName((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "displayName")))))).then(Commands.literal("color").then(Commands.argument("value", ColorArgument.color()).executes(var0 -> TeamCommand.setColor((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), ColorArgument.getColor((CommandContext<CommandSourceStack>)var0, "value")))))).then(Commands.literal("friendlyFire").then(Commands.argument("allowed", BoolArgumentType.bool()).executes(var0 -> TeamCommand.setFriendlyFire((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), BoolArgumentType.getBool((CommandContext)var0, (String)"allowed")))))).then(Commands.literal("seeFriendlyInvisibles").then(Commands.argument("allowed", BoolArgumentType.bool()).executes(var0 -> TeamCommand.setFriendlySight((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), BoolArgumentType.getBool((CommandContext)var0, (String)"allowed")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("nametagVisibility").then(Commands.literal("never").executes(var0 -> TeamCommand.setNametagVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.NEVER)))).then(Commands.literal("hideForOtherTeams").executes(var0 -> TeamCommand.setNametagVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.HIDE_FOR_OTHER_TEAMS)))).then(Commands.literal("hideForOwnTeam").executes(var0 -> TeamCommand.setNametagVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.HIDE_FOR_OWN_TEAM)))).then(Commands.literal("always").executes(var0 -> TeamCommand.setNametagVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.ALWAYS))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("deathMessageVisibility").then(Commands.literal("never").executes(var0 -> TeamCommand.setDeathMessageVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.NEVER)))).then(Commands.literal("hideForOtherTeams").executes(var0 -> TeamCommand.setDeathMessageVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.HIDE_FOR_OTHER_TEAMS)))).then(Commands.literal("hideForOwnTeam").executes(var0 -> TeamCommand.setDeathMessageVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.HIDE_FOR_OWN_TEAM)))).then(Commands.literal("always").executes(var0 -> TeamCommand.setDeathMessageVisibility((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.Visibility.ALWAYS))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("collisionRule").then(Commands.literal("never").executes(var0 -> TeamCommand.setCollision((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.CollisionRule.NEVER)))).then(Commands.literal("pushOwnTeam").executes(var0 -> TeamCommand.setCollision((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.CollisionRule.PUSH_OWN_TEAM)))).then(Commands.literal("pushOtherTeams").executes(var0 -> TeamCommand.setCollision((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.CollisionRule.PUSH_OTHER_TEAMS)))).then(Commands.literal("always").executes(var0 -> TeamCommand.setCollision((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), Team.CollisionRule.ALWAYS))))).then(Commands.literal("prefix").then(Commands.argument("prefix", ComponentArgument.textComponent(var1)).executes(var0 -> TeamCommand.setPrefix((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "prefix")))))).then(Commands.literal("suffix").then(Commands.argument("suffix", ComponentArgument.textComponent(var1)).executes(var0 -> TeamCommand.setSuffix((CommandSourceStack)var0.getSource(), TeamArgument.getTeam((CommandContext<CommandSourceStack>)var0, "team"), ComponentArgument.getResolvedComponent((CommandContext<CommandSourceStack>)var0, "suffix")))))))));
    }

    private static Component getFirstMemberName(Collection<ScoreHolder> var0) {
        return var0.iterator().next().getFeedbackDisplayName();
    }

    private static int leaveTeam(CommandSourceStack var0, Collection<ScoreHolder> var1) {
        ServerScoreboard var2 = var0.getServer().getScoreboard();
        for (ScoreHolder var4 : var1) {
            var2.removePlayerFromTeam(var4.getScoreboardName());
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.team.leave.success.single", TeamCommand.getFirstMemberName(var1)), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.team.leave.success.multiple", var1.size()), true);
        }
        return var1.size();
    }

    private static int joinTeam(CommandSourceStack var0, PlayerTeam var1, Collection<ScoreHolder> var2) {
        ServerScoreboard var3 = var0.getServer().getScoreboard();
        for (ScoreHolder var5 : var2) {
            ((Scoreboard)var3).addPlayerToTeam(var5.getScoreboardName(), var1);
        }
        if (var2.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.team.join.success.single", TeamCommand.getFirstMemberName(var2), var1.getFormattedDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.team.join.success.multiple", var2.size(), var1.getFormattedDisplayName()), true);
        }
        return var2.size();
    }

    private static int setNametagVisibility(CommandSourceStack var0, PlayerTeam var1, Team.Visibility var2) throws CommandSyntaxException {
        if (var1.getNameTagVisibility() == var2) {
            throw ERROR_TEAM_NAMETAG_VISIBLITY_UNCHANGED.create();
        }
        var1.setNameTagVisibility(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.nametagVisibility.success", var1.getFormattedDisplayName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setDeathMessageVisibility(CommandSourceStack var0, PlayerTeam var1, Team.Visibility var2) throws CommandSyntaxException {
        if (var1.getDeathMessageVisibility() == var2) {
            throw ERROR_TEAM_DEATH_MESSAGE_VISIBLITY_UNCHANGED.create();
        }
        var1.setDeathMessageVisibility(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.deathMessageVisibility.success", var1.getFormattedDisplayName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setCollision(CommandSourceStack var0, PlayerTeam var1, Team.CollisionRule var2) throws CommandSyntaxException {
        if (var1.getCollisionRule() == var2) {
            throw ERROR_TEAM_COLLISION_UNCHANGED.create();
        }
        var1.setCollisionRule(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.collisionRule.success", var1.getFormattedDisplayName(), var2.getDisplayName()), true);
        return 0;
    }

    private static int setFriendlySight(CommandSourceStack var0, PlayerTeam var1, boolean var2) throws CommandSyntaxException {
        if (var1.canSeeFriendlyInvisibles() == var2) {
            if (var2) {
                throw ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_ENABLED.create();
            }
            throw ERROR_TEAM_ALREADY_FRIENDLYINVISIBLES_DISABLED.create();
        }
        var1.setSeeFriendlyInvisibles(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.seeFriendlyInvisibles." + (var2 ? "enabled" : "disabled"), var1.getFormattedDisplayName()), true);
        return 0;
    }

    private static int setFriendlyFire(CommandSourceStack var0, PlayerTeam var1, boolean var2) throws CommandSyntaxException {
        if (var1.isAllowFriendlyFire() == var2) {
            if (var2) {
                throw ERROR_TEAM_ALREADY_FRIENDLYFIRE_ENABLED.create();
            }
            throw ERROR_TEAM_ALREADY_FRIENDLYFIRE_DISABLED.create();
        }
        var1.setAllowFriendlyFire(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.friendlyfire." + (var2 ? "enabled" : "disabled"), var1.getFormattedDisplayName()), true);
        return 0;
    }

    private static int setDisplayName(CommandSourceStack var0, PlayerTeam var1, Component var2) throws CommandSyntaxException {
        if (var1.getDisplayName().equals(var2)) {
            throw ERROR_TEAM_ALREADY_NAME.create();
        }
        var1.setDisplayName(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.name.success", var1.getFormattedDisplayName()), true);
        return 0;
    }

    private static int setColor(CommandSourceStack var0, PlayerTeam var1, ChatFormatting var2) throws CommandSyntaxException {
        if (var1.getColor() == var2) {
            throw ERROR_TEAM_ALREADY_COLOR.create();
        }
        var1.setColor(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.color.success", var1.getFormattedDisplayName(), var2.getName()), true);
        return 0;
    }

    private static int emptyTeam(CommandSourceStack var0, PlayerTeam var1) throws CommandSyntaxException {
        ServerScoreboard var2 = var0.getServer().getScoreboard();
        ArrayList var3 = Lists.newArrayList(var1.getPlayers());
        if (var3.isEmpty()) {
            throw ERROR_TEAM_ALREADY_EMPTY.create();
        }
        for (String var5 : var3) {
            ((Scoreboard)var2).removePlayerFromTeam(var5, var1);
        }
        var0.sendSuccess(() -> Component.translatable("commands.team.empty.success", var3.size(), var1.getFormattedDisplayName()), true);
        return var3.size();
    }

    private static int deleteTeam(CommandSourceStack var0, PlayerTeam var1) {
        ServerScoreboard var2 = var0.getServer().getScoreboard();
        var2.removePlayerTeam(var1);
        var0.sendSuccess(() -> Component.translatable("commands.team.remove.success", var1.getFormattedDisplayName()), true);
        return var2.getPlayerTeams().size();
    }

    private static int createTeam(CommandSourceStack var0, String var1) throws CommandSyntaxException {
        return TeamCommand.createTeam(var0, var1, Component.literal(var1));
    }

    private static int createTeam(CommandSourceStack var0, String var1, Component var2) throws CommandSyntaxException {
        ServerScoreboard var3 = var0.getServer().getScoreboard();
        if (var3.getPlayerTeam(var1) != null) {
            throw ERROR_TEAM_ALREADY_EXISTS.create();
        }
        PlayerTeam var4 = var3.addPlayerTeam(var1);
        var4.setDisplayName(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.add.success", var4.getFormattedDisplayName()), true);
        return var3.getPlayerTeams().size();
    }

    private static int listMembers(CommandSourceStack var0, PlayerTeam var1) {
        Collection<String> var2 = var1.getPlayers();
        if (var2.isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.team.list.members.empty", var1.getFormattedDisplayName()), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.team.list.members.success", var1.getFormattedDisplayName(), var2.size(), ComponentUtils.formatList(var2)), false);
        }
        return var2.size();
    }

    private static int listTeams(CommandSourceStack var0) {
        Collection<PlayerTeam> var1 = var0.getServer().getScoreboard().getPlayerTeams();
        if (var1.isEmpty()) {
            var0.sendSuccess(() -> Component.translatable("commands.team.list.teams.empty"), false);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.team.list.teams.success", var1.size(), ComponentUtils.formatList(var1, PlayerTeam::getFormattedDisplayName)), false);
        }
        return var1.size();
    }

    private static int setPrefix(CommandSourceStack var0, PlayerTeam var1, Component var2) {
        var1.setPlayerPrefix(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.prefix.success", var2), false);
        return 1;
    }

    private static int setSuffix(CommandSourceStack var0, PlayerTeam var1, Component var2) {
        var1.setPlayerSuffix(var2);
        var0.sendSuccess(() -> Component.translatable("commands.team.option.suffix.success", var2), false);
        return 1;
    }
}

