/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.Player;

public class WardenSpawnTrackerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> var02) {
        var02.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("warden_spawn_tracker").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(Commands.literal("clear").executes(var0 -> WardenSpawnTrackerCommand.resetTracker((CommandSourceStack)var0.getSource(), (Collection<? extends Player>)ImmutableList.of((Object)((CommandSourceStack)var0.getSource()).getPlayerOrException()))))).then(Commands.literal("set").then(Commands.argument("warning_level", IntegerArgumentType.integer((int)0, (int)4)).executes(var0 -> WardenSpawnTrackerCommand.setWarningLevel((CommandSourceStack)var0.getSource(), (Collection<? extends Player>)ImmutableList.of((Object)((CommandSourceStack)var0.getSource()).getPlayerOrException()), IntegerArgumentType.getInteger((CommandContext)var0, (String)"warning_level")))))));
    }

    private static int setWarningLevel(CommandSourceStack var0, Collection<? extends Player> var12, int var2) {
        for (Player player : var12) {
            player.getWardenSpawnTracker().ifPresent(var1 -> var1.setWarningLevel(var2));
        }
        if (var12.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.warden_spawn_tracker.set.success.single", ((Player)var12.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.warden_spawn_tracker.set.success.multiple", var12.size()), true);
        }
        return var12.size();
    }

    private static int resetTracker(CommandSourceStack var0, Collection<? extends Player> var1) {
        for (Player player : var1) {
            player.getWardenSpawnTracker().ifPresent(WardenSpawnTracker::reset);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(() -> Component.translatable("commands.warden_spawn_tracker.clear.success.single", ((Player)var1.iterator().next()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> Component.translatable("commands.warden_spawn_tracker.clear.success.multiple", var1.size()), true);
        }
        return var1.size();
    }
}

