/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.TimeArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.IntProvider;

public class WeatherCommand {
    private static final int DEFAULT_TIME = -1;

    public static void register(CommandDispatcher<CommandSourceStack> commanddispatcher) {
        commanddispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("weather").requires(Commands.hasPermission(Commands.LEVEL_GAMEMASTERS))).then(((LiteralArgumentBuilder)Commands.literal("clear").executes(commandcontext -> WeatherCommand.setClear((CommandSourceStack)commandcontext.getSource(), -1))).then(Commands.argument("duration", TimeArgument.time(1)).executes(commandcontext -> WeatherCommand.setClear((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"duration")))))).then(((LiteralArgumentBuilder)Commands.literal("rain").executes(commandcontext -> WeatherCommand.setRain((CommandSourceStack)commandcontext.getSource(), -1))).then(Commands.argument("duration", TimeArgument.time(1)).executes(commandcontext -> WeatherCommand.setRain((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"duration")))))).then(((LiteralArgumentBuilder)Commands.literal("thunder").executes(commandcontext -> WeatherCommand.setThunder((CommandSourceStack)commandcontext.getSource(), -1))).then(Commands.argument("duration", TimeArgument.time(1)).executes(commandcontext -> WeatherCommand.setThunder((CommandSourceStack)commandcontext.getSource(), IntegerArgumentType.getInteger((CommandContext)commandcontext, (String)"duration")))))));
    }

    private static int getDuration(CommandSourceStack commandlistenerwrapper, int i, IntProvider intprovider) {
        return i == -1 ? intprovider.sample(commandlistenerwrapper.getLevel().getRandom()) : i;
    }

    private static int setClear(CommandSourceStack commandlistenerwrapper, int i) {
        commandlistenerwrapper.getLevel().setWeatherParameters(WeatherCommand.getDuration(commandlistenerwrapper, i, ServerLevel.RAIN_DELAY), 0, false, false);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.weather.set.clear"), true);
        return i;
    }

    private static int setRain(CommandSourceStack commandlistenerwrapper, int i) {
        commandlistenerwrapper.getLevel().setWeatherParameters(0, WeatherCommand.getDuration(commandlistenerwrapper, i, ServerLevel.RAIN_DURATION), true, false);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.weather.set.rain"), true);
        return i;
    }

    private static int setThunder(CommandSourceStack commandlistenerwrapper, int i) {
        commandlistenerwrapper.getLevel().setWeatherParameters(0, WeatherCommand.getDuration(commandlistenerwrapper, i, ServerLevel.THUNDER_DURATION), true, true);
        commandlistenerwrapper.sendSuccess(() -> Component.translatable("commands.weather.set.thunder"), true);
        return i;
    }
}

