/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import java.io.File;
import java.nio.file.Path;
import java.util.function.UnaryOperator;
import joptsimple.OptionSet;
import net.minecraft.server.dedicated.DedicatedServerProperties;

public class DedicatedServerSettings {
    private final Path source;
    private DedicatedServerProperties properties;

    public DedicatedServerSettings(OptionSet optionset) {
        this.source = ((File)optionset.valueOf("config")).toPath();
        this.properties = DedicatedServerProperties.fromFile(this.source, optionset);
    }

    public DedicatedServerProperties getProperties() {
        return this.properties;
    }

    public void forceSave() {
        this.properties.store(this.source);
    }

    public DedicatedServerSettings update(UnaryOperator<DedicatedServerProperties> unaryoperator) {
        this.properties = (DedicatedServerProperties)unaryoperator.apply(this.properties);
        this.properties.store(this.source);
        return this;
    }
}

