/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.dedicated;

import com.google.common.base.MoreObjects;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import joptsimple.OptionSet;
import net.minecraft.core.RegistryAccess;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class Settings<T extends Settings<T>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final Properties properties;
    private OptionSet options = null;

    public Settings(Properties properties, OptionSet options) {
        this.properties = properties;
        this.options = options;
    }

    private String getOverride(String name, String value) {
        if (this.options != null && this.options.has(name)) {
            return String.valueOf(this.options.valueOf(name));
        }
        return value;
    }

    public static Properties loadFromFile(Path path) {
        Properties properties;
        block18: {
            if (!path.toFile().exists()) {
                return new Properties();
            }
            InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
            try {
                CharsetDecoder charsetdecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
                Properties properties2 = new Properties();
                properties2.load(new InputStreamReader(inputstream, charsetdecoder));
                properties = properties2;
                if (inputstream == null) break block18;
            }
            catch (Throwable charsetdecoder) {
                try {
                    if (inputstream != null) {
                        try {
                            inputstream.close();
                        }
                        catch (Throwable properties2) {
                            charsetdecoder.addSuppressed(properties2);
                        }
                    }
                    throw charsetdecoder;
                }
                catch (CharacterCodingException charactercodingexception) {
                    Properties properties3;
                    block19: {
                        LOGGER.info("Failed to load properties as UTF-8 from file {}, trying ISO_8859_1", (Object)path);
                        BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.ISO_8859_1);
                        try {
                            Properties properties1 = new Properties();
                            properties1.load(reader);
                            properties3 = properties1;
                            if (reader == null) break block19;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (reader != null) {
                                    try {
                                        ((Reader)reader).close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException ioexception) {
                                LOGGER.error("Failed to load properties from file: {}", (Object)path, (Object)ioexception);
                                return new Properties();
                            }
                        }
                        ((Reader)reader).close();
                    }
                    return properties3;
                }
            }
            inputstream.close();
        }
        return properties;
    }

    public void store(Path path) {
        if (path.toFile().exists() && !path.toFile().canWrite()) {
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.properties.store(writer, "Minecraft server properties");
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to store properties to file: {}", (Object)path);
        }
    }

    private static <V extends Number> Function<String, @Nullable V> wrapNumberDeserializer(Function<String, V> function) {
        return s -> {
            try {
                return (Number)function.apply((String)s);
            }
            catch (NumberFormatException numberformatexception) {
                return null;
            }
        };
    }

    protected static <V> Function<String, @Nullable V> dispatchNumberOrString(IntFunction<@Nullable V> intfunction, Function<String, @Nullable V> function) {
        return s -> {
            try {
                return intfunction.apply(Integer.parseInt(s));
            }
            catch (NumberFormatException numberformatexception) {
                return function.apply((String)s);
            }
        };
    }

    private @Nullable String getStringRaw(String s) {
        return this.getOverride(s, this.properties.getProperty(s));
    }

    protected <V> @Nullable V getLegacy(String s, Function<String, V> function) {
        String s1 = this.getStringRaw(s);
        if (s1 == null) {
            return null;
        }
        this.properties.remove(s);
        return function.apply(s1);
    }

    protected <V> V get(String s, Function<String, @Nullable V> function, Function<V, String> function1, V v0) {
        try {
            return this.get0(s, function, function1, v0);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load invalidly configured property '" + s + "'", ex);
        }
    }

    private <V> V get0(String s, Function<String, @Nullable V> function, Function<V, String> function1, V v0) {
        String s1 = this.getStringRaw(s);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.properties.put(s, function1.apply(v1));
        return (V)v1;
    }

    protected <V> MutableValue<V> getMutable(String s, Function<String, @Nullable V> function, Function<V, String> function1, V v0) {
        String s1 = this.getStringRaw(s);
        Object v1 = MoreObjects.firstNonNull(s1 != null ? function.apply(s1) : null, v0);
        this.properties.put(s, function1.apply(v1));
        return new MutableValue<Object>(s, v1, function1);
    }

    protected <V> V get(String s, Function<String, @Nullable V> function, UnaryOperator<V> unaryoperator, Function<V, String> function1, V v0) {
        return (V)this.get(s, s1 -> {
            Object v1 = function.apply((String)s1);
            return v1 != null ? unaryoperator.apply(v1) : null;
        }, function1, v0);
    }

    protected <V> V get(String s, Function<String, V> function, V v0) {
        return (V)this.get(s, function, Objects::toString, v0);
    }

    protected <V> MutableValue<V> getMutable(String s, Function<String, V> function, V v0) {
        return this.getMutable(s, function, Objects::toString, v0);
    }

    protected String get(String s, String s1) {
        return this.get(s, Function.identity(), Function.identity(), s1);
    }

    protected @Nullable String getLegacyString(String s) {
        return (String)this.getLegacy(s, Function.identity());
    }

    protected int get(String s, int i) {
        return this.get(s, Settings.wrapNumberDeserializer(Integer::parseInt), Integer.valueOf(i));
    }

    protected MutableValue<Integer> getMutable(String s, int i) {
        return this.getMutable(s, Settings.wrapNumberDeserializer(Integer::parseInt), i);
    }

    protected MutableValue<String> getMutable(String s, String s1) {
        return this.getMutable(s, String::new, s1);
    }

    protected int get(String s, UnaryOperator<Integer> unaryoperator, int i) {
        return this.get(s, Settings.wrapNumberDeserializer(Integer::parseInt), unaryoperator, Objects::toString, i);
    }

    protected long get(String s, long i) {
        return this.get(s, Settings.wrapNumberDeserializer(Long::parseLong), i);
    }

    protected boolean get(String s, boolean flag) {
        return this.get(s, Boolean::valueOf, flag);
    }

    protected MutableValue<Boolean> getMutable(String s, boolean flag) {
        return this.getMutable(s, Boolean::valueOf, flag);
    }

    protected @Nullable Boolean getLegacyBoolean(String s) {
        return this.getLegacy(s, Boolean::valueOf);
    }

    protected Properties cloneProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        return properties;
    }

    protected abstract T reload(RegistryAccess var1, Properties var2, OptionSet var3);

    public class MutableValue<V>
    implements Supplier<V> {
        private final String key;
        private final V value;
        private final Function<V, String> serializer;

        MutableValue(String s, V object, Function function) {
            this.key = s;
            this.value = object;
            this.serializer = function;
        }

        @Override
        public V get() {
            return this.value;
        }

        public T update(RegistryAccess iregistrycustom, V v0) {
            Properties properties = Settings.this.cloneProperties();
            properties.put(this.key, this.serializer.apply(v0));
            return Settings.this.reload(iregistrycustom, properties, Settings.this.options);
        }
    }
}

