/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;

public abstract class ChunkTracker
extends DynamicGraphMinFixedPoint {
    protected ChunkTracker(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected boolean isSource(long var0) {
        return var0 == ChunkPos.INVALID_CHUNK_POS;
    }

    @Override
    protected void checkNeighborsAfterUpdate(long var0, int var2, boolean var3) {
        if (var3 && var2 >= this.levelCount - 2) {
            return;
        }
        ChunkPos var4 = new ChunkPos(var0);
        int var5 = var4.x;
        int var6 = var4.z;
        for (int var7 = -1; var7 <= 1; ++var7) {
            for (int var8 = -1; var8 <= 1; ++var8) {
                long var9 = ChunkPos.asLong(var5 + var7, var6 + var8);
                if (var9 == var0) continue;
                this.checkNeighbor(var0, var9, var2, var3);
            }
        }
    }

    @Override
    protected int getComputedLevel(long var0, long var2, int var4) {
        int var5 = var4;
        ChunkPos var6 = new ChunkPos(var0);
        int var7 = var6.x;
        int var8 = var6.z;
        for (int var9 = -1; var9 <= 1; ++var9) {
            for (int var10 = -1; var10 <= 1; ++var10) {
                long var11 = ChunkPos.asLong(var7 + var9, var8 + var10);
                if (var11 == var0) {
                    var11 = ChunkPos.INVALID_CHUNK_POS;
                }
                if (var11 == var2) continue;
                int var13 = this.computeLevelFromNeighbor(var11, var0, this.getLevel(var11));
                if (var5 > var13) {
                    var5 = var13;
                }
                if (var5 != 0) continue;
                return var5;
            }
        }
        return var5;
    }

    @Override
    protected int computeLevelFromNeighbor(long var0, long var2, int var4) {
        if (var0 == ChunkPos.INVALID_CHUNK_POS) {
            return this.getLevelFromSource(var2);
        }
        return var4 + 1;
    }

    protected abstract int getLevelFromSource(long var1);

    public void update(long var0, int var2, boolean var3) {
        this.checkEdge(ChunkPos.INVALID_CHUNK_POS, var0, var2, var3);
    }
}

