/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkGenerationTask;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkResult;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.GeneratingChunkMap;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import org.jspecify.annotations.Nullable;

public abstract class GenerationChunkHolder {
    private static final List<ChunkStatus> CHUNK_STATUSES = ChunkStatus.getStatusList();
    private static final ChunkResult<ChunkAccess> NOT_DONE_YET = ChunkResult.error("Not done yet");
    public static final ChunkResult<ChunkAccess> UNLOADED_CHUNK = ChunkResult.error("Unloaded chunk");
    public static final CompletableFuture<ChunkResult<ChunkAccess>> UNLOADED_CHUNK_FUTURE = CompletableFuture.completedFuture(UNLOADED_CHUNK);
    protected final ChunkPos pos;
    private volatile @Nullable ChunkStatus highestAllowedStatus;
    private final AtomicReference<@Nullable ChunkStatus> startedWork = new AtomicReference();
    private final AtomicReferenceArray<@Nullable CompletableFuture<ChunkResult<ChunkAccess>>> futures = new AtomicReferenceArray(CHUNK_STATUSES.size());
    private final AtomicReference<@Nullable ChunkGenerationTask> task = new AtomicReference();
    private final AtomicInteger generationRefCount = new AtomicInteger();
    private volatile CompletableFuture<Void> generationSaveSyncFuture = CompletableFuture.completedFuture(null);

    public GenerationChunkHolder(ChunkPos var0) {
        this.pos = var0;
        if (!var0.isValid()) {
            throw new IllegalStateException("Trying to create chunk out of reasonable bounds: " + String.valueOf(var0));
        }
    }

    public CompletableFuture<ChunkResult<ChunkAccess>> scheduleChunkGenerationTask(ChunkStatus var0, ChunkMap var1) {
        if (this.isStatusDisallowed(var0)) {
            return UNLOADED_CHUNK_FUTURE;
        }
        CompletableFuture<ChunkResult<ChunkAccess>> var2 = this.getOrCreateFuture(var0);
        if (var2.isDone()) {
            return var2;
        }
        ChunkGenerationTask var3 = this.task.get();
        if (var3 == null || var0.isAfter(var3.targetStatus)) {
            this.rescheduleChunkTask(var1, var0);
        }
        return var2;
    }

    CompletableFuture<ChunkResult<ChunkAccess>> applyStep(ChunkStep var0, GeneratingChunkMap var12, StaticCache2D<GenerationChunkHolder> var22) {
        if (this.isStatusDisallowed(var0.targetStatus())) {
            return UNLOADED_CHUNK_FUTURE;
        }
        if (this.acquireStatusBump(var0.targetStatus())) {
            return var12.applyStep(this, var0, var22).handle((var1, var2) -> {
                if (var2 != null) {
                    CrashReport var3 = CrashReport.forThrowable(var2, "Exception chunk generation/loading");
                    MinecraftServer.setFatalException(new ReportedException(var3));
                } else {
                    this.completeFuture(var0.targetStatus(), (ChunkAccess)var1);
                }
                return ChunkResult.of(var1);
            });
        }
        return this.getOrCreateFuture(var0.targetStatus());
    }

    protected void updateHighestAllowedStatus(ChunkMap var0) {
        boolean var3;
        ChunkStatus var2;
        ChunkStatus var1 = this.highestAllowedStatus;
        this.highestAllowedStatus = var2 = ChunkLevel.generationStatus(this.getTicketLevel());
        boolean bl = var3 = var1 != null && (var2 == null || var2.isBefore(var1));
        if (var3) {
            this.failAndClearPendingFuturesBetween(var2, var1);
            if (this.task.get() != null) {
                this.rescheduleChunkTask(var0, this.findHighestStatusWithPendingFuture(var2));
            }
        }
    }

    public void replaceProtoChunk(ImposterProtoChunk var0) {
        CompletableFuture<ChunkResult<ImposterProtoChunk>> var1 = CompletableFuture.completedFuture(ChunkResult.of(var0));
        for (int var2 = 0; var2 < this.futures.length() - 1; ++var2) {
            CompletableFuture<ChunkResult<ChunkAccess>> var3 = this.futures.get(var2);
            Objects.requireNonNull(var3);
            ChunkAccess var4 = var3.getNow(NOT_DONE_YET).orElse(null);
            if (var4 instanceof ProtoChunk) {
                if (this.futures.compareAndSet(var2, var3, var1)) continue;
                throw new IllegalStateException("Future changed by other thread while trying to replace it");
            }
            throw new IllegalStateException("Trying to replace a ProtoChunk, but found " + String.valueOf(var4));
        }
    }

    void removeTask(ChunkGenerationTask var0) {
        this.task.compareAndSet(var0, null);
    }

    private void rescheduleChunkTask(ChunkMap var0, @Nullable ChunkStatus var1) {
        ChunkGenerationTask var2 = var1 != null ? var0.scheduleGenerationTask(var1, this.getPos()) : null;
        ChunkGenerationTask var3 = this.task.getAndSet(var2);
        if (var3 != null) {
            var3.markForCancellation();
        }
    }

    private CompletableFuture<ChunkResult<ChunkAccess>> getOrCreateFuture(ChunkStatus var0) {
        if (this.isStatusDisallowed(var0)) {
            return UNLOADED_CHUNK_FUTURE;
        }
        int var1 = var0.getIndex();
        CompletableFuture<ChunkResult<ChunkAccess>> var2 = this.futures.get(var1);
        while (var2 == null) {
            CompletableFuture<ChunkResult<ChunkAccess>> var3 = new CompletableFuture<ChunkResult<ChunkAccess>>();
            var2 = this.futures.compareAndExchange(var1, null, var3);
            if (var2 != null) continue;
            if (this.isStatusDisallowed(var0)) {
                this.failAndClearPendingFuture(var1, var3);
                return UNLOADED_CHUNK_FUTURE;
            }
            return var3;
        }
        return var2;
    }

    private void failAndClearPendingFuturesBetween(@Nullable ChunkStatus var0, ChunkStatus var1) {
        int var2 = var0 == null ? 0 : var0.getIndex() + 1;
        int var3 = var1.getIndex();
        for (int var4 = var2; var4 <= var3; ++var4) {
            CompletableFuture<ChunkResult<ChunkAccess>> var5 = this.futures.get(var4);
            if (var5 == null) continue;
            this.failAndClearPendingFuture(var4, var5);
        }
    }

    private void failAndClearPendingFuture(int var0, CompletableFuture<ChunkResult<ChunkAccess>> var1) {
        if (var1.complete(UNLOADED_CHUNK) && !this.futures.compareAndSet(var0, var1, null)) {
            throw new IllegalStateException("Nothing else should replace the future here");
        }
    }

    private void completeFuture(ChunkStatus var0, ChunkAccess var1) {
        ChunkResult<ChunkAccess> var2 = ChunkResult.of(var1);
        int var3 = var0.getIndex();
        while (true) {
            CompletableFuture<ChunkResult<ChunkAccess>> var4;
            if ((var4 = this.futures.get(var3)) == null) {
                if (!this.futures.compareAndSet(var3, null, CompletableFuture.completedFuture(var2))) continue;
                return;
            }
            if (var4.complete(var2)) {
                return;
            }
            if (var4.getNow(NOT_DONE_YET).isSuccess()) {
                throw new IllegalStateException("Trying to complete a future but found it to be completed successfully already");
            }
            Thread.yield();
        }
    }

    private @Nullable ChunkStatus findHighestStatusWithPendingFuture(@Nullable ChunkStatus var0) {
        if (var0 == null) {
            return null;
        }
        ChunkStatus var1 = var0;
        ChunkStatus var2 = this.startedWork.get();
        while (var2 == null || var1.isAfter(var2)) {
            if (this.futures.get(var1.getIndex()) != null) {
                return var1;
            }
            if (var1 == ChunkStatus.EMPTY) break;
            var1 = var1.getParent();
        }
        return null;
    }

    private boolean acquireStatusBump(ChunkStatus var0) {
        ChunkStatus var1 = var0 == ChunkStatus.EMPTY ? null : var0.getParent();
        ChunkStatus var2 = this.startedWork.compareAndExchange(var1, var0);
        if (var2 == var1) {
            return true;
        }
        if (var2 == null || var0.isAfter(var2)) {
            throw new IllegalStateException("Unexpected last startedWork status: " + String.valueOf(var2) + " while trying to start: " + String.valueOf(var0));
        }
        return false;
    }

    private boolean isStatusDisallowed(ChunkStatus var0) {
        ChunkStatus var1 = this.highestAllowedStatus;
        return var1 == null || var0.isAfter(var1);
    }

    protected abstract void addSaveDependency(CompletableFuture<?> var1);

    public void increaseGenerationRefCount() {
        if (this.generationRefCount.getAndIncrement() == 0) {
            this.generationSaveSyncFuture = new CompletableFuture();
            this.addSaveDependency(this.generationSaveSyncFuture);
        }
    }

    public void decreaseGenerationRefCount() {
        CompletableFuture<Void> var0 = this.generationSaveSyncFuture;
        int var1 = this.generationRefCount.decrementAndGet();
        if (var1 == 0) {
            var0.complete(null);
        }
        if (var1 < 0) {
            throw new IllegalStateException("More releases than claims. Count: " + var1);
        }
    }

    public @Nullable ChunkAccess getChunkIfPresentUnchecked(ChunkStatus var0) {
        CompletableFuture<ChunkResult<ChunkAccess>> var1 = this.futures.get(var0.getIndex());
        return var1 == null ? null : (ChunkAccess)var1.getNow(NOT_DONE_YET).orElse(null);
    }

    public @Nullable ChunkAccess getChunkIfPresent(ChunkStatus var0) {
        if (this.isStatusDisallowed(var0)) {
            return null;
        }
        return this.getChunkIfPresentUnchecked(var0);
    }

    public @Nullable ChunkAccess getLatestChunk() {
        ChunkStatus var0 = this.startedWork.get();
        if (var0 == null) {
            return null;
        }
        ChunkAccess var1 = this.getChunkIfPresentUnchecked(var0);
        if (var1 != null) {
            return var1;
        }
        return this.getChunkIfPresentUnchecked(var0.getParent());
    }

    public @Nullable ChunkStatus getPersistedStatus() {
        CompletableFuture<ChunkResult<ChunkAccess>> var0 = this.futures.get(ChunkStatus.EMPTY.getIndex());
        ChunkAccess var1 = var0 == null ? null : (ChunkAccess)var0.getNow(NOT_DONE_YET).orElse(null);
        return var1 == null ? null : var1.getPersistedStatus();
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public FullChunkStatus getFullStatus() {
        return ChunkLevel.fullStatus(this.getTicketLevel());
    }

    public abstract int getTicketLevel();

    public abstract int getQueueLevel();

    @VisibleForDebug
    public List<Pair<ChunkStatus, @Nullable CompletableFuture<ChunkResult<ChunkAccess>>>> getAllFutures() {
        ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>> var0 = new ArrayList<Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>>();
        for (int var1 = 0; var1 < CHUNK_STATUSES.size(); ++var1) {
            var0.add((Pair<ChunkStatus, CompletableFuture<ChunkResult<ChunkAccess>>>)Pair.of((Object)CHUNK_STATUSES.get(var1), this.futures.get(var1)));
        }
        return var0;
    }

    @VisibleForDebug
    public @Nullable ChunkStatus getLatestStatus() {
        ChunkStatus var0 = this.startedWork.get();
        if (var0 == null) {
            return null;
        }
        ChunkAccess var1 = this.getChunkIfPresentUnchecked(var0);
        if (var1 != null) {
            return var0;
        }
        return var0.getParent();
    }
}

