/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import net.minecraft.core.SectionPos;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;

public abstract class SectionTracker
extends DynamicGraphMinFixedPoint {
    protected SectionTracker(int var0, int var1, int var2) {
        super(var0, var1, var2);
    }

    @Override
    protected void checkNeighborsAfterUpdate(long var0, int var2, boolean var3) {
        if (var3 && var2 >= this.levelCount - 2) {
            return;
        }
        for (int var4 = -1; var4 <= 1; ++var4) {
            for (int var5 = -1; var5 <= 1; ++var5) {
                for (int var6 = -1; var6 <= 1; ++var6) {
                    long var7 = SectionPos.offset(var0, var4, var5, var6);
                    if (var7 == var0) continue;
                    this.checkNeighbor(var0, var7, var2, var3);
                }
            }
        }
    }

    @Override
    protected int getComputedLevel(long var0, long var2, int var4) {
        int var5 = var4;
        for (int var6 = -1; var6 <= 1; ++var6) {
            for (int var7 = -1; var7 <= 1; ++var7) {
                for (int var8 = -1; var8 <= 1; ++var8) {
                    long var9 = SectionPos.offset(var0, var6, var7, var8);
                    if (var9 == var0) {
                        var9 = Long.MAX_VALUE;
                    }
                    if (var9 == var2) continue;
                    int var11 = this.computeLevelFromNeighbor(var9, var0, this.getLevel(var9));
                    if (var5 > var11) {
                        var5 = var11;
                    }
                    if (var5 != 0) continue;
                    return var5;
                }
            }
        }
        return var5;
    }

    @Override
    protected int computeLevelFromNeighbor(long var0, long var2, int var4) {
        if (this.isSource(var0)) {
            return this.getLevelFromSource(var2);
        }
        return var4 + 1;
    }

    protected abstract int getLevelFromSource(long var1);

    public void update(long var0, int var2, boolean var3) {
        this.checkEdge(Long.MAX_VALUE, var0, var2, var3);
    }
}

