/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.Util;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.attribute.EnvironmentAttributeReader;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.status.ChunkDependencies;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.WorldGenTickAccess;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class WorldGenRegion
implements WorldGenLevel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final StaticCache2D<GenerationChunkHolder> cache;
    private final ChunkAccess center;
    private final ServerLevel level;
    private final long seed;
    private final LevelData levelData;
    private final RandomSource random;
    private final DimensionType dimensionType;
    private final WorldGenTickAccess<Block> blockTicks = new WorldGenTickAccess(blockposition -> this.getChunk((BlockPos)blockposition).getBlockTicks());
    private final WorldGenTickAccess<Fluid> fluidTicks = new WorldGenTickAccess(blockposition -> this.getChunk((BlockPos)blockposition).getFluidTicks());
    private final BiomeManager biomeManager;
    private final ChunkStep generatingStep;
    private @Nullable Supplier<String> currentlyGenerating;
    private final AtomicLong subTickCount = new AtomicLong();
    private static final Identifier WORLDGEN_REGION_RANDOM = Identifier.withDefaultNamespace("worldgen_region_random");

    public WorldGenRegion(ServerLevel worldserver, StaticCache2D<GenerationChunkHolder> staticcache2d, ChunkStep chunkstep, ChunkAccess ichunkaccess) {
        this.generatingStep = chunkstep;
        this.cache = staticcache2d;
        this.center = ichunkaccess;
        this.level = worldserver;
        this.seed = worldserver.getSeed();
        this.levelData = worldserver.getLevelData();
        this.random = worldserver.getChunkSource().randomState().getOrCreateRandomFactory(WORLDGEN_REGION_RANDOM).at(this.center.getPos().getWorldPosition());
        this.dimensionType = worldserver.dimensionType();
        this.biomeManager = new BiomeManager(this, BiomeManager.obfuscateSeed(this.seed));
    }

    public boolean isOldChunkAround(ChunkPos chunkcoordintpair, int i) {
        return this.level.getChunkSource().chunkMap.isOldChunkAround(chunkcoordintpair, i);
    }

    public ChunkPos getCenter() {
        return this.center.getPos();
    }

    @Override
    public void setCurrentlyGenerating(@Nullable Supplier<String> supplier) {
        this.currentlyGenerating = supplier;
    }

    @Override
    public ChunkAccess getChunk(int i, int j) {
        return this.getChunk(i, j, ChunkStatus.EMPTY);
    }

    @Override
    public @Nullable ChunkAccess getChunk(int i, int j, ChunkStatus chunkstatus, boolean flag) {
        GenerationChunkHolder generationchunkholder;
        ChunkStatus chunkstatus1;
        int k = this.center.getPos().getChessboardDistance(i, j);
        ChunkStatus chunkStatus = chunkstatus1 = k >= this.generatingStep.directDependencies().size() ? null : this.generatingStep.directDependencies().get(k);
        if (chunkstatus1 != null) {
            ChunkAccess ichunkaccess;
            generationchunkholder = this.cache.get(i, j);
            if (chunkstatus.isOrBefore(chunkstatus1) && (ichunkaccess = generationchunkholder.getChunkIfPresentUnchecked(chunkstatus1)) != null) {
                return ichunkaccess;
            }
        } else {
            generationchunkholder = null;
        }
        CrashReport crashreport = CrashReport.forThrowable(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Chunk request details");
        crashreportsystemdetails.setDetail("Requested chunk", String.format(Locale.ROOT, "%d, %d", i, j));
        crashreportsystemdetails.setDetail("Generating status", () -> this.generatingStep.targetStatus().getName());
        Objects.requireNonNull(chunkstatus);
        crashreportsystemdetails.setDetail("Requested status", chunkstatus::getName);
        crashreportsystemdetails.setDetail("Actual status", () -> generationchunkholder == null ? "[out of cache bounds]" : generationchunkholder.getPersistedStatus().getName());
        crashreportsystemdetails.setDetail("Maximum allowed status", () -> chunkstatus1 == null ? "null" : chunkstatus1.getName());
        ChunkDependencies chunkdependencies = this.generatingStep.directDependencies();
        Objects.requireNonNull(chunkdependencies);
        crashreportsystemdetails.setDetail("Dependencies", chunkdependencies::toString);
        crashreportsystemdetails.setDetail("Requested distance", k);
        ChunkPos chunkcoordintpair = this.center.getPos();
        Objects.requireNonNull(chunkcoordintpair);
        crashreportsystemdetails.setDetail("Generating chunk", chunkcoordintpair::toString);
        throw new ReportedException(crashreport);
    }

    @Override
    public boolean hasChunk(int i, int j) {
        int k = this.center.getPos().getChessboardDistance(i, j);
        return k < this.generatingStep.directDependencies().size();
    }

    @Override
    public BlockState getBlockState(BlockPos blockposition) {
        return this.getChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ())).getBlockState(blockposition);
    }

    @Override
    public FluidState getFluidState(BlockPos blockposition) {
        return this.getChunk(blockposition).getFluidState(blockposition);
    }

    @Override
    public @Nullable Player getNearestPlayer(double d0, double d1, double d2, double d3, @Nullable Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int getSkyDarken() {
        return 0;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int i, int j, int k) {
        return this.level.getUncachedNoiseBiome(i, j, k);
    }

    @Override
    public float getShade(Direction enumdirection, boolean flag) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    @Override
    public boolean destroyBlock(BlockPos blockposition, boolean flag, @Nullable Entity entity, int i) {
        BlockState iblockdata = this.getBlockState(blockposition);
        if (iblockdata.isAir()) {
            return false;
        }
        return this.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 3, i);
    }

    @Override
    public @Nullable BlockEntity getBlockEntity(BlockPos blockposition) {
        ChunkAccess ichunkaccess = this.getChunk(blockposition);
        BlockEntity tileentity = ichunkaccess.getBlockEntity(blockposition);
        if (tileentity != null) {
            return tileentity;
        }
        CompoundTag nbttagcompound = ichunkaccess.getBlockEntityNbt(blockposition);
        BlockState iblockdata = ichunkaccess.getBlockState(blockposition);
        if (nbttagcompound != null) {
            if ("DUMMY".equals(nbttagcompound.getStringOr("id", ""))) {
                if (!iblockdata.hasBlockEntity()) {
                    return null;
                }
                tileentity = ((EntityBlock)((Object)iblockdata.getBlock())).newBlockEntity(blockposition, iblockdata);
            } else {
                tileentity = BlockEntity.loadStatic(blockposition, iblockdata, nbttagcompound, this.level.registryAccess());
            }
            if (tileentity != null) {
                ichunkaccess.setBlockEntity(tileentity);
                return tileentity;
            }
        }
        if (iblockdata.hasBlockEntity()) {
            LOGGER.warn("Tried to access a block entity before it was created. {}", (Object)blockposition);
        }
        return null;
    }

    @Override
    public boolean ensureCanWrite(BlockPos blockposition) {
        int i = SectionPos.blockToSectionCoord(blockposition.getX());
        int j = SectionPos.blockToSectionCoord(blockposition.getZ());
        ChunkPos chunkcoordintpair = this.getCenter();
        int k = Math.abs(chunkcoordintpair.x - i);
        int l = Math.abs(chunkcoordintpair.z - j);
        if (k <= this.generatingStep.blockStateWriteRadius() && l <= this.generatingStep.blockStateWriteRadius()) {
            LevelHeightAccessor levelheightaccessor;
            return !this.center.isUpgrading() || !(levelheightaccessor = this.center.getHeightAccessorForGeneration()).isOutsideBuildHeight(blockposition.getY());
        }
        Util.logAndPauseIfInIde("Detected setBlock in a far chunk [" + i + ", " + j + "], pos: " + String.valueOf(blockposition) + ", status: " + String.valueOf(this.generatingStep.targetStatus()) + (String)(this.currentlyGenerating == null ? "" : ", currently generating: " + this.currentlyGenerating.get()));
        return false;
    }

    @Override
    public boolean setBlock(BlockPos blockposition, BlockState iblockdata, @Block.UpdateFlags int i, int j) {
        if (!this.ensureCanWrite(blockposition)) {
            return false;
        }
        ChunkAccess ichunkaccess = this.getChunk(blockposition);
        BlockState iblockdata1 = ichunkaccess.setBlockState(blockposition, iblockdata, i);
        if (iblockdata1 != null) {
            this.level.updatePOIOnBlockStateChange(blockposition, iblockdata1, iblockdata);
        }
        if (iblockdata.hasBlockEntity()) {
            if (ichunkaccess.getPersistedStatus().getChunkType() == ChunkType.LEVELCHUNK) {
                BlockEntity tileentity = ((EntityBlock)((Object)iblockdata.getBlock())).newBlockEntity(blockposition, iblockdata);
                if (tileentity != null) {
                    ichunkaccess.setBlockEntity(tileentity);
                } else {
                    ichunkaccess.removeBlockEntity(blockposition);
                }
            } else {
                CompoundTag nbttagcompound = new CompoundTag();
                nbttagcompound.putInt("x", blockposition.getX());
                nbttagcompound.putInt("y", blockposition.getY());
                nbttagcompound.putInt("z", blockposition.getZ());
                nbttagcompound.putString("id", "DUMMY");
                ichunkaccess.setBlockEntityNbt(nbttagcompound);
            }
        } else if (iblockdata1 != null && iblockdata1.hasBlockEntity()) {
            ichunkaccess.removeBlockEntity(blockposition);
        }
        if (iblockdata.hasPostProcess(this, blockposition) && (i & 0x10) == 0) {
            this.markPosForPostprocessing(blockposition);
        }
        return true;
    }

    private void markPosForPostprocessing(BlockPos blockposition) {
        this.getChunk(blockposition).markPosForPostprocessing(blockposition);
    }

    @Override
    public boolean addFreshEntity(Entity entity) {
        return this.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    @Override
    public boolean addFreshEntity(Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        int i = SectionPos.blockToSectionCoord(entity.getBlockX());
        int j = SectionPos.blockToSectionCoord(entity.getBlockZ());
        this.getChunk(i, j).addEntity(entity);
        return true;
    }

    @Override
    public boolean removeBlock(BlockPos blockposition, boolean flag) {
        return this.setBlock(blockposition, Blocks.AIR.defaultBlockState(), 3);
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    @Deprecated
    public ServerLevel getLevel() {
        return this.level;
    }

    @Override
    public RegistryAccess registryAccess() {
        return this.level.registryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    @Override
    public LevelData getLevelData() {
        return this.levelData;
    }

    @Override
    public DifficultyInstance getCurrentDifficultyAt(BlockPos blockposition) {
        if (!this.hasChunk(SectionPos.blockToSectionCoord(blockposition.getX()), SectionPos.blockToSectionCoord(blockposition.getZ()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.level.getDifficulty(), this.level.getDayTime(), 0L, this.level.getMoonBrightness(blockposition));
    }

    @Override
    public @Nullable MinecraftServer getServer() {
        return this.level.getServer();
    }

    @Override
    public ChunkSource getChunkSource() {
        return this.level.getChunkSource();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public LevelTickAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public LevelTickAccess<Fluid> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public int getSeaLevel() {
        return this.level.getSeaLevel();
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public int getHeight(Heightmap.Types heightmap_type, int i, int j) {
        return this.getChunk(SectionPos.blockToSectionCoord(i), SectionPos.blockToSectionCoord(j)).getHeight(heightmap_type, i & 0xF, j & 0xF) + 1;
    }

    @Override
    public void playSound(@Nullable Entity entity, BlockPos blockposition, SoundEvent soundeffect, SoundSource soundcategory, float f, float f1) {
    }

    @Override
    public void addParticle(ParticleOptions particleparam, double d0, double d1, double d2, double d3, double d4, double d5) {
    }

    @Override
    public void levelEvent(@Nullable Entity entity, int i, BlockPos blockposition, int j) {
    }

    @Override
    public void gameEvent(Holder<GameEvent> holder, Vec3 vec3d, GameEvent.Context gameevent_a) {
    }

    @Override
    public DimensionType dimensionType() {
        return this.dimensionType;
    }

    @Override
    public boolean isStateAtPosition(BlockPos blockposition, Predicate<BlockState> predicate) {
        return predicate.test(this.getBlockState(blockposition));
    }

    @Override
    public boolean isFluidAtPosition(BlockPos blockposition, Predicate<FluidState> predicate) {
        return predicate.test(this.getFluidState(blockposition));
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> entitytypetest, AABB axisalignedbb, Predicate<? super T> predicate) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity entity, AABB axisalignedbb, @Nullable Predicate<? super Entity> predicate) {
        return Collections.emptyList();
    }

    public List<Player> players() {
        return Collections.emptyList();
    }

    @Override
    public int getMinY() {
        return this.level.getMinY();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }

    @Override
    public long nextSubTickCount() {
        return this.subTickCount.getAndIncrement();
    }

    @Override
    public EnvironmentAttributeReader environmentAttributes() {
        return EnvironmentAttributeReader.EMPTY;
    }
}

