/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.FilterMask;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.LegacyTextFilter;
import net.minecraft.server.network.PlayerSafetyServiceTextFilter;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.LenientJsonParser;
import net.minecraft.util.StringUtil;
import net.minecraft.util.Util;
import net.minecraft.util.thread.ConsecutiveExecutor;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class ServerTextFilter
implements AutoCloseable {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private static final ThreadFactory THREAD_FACTORY = var0 -> {
        Thread var1 = new Thread(var0);
        var1.setName("Chat-Filter-Worker-" + WORKER_COUNT.getAndIncrement());
        return var1;
    };
    private final URL chatEndpoint;
    private final MessageEncoder chatEncoder;
    final IgnoreStrategy chatIgnoreStrategy;
    final ExecutorService workerPool;

    protected static ExecutorService createWorkerPool(int var0) {
        return Executors.newFixedThreadPool(var0, THREAD_FACTORY);
    }

    protected ServerTextFilter(URL var0, MessageEncoder var1, IgnoreStrategy var2, ExecutorService var3) {
        this.chatIgnoreStrategy = var2;
        this.workerPool = var3;
        this.chatEndpoint = var0;
        this.chatEncoder = var1;
    }

    protected static URL getEndpoint(URI var0, @Nullable JsonObject var1, String var2, String var3) throws MalformedURLException {
        String var4 = ServerTextFilter.getEndpointFromConfig(var1, var2, var3);
        return var0.resolve("/" + var4).toURL();
    }

    protected static String getEndpointFromConfig(@Nullable JsonObject var0, String var1, String var2) {
        return var0 != null ? GsonHelper.getAsString(var0, var1, var2) : var2;
    }

    public static @Nullable ServerTextFilter createFromConfig(DedicatedServerProperties var0) {
        String var1 = var0.textFilteringConfig;
        if (StringUtil.isBlank(var1)) {
            return null;
        }
        return switch (var0.textFilteringVersion) {
            case 0 -> LegacyTextFilter.createTextFilterFromConfig(var1);
            case 1 -> PlayerSafetyServiceTextFilter.createTextFilterFromConfig(var1);
            default -> {
                LOGGER.warn("Could not create text filter - unsupported text filtering version used");
                yield null;
            }
        };
    }

    protected CompletableFuture<FilteredText> requestMessageProcessing(GameProfile var0, String var1, IgnoreStrategy var2, Executor var3) {
        if (var1.isEmpty()) {
            return CompletableFuture.completedFuture(FilteredText.EMPTY);
        }
        return CompletableFuture.supplyAsync(() -> {
            JsonObject var3 = this.chatEncoder.encode(var0, var1);
            try {
                JsonObject var4 = this.processRequestResponse(var3, this.chatEndpoint);
                return this.filterText(var1, var2, var4);
            }
            catch (Exception var4) {
                LOGGER.warn("Failed to validate message '{}'", (Object)var1, (Object)var4);
                return FilteredText.fullyFiltered(var1);
            }
        }, var3);
    }

    protected abstract FilteredText filterText(String var1, IgnoreStrategy var2, JsonObject var3);

    protected FilterMask parseMask(String var0, JsonArray var1, IgnoreStrategy var2) {
        if (var1.isEmpty()) {
            return FilterMask.PASS_THROUGH;
        }
        if (var2.shouldIgnore(var0, var1.size())) {
            return FilterMask.FULLY_FILTERED;
        }
        FilterMask var3 = new FilterMask(var0.length());
        for (int var4 = 0; var4 < var1.size(); ++var4) {
            var3.setFiltered(var1.get(var4).getAsInt());
        }
        return var3;
    }

    @Override
    public void close() {
        this.workerPool.shutdownNow();
    }

    protected void drainStream(InputStream var0) throws IOException {
        byte[] var1 = new byte[1024];
        while (var0.read(var1) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject processRequestResponse(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.makeRequest(var0, var1);
        try (InputStream var3 = var2.getInputStream();){
            JsonObject jsonObject;
            if (var2.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = LenientJsonParser.parse(new InputStreamReader(var3, StandardCharsets.UTF_8)).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.drainStream(var3);
                throw throwable;
            }
            this.drainStream(var3);
            return jsonObject;
        }
    }

    protected HttpURLConnection makeRequest(JsonObject var0, URL var1) throws IOException {
        HttpURLConnection var2 = this.getURLConnection(var1);
        this.setAuthorizationProperty(var2);
        try (OutputStreamWriter var3 = new OutputStreamWriter(var2.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter var4 = new JsonWriter((Writer)var3);){
            Streams.write((JsonElement)var0, (JsonWriter)var4);
        }
        int var5 = var2.getResponseCode();
        if (var5 < 200 || var5 >= 300) {
            throw new RequestFailedException(var5 + " " + var2.getResponseMessage());
        }
        return var2;
    }

    protected abstract void setAuthorizationProperty(HttpURLConnection var1);

    protected int connectionReadTimeout() {
        return 2000;
    }

    protected HttpURLConnection getURLConnection(URL var0) throws IOException {
        HttpURLConnection var1 = (HttpURLConnection)var0.openConnection();
        var1.setConnectTimeout(15000);
        var1.setReadTimeout(this.connectionReadTimeout());
        var1.setUseCaches(false);
        var1.setDoOutput(true);
        var1.setDoInput(true);
        var1.setRequestMethod("POST");
        var1.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        var1.setRequestProperty("Accept", "application/json");
        var1.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.getCurrentVersion().name());
        return var1;
    }

    public TextFilter createContext(GameProfile var0) {
        return new PlayerContext(var0);
    }

    @FunctionalInterface
    public static interface IgnoreStrategy {
        public static final IgnoreStrategy NEVER_IGNORE = (var0, var1) -> false;
        public static final IgnoreStrategy IGNORE_FULLY_FILTERED = (var0, var1) -> var0.length() == var1;

        public static IgnoreStrategy ignoreOverThreshold(int var0) {
            return (var1, var2) -> var2 >= var0;
        }

        public static IgnoreStrategy select(int var0) {
            return switch (var0) {
                case -1 -> NEVER_IGNORE;
                case 0 -> IGNORE_FULLY_FILTERED;
                default -> IgnoreStrategy.ignoreOverThreshold(var0);
            };
        }

        public boolean shouldIgnore(String var1, int var2);
    }

    @FunctionalInterface
    protected static interface MessageEncoder {
        public JsonObject encode(GameProfile var1, String var2);
    }

    protected static class RequestFailedException
    extends RuntimeException {
        protected RequestFailedException(String var0) {
            super(var0);
        }
    }

    protected class PlayerContext
    implements TextFilter {
        protected final GameProfile profile;
        protected final Executor streamExecutor;

        protected PlayerContext(GameProfile var1) {
            this.profile = var1;
            ConsecutiveExecutor var2 = new ConsecutiveExecutor(ServerTextFilter.this.workerPool, "chat stream for " + var1.name());
            this.streamExecutor = var2::schedule;
        }

        @Override
        public CompletableFuture<List<FilteredText>> processMessageBundle(List<String> var02) {
            List var1 = (List)var02.stream().map(var0 -> ServerTextFilter.this.requestMessageProcessing(this.profile, (String)var0, ServerTextFilter.this.chatIgnoreStrategy, this.streamExecutor)).collect(ImmutableList.toImmutableList());
            return Util.sequenceFailFast(var1).exceptionally(var0 -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<FilteredText> processStreamMessage(String var0) {
            return ServerTextFilter.this.requestMessageProcessing(this.profile, var0, ServerTextFilter.this.chatIgnoreStrategy, this.streamExecutor);
        }
    }
}

