/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.util.FileSystemUtil;
import net.minecraft.util.Util;
import org.slf4j.Logger;

public class VanillaPackResourcesBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Consumer<VanillaPackResourcesBuilder> developmentConfig = var0 -> {};
    private static final Map<PackType, Path> ROOT_DIR_BY_TYPE = (Map)Util.make(() -> {
        Class<VanillaPackResources> clazz = VanillaPackResources.class;
        synchronized (VanillaPackResources.class) {
            ImmutableMap.Builder var1 = ImmutableMap.builder();
            for (PackType var5 : PackType.values()) {
                String var6 = "/" + var5.getDirectory() + "/.mcassetsroot";
                URL var7 = VanillaPackResources.class.getResource(var6);
                if (var7 == null) {
                    LOGGER.error("File {} does not exist in classpath", (Object)var6);
                    continue;
                }
                try {
                    URI var8 = var7.toURI();
                    String var9 = var8.getScheme();
                    if (!"jar".equals(var9) && !"file".equals(var9)) {
                        LOGGER.warn("Assets URL '{}' uses unexpected schema", (Object)var8);
                    }
                    Path var10 = FileSystemUtil.safeGetPath(var8);
                    var1.put((Object)var5, (Object)var10.getParent());
                }
                catch (Exception var8) {
                    LOGGER.error("Couldn't resolve path to vanilla assets", (Throwable)var8);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return var1.build();
        }
    });
    private final Set<Path> rootPaths = new LinkedHashSet<Path>();
    private final Map<PackType, Set<Path>> pathsForType = new EnumMap<PackType, Set<Path>>(PackType.class);
    private BuiltInMetadata metadata = BuiltInMetadata.of();
    private final Set<String> namespaces = new HashSet<String>();

    private boolean validateDirPath(Path var0) {
        if (!Files.exists(var0, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(var0, new LinkOption[0])) {
            throw new IllegalArgumentException("Path " + String.valueOf(var0.toAbsolutePath()) + " is not directory");
        }
        return true;
    }

    private void pushRootPath(Path var0) {
        if (this.validateDirPath(var0)) {
            this.rootPaths.add(var0);
        }
    }

    private void pushPathForType(PackType var02, Path var1) {
        if (this.validateDirPath(var1)) {
            this.pathsForType.computeIfAbsent(var02, var0 -> new LinkedHashSet()).add(var1);
        }
    }

    public VanillaPackResourcesBuilder pushJarResources() {
        ROOT_DIR_BY_TYPE.forEach((var0, var1) -> {
            this.pushRootPath(var1.getParent());
            this.pushPathForType((PackType)((Object)var0), (Path)var1);
        });
        return this;
    }

    public VanillaPackResourcesBuilder pushClasspathResources(PackType var0, Class<?> var1) {
        Enumeration<URL> var2 = null;
        try {
            var2 = var1.getClassLoader().getResources(var0.getDirectory() + "/");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (var2 != null && var2.hasMoreElements()) {
            URL var3 = var2.nextElement();
            try {
                URI var4 = var3.toURI();
                if (!"file".equals(var4.getScheme())) continue;
                Path var5 = Paths.get(var4);
                this.pushRootPath(var5.getParent());
                this.pushPathForType(var0, var5);
            }
            catch (Exception var4) {
                LOGGER.error("Failed to extract path from {}", (Object)var3, (Object)var4);
            }
        }
        return this;
    }

    public VanillaPackResourcesBuilder applyDevelopmentConfig() {
        developmentConfig.accept(this);
        return this;
    }

    public VanillaPackResourcesBuilder pushUniversalPath(Path var0) {
        this.pushRootPath(var0);
        for (PackType var4 : PackType.values()) {
            this.pushPathForType(var4, var0.resolve(var4.getDirectory()));
        }
        return this;
    }

    public VanillaPackResourcesBuilder pushAssetPath(PackType var0, Path var1) {
        this.pushRootPath(var1);
        this.pushPathForType(var0, var1);
        return this;
    }

    public VanillaPackResourcesBuilder setMetadata(BuiltInMetadata var0) {
        this.metadata = var0;
        return this;
    }

    public VanillaPackResourcesBuilder exposeNamespace(String ... var0) {
        this.namespaces.addAll(Arrays.asList(var0));
        return this;
    }

    public VanillaPackResources build(PackLocationInfo var02) {
        return new VanillaPackResources(var02, this.metadata, Set.copyOf(this.namespaces), VanillaPackResourcesBuilder.copyAndReverse(this.rootPaths), Util.makeEnumMap(PackType.class, var0 -> VanillaPackResourcesBuilder.copyAndReverse(this.pathsForType.getOrDefault(var0, Set.of()))));
    }

    private static List<Path> copyAndReverse(Collection<Path> var0) {
        ArrayList<Path> var1 = new ArrayList<Path>(var0);
        Collections.reverse(var1);
        return List.copyOf(var1);
    }
}

