/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.validation.DirectoryValidator;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class BuiltInPackSource
implements RepositorySource {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String VANILLA_ID = "vanilla";
    public static final String TESTS_ID = "tests";
    public static final KnownPack CORE_PACK_INFO = KnownPack.vanilla("core");
    private final PackType packType;
    private final VanillaPackResources vanillaPack;
    private final Identifier packDir;
    private final DirectoryValidator validator;

    public BuiltInPackSource(PackType var0, VanillaPackResources var1, Identifier var2, DirectoryValidator var3) {
        this.packType = var0;
        this.vanillaPack = var1;
        this.packDir = var2;
        this.validator = var3;
    }

    @Override
    public void loadPacks(Consumer<Pack> var0) {
        Pack var1 = this.createVanillaPack(this.vanillaPack);
        if (var1 != null) {
            var0.accept(var1);
        }
        this.listBundledPacks(var0);
    }

    protected abstract @Nullable Pack createVanillaPack(PackResources var1);

    protected abstract Component getPackTitle(String var1);

    public VanillaPackResources getVanillaPack() {
        return this.vanillaPack;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void listBundledPacks(Consumer<Pack> var0) {
        HashMap<String, @Nullable Function> var12 = new HashMap<String, Function>();
        this.populatePackList(var12::put);
        var12.forEach((var1, var2) -> {
            Pack var3 = (Pack)var2.apply(var1);
            if (var3 != null) {
                var0.accept(var3);
            }
        });
    }

    protected void populatePackList(BiConsumer<String, Function<String, Pack>> var0) {
        this.vanillaPack.listRawPaths(this.packType, this.packDir, var1 -> this.discoverPacksInPath((Path)var1, var0));
    }

    protected void discoverPacksInPath(@Nullable Path var0, BiConsumer<String, Function<String, @Nullable Pack>> var1) {
        if (var0 != null && Files.isDirectory(var0, new LinkOption[0])) {
            try {
                FolderRepositorySource.discoverPacks(var0, this.validator, (var12, var2) -> var1.accept(BuiltInPackSource.pathToId(var12), var1 -> this.createBuiltinPack((String)var1, (Pack.ResourcesSupplier)var2, this.getPackTitle((String)var1))));
            }
            catch (IOException var22) {
                LOGGER.warn("Failed to discover packs in {}", (Object)var0, (Object)var22);
            }
        }
    }

    private static String pathToId(Path var0) {
        return StringUtils.removeEnd((String)var0.getFileName().toString(), (String)".zip");
    }

    protected abstract @Nullable Pack createBuiltinPack(String var1, Pack.ResourcesSupplier var2, Component var3);

    protected static Pack.ResourcesSupplier fixedResources(final PackResources var0) {
        return new Pack.ResourcesSupplier(){

            @Override
            public PackResources openPrimary(PackLocationInfo var02) {
                return var0;
            }

            @Override
            public PackResources openFull(PackLocationInfo var02, Pack.Metadata var1) {
                return var0;
            }
        };
    }
}

