/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Stream;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Util;
import org.bukkit.Bukkit;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class StoredUserList<K, V extends StoredUserEntry<K>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final File file;
    private final Map<String, V> map = Maps.newHashMap();
    protected final NotificationService notificationService;

    public StoredUserList(File file, NotificationService notificationservice) {
        this.file = file;
        this.notificationService = notificationservice;
    }

    public File getFile() {
        return this.file;
    }

    public boolean add(V v0) {
        String s = this.getKeyForUser(((StoredUserEntry)v0).getUser());
        StoredUserEntry v1 = (StoredUserEntry)this.map.get(s);
        if (v0.equals(v1)) {
            return false;
        }
        this.map.put(s, v0);
        try {
            this.save();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Could not save the list after adding a user.", (Throwable)ioexception);
        }
        return true;
    }

    public @Nullable V get(K k0) {
        this.removeExpired();
        return (V)((StoredUserEntry)this.map.get(this.getKeyForUser(k0)));
    }

    public boolean remove(K k0) {
        StoredUserEntry v0 = (StoredUserEntry)this.map.remove(this.getKeyForUser(k0));
        if (v0 == null) {
            return false;
        }
        try {
            this.save();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
        return true;
    }

    public boolean remove(StoredUserEntry<K> jsonlistentry) {
        return this.remove(Objects.requireNonNull(jsonlistentry.getUser()));
    }

    public void clear() {
        this.map.clear();
        try {
            this.save();
        }
        catch (IOException ioexception) {
            LOGGER.warn("Could not save the list after removing a user.", (Throwable)ioexception);
        }
    }

    public String[] getUserList() {
        return this.map.keySet().toArray(new String[0]);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    protected String getKeyForUser(K k0) {
        return k0.toString();
    }

    protected boolean contains(K k0) {
        this.removeExpired();
        return this.map.containsKey(this.getKeyForUser(k0));
    }

    private void removeExpired() {
        ArrayList list = Lists.newArrayList();
        for (StoredUserEntry v0 : this.map.values()) {
            if (!v0.hasExpired()) continue;
            list.add(v0.getUser());
        }
        for (Object k0 : list) {
            this.map.remove(this.getKeyForUser(k0));
        }
    }

    protected abstract StoredUserEntry<K> createEntry(JsonObject var1);

    public Collection<V> getEntries() {
        return this.map.values();
    }

    public void save() throws IOException {
        JsonArray jsonarray = new JsonArray();
        Stream<JsonObject> stream = this.map.values().stream().map(jsonlistentry -> {
            JsonObject jsonobject = new JsonObject();
            Objects.requireNonNull(jsonlistentry);
            return Util.make(jsonobject, jsonlistentry::serialize);
        });
        Objects.requireNonNull(jsonarray);
        stream.forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        try (BufferedWriter bufferedwriter = Files.newWriter((File)this.file, (Charset)StandardCharsets.UTF_8);){
            GSON.toJson((JsonElement)jsonarray, GSON.newJsonWriter((Writer)bufferedwriter));
        }
    }

    public void load() throws IOException {
        if (this.file.exists()) {
            try (BufferedReader bufferedreader = Files.newReader((File)this.file, (Charset)StandardCharsets.UTF_8);){
                this.map.clear();
                JsonArray jsonarray = (JsonArray)GSON.fromJson((Reader)bufferedreader, JsonArray.class);
                if (jsonarray == null) {
                    return;
                }
                for (JsonElement jsonelement : jsonarray) {
                    JsonObject jsonobject = GsonHelper.convertToJsonObject(jsonelement, "entry");
                    StoredUserEntry<K> jsonlistentry = this.createEntry(jsonobject);
                    if (jsonlistentry.getUser() == null) continue;
                    this.map.put(this.getKeyForUser(jsonlistentry.getUser()), jsonlistentry);
                }
            }
            catch (JsonParseException | NullPointerException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Unable to read file " + String.valueOf(this.file) + ", backing it up to {0}.backup and creating new copy.", ex);
                File backup = new File(String.valueOf(this.file) + ".backup");
                this.file.renameTo(backup);
                this.file.delete();
            }
        }
    }
}

