/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.gson.JsonObject;
import java.io.File;
import java.util.Objects;
import net.minecraft.server.notifications.NotificationService;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.StoredUserList;
import net.minecraft.server.players.UserWhiteListEntry;

public class UserWhiteList
extends StoredUserList<NameAndId, UserWhiteListEntry> {
    public UserWhiteList(File var0, NotificationService var1) {
        super(var0, var1);
    }

    @Override
    protected StoredUserEntry<NameAndId> createEntry(JsonObject var0) {
        return new UserWhiteListEntry(var0);
    }

    public boolean isWhiteListed(NameAndId var0) {
        return this.contains(var0);
    }

    @Override
    public boolean add(UserWhiteListEntry var0) {
        if (super.add(var0)) {
            if (var0.getUser() != null) {
                this.notificationService.playerAddedToAllowlist((NameAndId)var0.getUser());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(NameAndId var0) {
        if (super.remove(var0)) {
            this.notificationService.playerRemovedFromAllowlist(var0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        for (UserWhiteListEntry var1 : this.getEntries()) {
            if (var1.getUser() == null) continue;
            this.notificationService.playerRemovedFromAllowlist((NameAndId)var1.getUser());
        }
        super.clear();
    }

    @Override
    public String[] getUserList() {
        return (String[])this.getEntries().stream().map(StoredUserEntry::getUser).filter(Objects::nonNull).map(NameAndId::name).toArray(String[]::new);
    }

    @Override
    protected String getKeyForUser(NameAndId var0) {
        return var0.id().toString();
    }

    @Override
    protected /* synthetic */ String getKeyForUser(Object object) {
        return this.getKeyForUser((NameAndId)object);
    }

    @Override
    public /* synthetic */ boolean remove(Object object) {
        return this.remove((NameAndId)object);
    }
}

