/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.sounds;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.RegistryFileCodec;

public record SoundEvent(Identifier location, Optional<Float> fixedRange) {
    public static final Codec<SoundEvent> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Identifier.CODEC.fieldOf("sound_id").forGetter(SoundEvent::location), (App)Codec.FLOAT.lenientOptionalFieldOf("range").forGetter(SoundEvent::fixedRange)).apply((Applicative)var0, SoundEvent::create));
    public static final Codec<Holder<SoundEvent>> CODEC = RegistryFileCodec.create(Registries.SOUND_EVENT, DIRECT_CODEC);
    public static final StreamCodec<ByteBuf, SoundEvent> DIRECT_STREAM_CODEC = StreamCodec.composite(Identifier.STREAM_CODEC, SoundEvent::location, ByteBufCodecs.FLOAT.apply(ByteBufCodecs::optional), SoundEvent::fixedRange, SoundEvent::create);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<SoundEvent>> STREAM_CODEC = ByteBufCodecs.holder(Registries.SOUND_EVENT, DIRECT_STREAM_CODEC);

    private static SoundEvent create(Identifier var0, Optional<Float> var12) {
        return var12.map(var1 -> SoundEvent.createFixedRangeEvent(var0, var1.floatValue())).orElseGet(() -> SoundEvent.createVariableRangeEvent(var0));
    }

    public static SoundEvent createVariableRangeEvent(Identifier var0) {
        return new SoundEvent(var0, Optional.empty());
    }

    public static SoundEvent createFixedRangeEvent(Identifier var0, float var1) {
        return new SoundEvent(var0, Optional.of(Float.valueOf(var1)));
    }

    public float getRange(float var0) {
        return this.fixedRange.orElse(Float.valueOf(var0 > 1.0f ? 16.0f * var0 : 16.0f)).floatValue();
    }
}

