/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.game.ClientboundRecipeBookAddPacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookRemovePacket;
import net.minecraft.network.protocol.game.ClientboundRecipeBookSettingsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.slf4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    public static final String RECIPE_BOOK_TAG = "recipeBook";
    private static final Logger LOGGER = LogUtils.getLogger();
    private final DisplayResolver displayResolver;
    @VisibleForTesting
    public final Set<ResourceKey<Recipe<?>>> known = Sets.newIdentityHashSet();
    @VisibleForTesting
    protected final Set<ResourceKey<Recipe<?>>> highlight = Sets.newIdentityHashSet();

    public ServerRecipeBook(DisplayResolver recipebookserver_a) {
        this.displayResolver = recipebookserver_a;
    }

    public void add(ResourceKey<Recipe<?>> resourcekey) {
        this.known.add(resourcekey);
    }

    public boolean contains(ResourceKey<Recipe<?>> resourcekey) {
        return this.known.contains(resourcekey);
    }

    public void remove(ResourceKey<Recipe<?>> resourcekey) {
        this.known.remove(resourcekey);
        this.highlight.remove(resourcekey);
    }

    public void removeHighlight(ResourceKey<Recipe<?>> resourcekey) {
        this.highlight.remove(resourcekey);
    }

    private void addHighlight(ResourceKey<Recipe<?>> resourcekey) {
        this.highlight.add(resourcekey);
    }

    public int addRecipes(Collection<RecipeHolder<?>> collection, ServerPlayer entityplayer) {
        ArrayList<ClientboundRecipeBookAddPacket.Entry> list = new ArrayList<ClientboundRecipeBookAddPacket.Entry>();
        for (RecipeHolder<?> recipeholder : collection) {
            ResourceKey<Recipe<?>> resourcekey = recipeholder.id();
            if (this.known.contains(resourcekey) || recipeholder.value().isSpecial() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent(entityplayer, resourcekey.identifier())) continue;
            this.add(resourcekey);
            this.addHighlight(resourcekey);
            this.displayResolver.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)recipedisplayentry, recipeholder.value().showNotification(), true)));
            CriteriaTriggers.RECIPE_UNLOCKED.trigger(entityplayer, recipeholder);
        }
        if (!list.isEmpty() && entityplayer.connection != null) {
            entityplayer.connection.send(new ClientboundRecipeBookAddPacket(list, false));
        }
        return list.size();
    }

    public int removeRecipes(Collection<RecipeHolder<?>> collection, ServerPlayer entityplayer) {
        ArrayList list = Lists.newArrayList();
        for (RecipeHolder<?> recipeholder : collection) {
            ResourceKey<Recipe<?>> resourcekey = recipeholder.id();
            if (!this.known.contains(resourcekey)) continue;
            this.remove(resourcekey);
            this.displayResolver.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(recipedisplayentry.id()));
        }
        if (!list.isEmpty() && entityplayer.connection != null) {
            entityplayer.connection.send(new ClientboundRecipeBookRemovePacket(list));
        }
        return list.size();
    }

    private void loadRecipes(List<ResourceKey<Recipe<?>>> list, Consumer<ResourceKey<Recipe<?>>> consumer, Predicate<ResourceKey<Recipe<?>>> predicate) {
        for (ResourceKey<Recipe<?>> resourcekey : list) {
            if (!predicate.test(resourcekey)) {
                LOGGER.error("Tried to load unrecognized recipe: {} removed now.", resourcekey);
                continue;
            }
            consumer.accept(resourcekey);
        }
    }

    public void sendInitialRecipeBook(ServerPlayer entityplayer) {
        entityplayer.connection.send(new ClientboundRecipeBookSettingsPacket(this.getBookSettings().copy()));
        ArrayList<ClientboundRecipeBookAddPacket.Entry> list = new ArrayList<ClientboundRecipeBookAddPacket.Entry>(this.known.size());
        for (ResourceKey<Recipe<?>> resourcekey : this.known) {
            this.displayResolver.displaysForRecipe(resourcekey, recipedisplayentry -> list.add(new ClientboundRecipeBookAddPacket.Entry((RecipeDisplayEntry)recipedisplayentry, false, this.highlight.contains(resourcekey))));
        }
        entityplayer.connection.send(new ClientboundRecipeBookAddPacket(list, true));
    }

    public void copyOverData(ServerRecipeBook recipebookserver) {
        this.apply(recipebookserver.pack());
    }

    public Packed pack() {
        return new Packed(this.bookSettings.copy(), List.copyOf(this.known), List.copyOf(this.highlight));
    }

    private void apply(Packed recipebookserver_b) {
        this.known.clear();
        this.highlight.clear();
        this.bookSettings.replaceFrom(recipebookserver_b.settings);
        this.known.addAll(recipebookserver_b.known);
        this.highlight.addAll(recipebookserver_b.highlight);
    }

    public void loadUntrusted(Packed recipebookserver_b, Predicate<ResourceKey<Recipe<?>>> predicate) {
        this.bookSettings.replaceFrom(recipebookserver_b.settings);
        List<ResourceKey<Recipe<?>>> list = recipebookserver_b.known;
        Set<ResourceKey<Recipe<?>>> set = this.known;
        Objects.requireNonNull(this.known);
        this.loadRecipes(list, set::add, predicate);
        list = recipebookserver_b.highlight;
        set = this.highlight;
        Objects.requireNonNull(this.highlight);
        this.loadRecipes(list, set::add, predicate);
    }

    @FunctionalInterface
    public static interface DisplayResolver {
        public void displaysForRecipe(ResourceKey<Recipe<?>> var1, Consumer<RecipeDisplayEntry> var2);
    }

    public record Packed(RecipeBookSettings settings, List<ResourceKey<Recipe<?>>> known, List<ResourceKey<Recipe<?>>> highlight) {
        public static final Codec<Packed> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RecipeBookSettings.MAP_CODEC.forGetter(Packed::settings), (App)Recipe.KEY_CODEC.listOf().fieldOf("recipes").forGetter(Packed::known), (App)Recipe.KEY_CODEC.listOf().fieldOf("toBeDisplayed").forGetter(Packed::highlight)).apply((Applicative)instance, Packed::new));
    }
}

