/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;
import net.minecraft.util.ExtraCodecs;
import org.jspecify.annotations.Nullable;

public class TagEntry {
    private static final Codec<TagEntry> FULL_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.TAG_OR_ELEMENT_ID.fieldOf("id").forGetter(TagEntry::elementOrTag), (App)Codec.BOOL.optionalFieldOf("required", (Object)true).forGetter(var0 -> var0.required)).apply((Applicative)var02, TagEntry::new));
    public static final Codec<TagEntry> CODEC = Codec.either(ExtraCodecs.TAG_OR_ELEMENT_ID, FULL_CODEC).xmap(var02 -> (TagEntry)var02.map(var0 -> new TagEntry((ExtraCodecs.TagOrElementLocation)var0, true), var0 -> var0), var0 -> var0.required ? Either.left((Object)var0.elementOrTag()) : Either.right((Object)var0));
    private final Identifier id;
    private final boolean tag;
    private final boolean required;

    private TagEntry(Identifier var0, boolean var1, boolean var2) {
        this.id = var0;
        this.tag = var1;
        this.required = var2;
    }

    private TagEntry(ExtraCodecs.TagOrElementLocation var0, boolean var1) {
        this.id = var0.id();
        this.tag = var0.tag();
        this.required = var1;
    }

    private ExtraCodecs.TagOrElementLocation elementOrTag() {
        return new ExtraCodecs.TagOrElementLocation(this.id, this.tag);
    }

    public static TagEntry element(Identifier var0) {
        return new TagEntry(var0, false, true);
    }

    public static TagEntry optionalElement(Identifier var0) {
        return new TagEntry(var0, false, false);
    }

    public static TagEntry tag(Identifier var0) {
        return new TagEntry(var0, true, true);
    }

    public static TagEntry optionalTag(Identifier var0) {
        return new TagEntry(var0, true, false);
    }

    public <T> boolean build(Lookup<T> var0, Consumer<T> var1) {
        if (this.tag) {
            Collection<T> var2 = var0.tag(this.id);
            if (var2 == null) {
                return !this.required;
            }
            var2.forEach(var1);
        } else {
            T var2 = var0.element(this.id, this.required);
            if (var2 == null) {
                return !this.required;
            }
            var1.accept(var2);
        }
        return true;
    }

    public void visitRequiredDependencies(Consumer<Identifier> var0) {
        if (this.tag && this.required) {
            var0.accept(this.id);
        }
    }

    public void visitOptionalDependencies(Consumer<Identifier> var0) {
        if (this.tag && !this.required) {
            var0.accept(this.id);
        }
    }

    public boolean verifyIfPresent(Predicate<Identifier> var0, Predicate<Identifier> var1) {
        return !this.required || (this.tag ? var1 : var0).test(this.id);
    }

    public String toString() {
        StringBuilder var0 = new StringBuilder();
        if (this.tag) {
            var0.append('#');
        }
        var0.append(this.id);
        if (!this.required) {
            var0.append('?');
        }
        return var0.toString();
    }

    public static interface Lookup<T> {
        public @Nullable T element(Identifier var1, boolean var2);

        public @Nullable Collection<T> tag(Identifier var1);
    }
}

