/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import net.minecraft.util.EasingType;
import net.minecraft.util.Mth;

public class BinaryAnimator {
    private final int animationLength;
    private final EasingType easing;
    private int ticks;
    private int ticksOld;

    public BinaryAnimator(int var0, EasingType var1) {
        this.animationLength = var0;
        this.easing = var1;
    }

    public BinaryAnimator(int var0) {
        this(var0, EasingType.LINEAR);
    }

    public void tick(boolean var0) {
        this.ticksOld = this.ticks;
        if (var0) {
            if (this.ticks < this.animationLength) {
                ++this.ticks;
            }
        } else if (this.ticks > 0) {
            --this.ticks;
        }
    }

    public float getFactor(float var0) {
        float var1 = Mth.lerp(var0, this.ticksOld, this.ticks) / (float)this.animationLength;
        return this.easing.apply(var1);
    }
}

