/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.BoundedFloatFunction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C, I extends BoundedFloatFunction<C>>
extends BoundedFloatFunction<C> {
    @VisibleForDebug
    public String parityString();

    public CubicSpline<C, I> mapAll(CoordinateVisitor<I> var1);

    public static <C, I extends BoundedFloatFunction<C>> Codec<CubicSpline<C, I>> codec(Codec<I> var03) {
        record Point<C, I extends BoundedFloatFunction<C>>(float location, CubicSpline<C, I> value, float derivative) {
        }
        MutableObject var1 = new MutableObject();
        Codec var22 = RecordCodecBuilder.create(var12 -> var12.group((App)Codec.FLOAT.fieldOf("location").forGetter(Point::location), (App)Codec.lazyInitialized((Supplier)var1).fieldOf("value").forGetter(Point::value), (App)Codec.FLOAT.fieldOf("derivative").forGetter(Point::derivative)).apply((Applicative)var12, (var0, var1, var2) -> new Point((float)var0, var1, (float)var2)));
        Codec var3 = RecordCodecBuilder.create(var2 -> var2.group((App)var03.fieldOf("coordinate").forGetter(Multipoint::coordinate), (App)ExtraCodecs.nonEmptyList(var22.listOf()).fieldOf("points").forGetter(var0 -> IntStream.range(0, var0.locations.length).mapToObj(var1 -> new Point(var0.locations()[var1], var0.values().get(var1), var0.derivatives()[var1])).toList())).apply((Applicative)var2, (var0, var1) -> {
            Object var2 = new float[var1.size()];
            ImmutableList.Builder var3 = ImmutableList.builder();
            float[] var4 = new float[var1.size()];
            for (int var5 = 0; var5 < var1.size(); ++var5) {
                Point var6 = (Point)var1.get(var5);
                var2[var5] = var6.location();
                var3.add(var6.value());
                var4[var5] = var6.derivative();
            }
            return Multipoint.create(var0, var2, var3.build(), var4);
        }));
        var1.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)var3).xmap(var02 -> (CubicSpline)var02.map(Constant::new, var0 -> var0), var0 -> {
            Either either;
            if (var0 instanceof Constant) {
                Constant var1 = (Constant)var0;
                either = Either.left((Object)Float.valueOf(var1.value()));
            } else {
                either = Either.right((Object)((Multipoint)var0));
            }
            return either;
        }));
        return (Codec)var1.get();
    }

    public static <C, I extends BoundedFloatFunction<C>> CubicSpline<C, I> constant(float var0) {
        return new Constant(var0);
    }

    public static <C, I extends BoundedFloatFunction<C>> Builder<C, I> builder(I var0) {
        return new Builder(var0);
    }

    public static <C, I extends BoundedFloatFunction<C>> Builder<C, I> builder(I var0, BoundedFloatFunction<Float> var1) {
        return new Builder(var0, var1);
    }

    @VisibleForDebug
    public record Constant<C, I extends BoundedFloatFunction<C>>(float value) implements CubicSpline<C, I>
    {
        @Override
        public float apply(C var0) {
            return this.value;
        }

        @Override
        public String parityString() {
            return String.format(Locale.ROOT, "k=%.3f", Float.valueOf(this.value));
        }

        @Override
        public float minValue() {
            return this.value;
        }

        @Override
        public float maxValue() {
            return this.value;
        }

        @Override
        public CubicSpline<C, I> mapAll(CoordinateVisitor<I> var0) {
            return this;
        }
    }

    public static final class Builder<C, I extends BoundedFloatFunction<C>> {
        private final I coordinate;
        private final BoundedFloatFunction<Float> valueTransformer;
        private final FloatList locations = new FloatArrayList();
        private final List<CubicSpline<C, I>> values = Lists.newArrayList();
        private final FloatList derivatives = new FloatArrayList();

        protected Builder(I var0) {
            this(var0, BoundedFloatFunction.IDENTITY);
        }

        protected Builder(I var0, BoundedFloatFunction<Float> var1) {
            this.coordinate = var0;
            this.valueTransformer = var1;
        }

        public Builder<C, I> addPoint(float var0, float var1) {
            return this.addPoint(var0, new Constant(this.valueTransformer.apply(Float.valueOf(var1))), 0.0f);
        }

        public Builder<C, I> addPoint(float var0, float var1, float var2) {
            return this.addPoint(var0, new Constant(this.valueTransformer.apply(Float.valueOf(var1))), var2);
        }

        public Builder<C, I> addPoint(float var0, CubicSpline<C, I> var1) {
            return this.addPoint(var0, var1, 0.0f);
        }

        private Builder<C, I> addPoint(float var0, CubicSpline<C, I> var1, float var2) {
            if (!this.locations.isEmpty() && var0 <= this.locations.getFloat(this.locations.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.locations.add(var0);
            this.values.add(var1);
            this.derivatives.add(var2);
            return this;
        }

        public CubicSpline<C, I> build() {
            if (this.locations.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return Multipoint.create(this.coordinate, this.locations.toFloatArray(), ImmutableList.copyOf(this.values), this.derivatives.toFloatArray());
        }
    }

    @VisibleForDebug
    public static final class Multipoint<C, I extends BoundedFloatFunction<C>>
    extends Record
    implements CubicSpline<C, I> {
        private final I coordinate;
        final float[] locations;
        private final List<CubicSpline<C, I>> values;
        private final float[] derivatives;
        private final float minValue;
        private final float maxValue;

        public Multipoint(I var0, float[] var1, List<CubicSpline<C, I>> var2, float[] var3, float var4, float var5) {
            Multipoint.validateSizes(var1, var2, var3);
            this.coordinate = var0;
            this.locations = var1;
            this.values = var2;
            this.derivatives = var3;
            this.minValue = var4;
            this.maxValue = var5;
        }

        static <C, I extends BoundedFloatFunction<C>> Multipoint<C, I> create(I var0, float[] var1, List<CubicSpline<C, I>> var2, float[] var3) {
            float var10;
            float var9;
            Multipoint.validateSizes(var1, var2, var3);
            int var4 = var1.length - 1;
            float var5 = Float.POSITIVE_INFINITY;
            float var6 = Float.NEGATIVE_INFINITY;
            float var7 = var0.minValue();
            float var8 = var0.maxValue();
            if (var7 < var1[0]) {
                var9 = Multipoint.linearExtend(var7, var1, var2.get(0).minValue(), var3, 0);
                var10 = Multipoint.linearExtend(var7, var1, var2.get(0).maxValue(), var3, 0);
                var5 = Math.min(var5, Math.min(var9, var10));
                var6 = Math.max(var6, Math.max(var9, var10));
            }
            if (var8 > var1[var4]) {
                var9 = Multipoint.linearExtend(var8, var1, var2.get(var4).minValue(), var3, var4);
                var10 = Multipoint.linearExtend(var8, var1, var2.get(var4).maxValue(), var3, var4);
                var5 = Math.min(var5, Math.min(var9, var10));
                var6 = Math.max(var6, Math.max(var9, var10));
            }
            for (CubicSpline<C, I> var102 : var2) {
                var5 = Math.min(var5, var102.minValue());
                var6 = Math.max(var6, var102.maxValue());
            }
            for (int var92 = 0; var92 < var4; ++var92) {
                var10 = var1[var92];
                float var11 = var1[var92 + 1];
                float var12 = var11 - var10;
                CubicSpline<C, I> var13 = var2.get(var92);
                CubicSpline<C, I> var14 = var2.get(var92 + 1);
                float var15 = var13.minValue();
                float var16 = var13.maxValue();
                float var17 = var14.minValue();
                float var18 = var14.maxValue();
                float var19 = var3[var92];
                float var20 = var3[var92 + 1];
                if (var19 == 0.0f && var20 == 0.0f) continue;
                float var21 = var19 * var12;
                float var22 = var20 * var12;
                float var23 = Math.min(var15, var17);
                float var24 = Math.max(var16, var18);
                float var25 = var21 - var18 + var15;
                float var26 = var21 - var17 + var16;
                float var27 = -var22 + var17 - var16;
                float var28 = -var22 + var18 - var15;
                float var29 = Math.min(var25, var27);
                float var30 = Math.max(var26, var28);
                var5 = Math.min(var5, var23 + 0.25f * var29);
                var6 = Math.max(var6, var24 + 0.25f * var30);
            }
            return new Multipoint<C, I>(var0, var1, var2, var3, var5, var6);
        }

        private static float linearExtend(float var0, float[] var1, float var2, float[] var3, int var4) {
            float var5 = var3[var4];
            if (var5 == 0.0f) {
                return var2;
            }
            return var2 + var5 * (var0 - var1[var4]);
        }

        private static <C, I extends BoundedFloatFunction<C>> void validateSizes(float[] var0, List<CubicSpline<C, I>> var1, float[] var2) {
            if (var0.length != var1.size() || var0.length != var2.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + var0.length + " " + var1.size() + " " + var2.length);
            }
            if (var0.length == 0) {
                throw new IllegalArgumentException("Cannot create a multipoint spline with no points");
            }
        }

        @Override
        public float apply(C var0) {
            float var1 = this.coordinate.apply(var0);
            int var2 = Multipoint.findIntervalStart(this.locations, var1);
            int var3 = this.locations.length - 1;
            if (var2 < 0) {
                return Multipoint.linearExtend(var1, this.locations, this.values.get(0).apply(var0), this.derivatives, 0);
            }
            if (var2 == var3) {
                return Multipoint.linearExtend(var1, this.locations, this.values.get(var3).apply(var0), this.derivatives, var3);
            }
            float var4 = this.locations[var2];
            float var5 = this.locations[var2 + 1];
            float var6 = (var1 - var4) / (var5 - var4);
            BoundedFloatFunction var7 = this.values.get(var2);
            BoundedFloatFunction var8 = this.values.get(var2 + 1);
            float var9 = this.derivatives[var2];
            float var10 = this.derivatives[var2 + 1];
            float var11 = var7.apply(var0);
            float var12 = var8.apply(var0);
            float var13 = var9 * (var5 - var4) - (var12 - var11);
            float var14 = -var10 * (var5 - var4) + (var12 - var11);
            float var15 = Mth.lerp(var6, var11, var12) + var6 * (1.0f - var6) * Mth.lerp(var6, var13, var14);
            return var15;
        }

        private static int findIntervalStart(float[] var0, float var1) {
            return Mth.binarySearch(0, var0.length, var2 -> var1 < var0[var2]) - 1;
        }

        @Override
        @VisibleForTesting
        public String parityString() {
            return "Spline{coordinate=" + String.valueOf(this.coordinate) + ", locations=" + this.toString(this.locations) + ", derivatives=" + this.toString(this.derivatives) + ", values=" + this.values.stream().map(CubicSpline::parityString).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String toString(float[] var02) {
            return "[" + IntStream.range(0, var02.length).mapToDouble(var1 -> var02[var1]).mapToObj(var0 -> String.format(Locale.ROOT, "%.3f", var0)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public CubicSpline<C, I> mapAll(CoordinateVisitor<I> var0) {
            return Multipoint.create((BoundedFloatFunction)var0.visit(this.coordinate), this.locations, this.values().stream().map(var1 -> var1.mapAll(var0)).toList(), this.derivatives);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Multipoint.class, "coordinate;locations;values;derivatives;minValue;maxValue", "coordinate", "locations", "values", "derivatives", "minValue", "maxValue"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Multipoint.class, "coordinate;locations;values;derivatives;minValue;maxValue", "coordinate", "locations", "values", "derivatives", "minValue", "maxValue"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Multipoint.class, "coordinate;locations;values;derivatives;minValue;maxValue", "coordinate", "locations", "values", "derivatives", "minValue", "maxValue"}, this, var0);
        }

        public I coordinate() {
            return this.coordinate;
        }

        public float[] locations() {
            return this.locations;
        }

        public List<CubicSpline<C, I>> values() {
            return this.values;
        }

        public float[] derivatives() {
            return this.derivatives;
        }

        @Override
        public float minValue() {
            return this.minValue;
        }

        @Override
        public float maxValue() {
            return this.maxValue;
        }
    }

    public static interface CoordinateVisitor<I> {
        public I visit(I var1);
    }
}

