/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.EasingType;
import net.minecraft.util.Keyframe;
import net.minecraft.util.KeyframeTrackSampler;
import net.minecraft.world.attribute.LerpFunction;

public record KeyframeTrack<T>(List<Keyframe<T>> keyframes, EasingType easingType) {
    public KeyframeTrack {
        if (var0.isEmpty()) {
            throw new IllegalArgumentException("Track has no keyframes");
        }
    }

    public static <T> MapCodec<KeyframeTrack<T>> mapCodec(Codec<T> var0) {
        Codec var12 = Keyframe.codec(var0).listOf().validate(KeyframeTrack::validateKeyframes);
        return RecordCodecBuilder.mapCodec((T var1) -> var1.group((App)var12.fieldOf("keyframes").forGetter(KeyframeTrack::keyframes), (App)EasingType.CODEC.optionalFieldOf("ease", (Object)EasingType.LINEAR).forGetter(KeyframeTrack::easingType)).apply((Applicative)var1, KeyframeTrack::new));
    }

    static <T> DataResult<List<Keyframe<T>>> validateKeyframes(List<Keyframe<T>> var0) {
        if (var0.isEmpty()) {
            return DataResult.error(() -> "Keyframes must not be empty");
        }
        if (!Comparators.isInOrder(var0, Comparator.comparingInt(Keyframe::ticks))) {
            return DataResult.error(() -> "Keyframes must be ordered by ticks field");
        }
        if (var0.size() > 1) {
            int var1 = 0;
            int var2 = var0.getLast().ticks();
            for (Keyframe var4 : var0) {
                if (var4.ticks() == var2) {
                    if (++var1 > 2) {
                        return DataResult.error(() -> "More than 2 keyframes on same tick: " + var4.ticks());
                    }
                } else {
                    var1 = 0;
                }
                var2 = var4.ticks();
            }
        }
        return DataResult.success(var0);
    }

    public static DataResult<KeyframeTrack<?>> validatePeriod(KeyframeTrack<?> var0, int var1) {
        for (Keyframe<?> var3 : var0.keyframes()) {
            int var4 = var3.ticks();
            if (var4 >= 0 && var4 <= var1) continue;
            return DataResult.error(() -> "Keyframe at tick " + var3.ticks() + " must be in range [0; " + var1 + "]");
        }
        return DataResult.success(var0);
    }

    public KeyframeTrackSampler<T> bakeSampler(Optional<Integer> var0, LerpFunction<T> var1) {
        return new KeyframeTrackSampler<T>(this, var0, var1);
    }

    public static class Builder<T> {
        private final ImmutableList.Builder<Keyframe<T>> keyframes = ImmutableList.builder();
        private EasingType easing = EasingType.LINEAR;

        public Builder<T> addKeyframe(int var0, T var1) {
            this.keyframes.add(new Keyframe<T>(var0, var1));
            return this;
        }

        public Builder<T> setEasing(EasingType var0) {
            this.easing = var0;
            return this;
        }

        public KeyframeTrack<T> build() {
            List var0 = (List)KeyframeTrack.validateKeyframes(this.keyframes.build()).getOrThrow();
            return new KeyframeTrack(var0, this.easing);
        }
    }
}

