/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public interface ProblemReporter {
    public static final ProblemReporter DISCARDING = new ProblemReporter(){

        @Override
        public ProblemReporter forChild(PathElement var0) {
            return this;
        }

        @Override
        public void report(Problem var0) {
        }
    };

    public ProblemReporter forChild(PathElement var1);

    public void report(Problem var1);

    public static class ScopedCollector
    extends Collector
    implements AutoCloseable {
        private final Logger logger;

        public ScopedCollector(Logger var0) {
            this.logger = var0;
        }

        public ScopedCollector(PathElement var0, Logger var1) {
            super(var0);
            this.logger = var1;
        }

        @Override
        public void close() {
            if (!this.isEmpty()) {
                this.logger.warn("[{}] Serialization errors:\n{}", (Object)this.logger.getName(), (Object)this.getTreeReport());
            }
        }
    }

    public static class Collector
    implements ProblemReporter {
        public static final PathElement EMPTY_ROOT = () -> "";
        private final @Nullable Collector parent;
        private final PathElement element;
        private final Set<Entry> problems;

        public Collector() {
            this(EMPTY_ROOT);
        }

        public Collector(PathElement var0) {
            this.parent = null;
            this.problems = new LinkedHashSet<Entry>();
            this.element = var0;
        }

        private Collector(Collector var0, PathElement var1) {
            this.problems = var0.problems;
            this.parent = var0;
            this.element = var1;
        }

        @Override
        public ProblemReporter forChild(PathElement var0) {
            return new Collector(this, var0);
        }

        @Override
        public void report(Problem var0) {
            this.problems.add(new Entry(this, var0));
        }

        public boolean isEmpty() {
            return this.problems.isEmpty();
        }

        public void forEach(BiConsumer<String, Problem> var0) {
            ArrayList<PathElement> var1 = new ArrayList<PathElement>();
            StringBuilder var2 = new StringBuilder();
            for (Entry var4 : this.problems) {
                Collector var5 = var4.source;
                while (var5 != null) {
                    var1.add(var5.element);
                    var5 = var5.parent;
                }
                for (int var6 = var1.size() - 1; var6 >= 0; --var6) {
                    var2.append(((PathElement)var1.get(var6)).get());
                }
                var0.accept(var2.toString(), var4.problem());
                var2.setLength(0);
                var1.clear();
            }
        }

        public String getReport() {
            HashMultimap var02 = HashMultimap.create();
            this.forEach((arg_0, arg_1) -> ((Multimap)var02).put(arg_0, arg_1));
            return var02.asMap().entrySet().stream().map(var0 -> " at " + (String)var0.getKey() + ": " + ((Collection)var0.getValue()).stream().map(Problem::description).collect(Collectors.joining("; "))).collect(Collectors.joining("\n"));
        }

        public String getTreeReport() {
            ArrayList<PathElement> var0 = new ArrayList<PathElement>();
            ProblemTreeNode var1 = new ProblemTreeNode(this.element);
            for (Entry var3 : this.problems) {
                Collector var4 = var3.source;
                while (var4 != this) {
                    var0.add(var4.element);
                    var4 = var4.parent;
                }
                ProblemTreeNode var5 = var1;
                for (int var6 = var0.size() - 1; var6 >= 0; --var6) {
                    var5 = var5.child((PathElement)var0.get(var6));
                }
                var0.clear();
                var5.problems.add(var3.problem);
            }
            return String.join((CharSequence)"\n", var1.getLines());
        }

        static final class Entry
        extends Record {
            final Collector source;
            final Problem problem;

            Entry(Collector var0, Problem var1) {
                this.source = var0;
                this.problem = var1;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Entry.class, "source;problem", "source", "problem"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Entry.class, "source;problem", "source", "problem"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Entry.class, "source;problem", "source", "problem"}, this, var0);
            }

            public Collector source() {
                return this.source;
            }

            public Problem problem() {
                return this.problem;
            }
        }

        static final class ProblemTreeNode
        extends Record {
            private final PathElement element;
            final List<Problem> problems;
            private final Map<PathElement, ProblemTreeNode> children;

            public ProblemTreeNode(PathElement var0) {
                this(var0, new ArrayList<Problem>(), new LinkedHashMap<PathElement, ProblemTreeNode>());
            }

            private ProblemTreeNode(PathElement var0, List<Problem> var1, Map<PathElement, ProblemTreeNode> var2) {
                this.element = var0;
                this.problems = var1;
                this.children = var2;
            }

            public ProblemTreeNode child(PathElement var0) {
                return this.children.computeIfAbsent(var0, ProblemTreeNode::new);
            }

            public List<String> getLines() {
                int var02 = this.problems.size();
                int var12 = this.children.size();
                if (var02 == 0 && var12 == 0) {
                    return List.of();
                }
                if (var02 == 0 && var12 == 1) {
                    ArrayList<String> var22 = new ArrayList<String>();
                    this.children.forEach((var1, var2) -> var22.addAll(var2.getLines()));
                    var22.set(0, this.element.get() + (String)var22.get(0));
                    return var22;
                }
                if (var02 == 1 && var12 == 0) {
                    return List.of(this.element.get() + ": " + this.problems.getFirst().description());
                }
                ArrayList<String> var23 = new ArrayList<String>();
                this.children.forEach((var1, var2) -> var23.addAll(var2.getLines()));
                var23.replaceAll(var0 -> "  " + var0);
                for (Problem var4 : this.problems) {
                    var23.add("  " + var4.description());
                }
                var23.addFirst(this.element.get() + ":");
                return var23;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ProblemTreeNode.class, "element;problems;children", "element", "problems", "children"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ProblemTreeNode.class, "element;problems;children", "element", "problems", "children"}, this);
            }

            @Override
            public final boolean equals(Object var0) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ProblemTreeNode.class, "element;problems;children", "element", "problems", "children"}, this, var0);
            }

            public PathElement element() {
                return this.element;
            }

            public List<Problem> problems() {
                return this.problems;
            }

            public Map<PathElement, ProblemTreeNode> children() {
                return this.children;
            }
        }
    }

    public record ElementReferencePathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "->{" + String.valueOf(this.id.identifier()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public record IndexedPathElement(int index) implements PathElement
    {
        @Override
        public String get() {
            return "[" + this.index + "]";
        }
    }

    public record IndexedFieldPathElement(String name, int index) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name + "[" + this.index + "]";
        }
    }

    public record FieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return "." + this.name;
        }
    }

    public record RootElementPathElement(ResourceKey<?> id) implements PathElement
    {
        @Override
        public String get() {
            return "{" + String.valueOf(this.id.identifier()) + "@" + String.valueOf(this.id.registry()) + "}";
        }
    }

    public record RootFieldPathElement(String name) implements PathElement
    {
        @Override
        public String get() {
            return this.name;
        }
    }

    @FunctionalInterface
    public static interface PathElement {
        public String get();
    }

    public static interface Problem {
        public String description();
    }
}

