/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.context;

import com.google.common.collect.Sets;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.util.context.ContextKey;
import net.minecraft.util.context.ContextKeySet;
import org.jetbrains.annotations.Contract;
import org.jspecify.annotations.Nullable;

public class ContextMap {
    private final Map<ContextKey<?>, Object> params;

    ContextMap(Map<ContextKey<?>, Object> var0) {
        this.params = var0;
    }

    public boolean has(ContextKey<?> var0) {
        return this.params.containsKey(var0);
    }

    public <T> T getOrThrow(ContextKey<T> var0) {
        Object var1 = this.params.get(var0);
        if (var1 == null) {
            throw new NoSuchElementException(var0.name().toString());
        }
        return (T)var1;
    }

    public <T> @Nullable T getOptional(ContextKey<T> var0) {
        return (T)this.params.get(var0);
    }

    @Contract(value="_,!null->!null; _,_->_")
    public <T> @Nullable T getOrDefault(ContextKey<T> var0, @Nullable T var1) {
        return (T)this.params.getOrDefault(var0, var1);
    }

    public static class Builder {
        private final Map<ContextKey<?>, Object> params = new IdentityHashMap();

        public <T> Builder withParameter(ContextKey<T> var0, T var1) {
            this.params.put(var0, var1);
            return this;
        }

        public <T> Builder withOptionalParameter(ContextKey<T> var0, @Nullable T var1) {
            if (var1 == null) {
                this.params.remove(var0);
            } else {
                this.params.put(var0, var1);
            }
            return this;
        }

        public <T> T getParameter(ContextKey<T> var0) {
            Object var1 = this.params.get(var0);
            if (var1 == null) {
                throw new NoSuchElementException(var0.name().toString());
            }
            return (T)var1;
        }

        public <T> @Nullable T getOptionalParameter(ContextKey<T> var0) {
            return (T)this.params.get(var0);
        }

        public ContextMap create(ContextKeySet var0) {
            Sets.SetView var1 = Sets.difference(this.params.keySet(), var0.allowed());
            if (!var1.isEmpty()) {
                throw new IllegalArgumentException("Parameters not allowed in this parameter set: " + String.valueOf(var1));
            }
            Sets.SetView var2 = Sets.difference(var0.required(), this.params.keySet());
            if (!var2.isEmpty()) {
                throw new IllegalArgumentException("Missing required parameters: " + String.valueOf(var2));
            }
            return new ContextMap(this.params);
        }
    }
}

