/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.LegacyComponentDataFixUtils;
import net.minecraft.util.datafix.fixes.AbstractArrowPickupFix;
import net.minecraft.util.datafix.fixes.AddFieldFix;
import net.minecraft.util.datafix.fixes.AddFlagIfNotPresentFix;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.AdvancementsFix;
import net.minecraft.util.datafix.fixes.AdvancementsRenameFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudDurationScaleFix;
import net.minecraft.util.datafix.fixes.AreaEffectCloudPotionFix;
import net.minecraft.util.datafix.fixes.AttributeIdPrefixFix;
import net.minecraft.util.datafix.fixes.AttributeModifierIdFix;
import net.minecraft.util.datafix.fixes.AttributesRenameLegacy;
import net.minecraft.util.datafix.fixes.BannerEntityCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.BannerPatternFormatFix;
import net.minecraft.util.datafix.fixes.BedItemColorFix;
import net.minecraft.util.datafix.fixes.BeehiveFieldRenameFix;
import net.minecraft.util.datafix.fixes.BiomeFix;
import net.minecraft.util.datafix.fixes.BitStorageAlignFix;
import net.minecraft.util.datafix.fixes.BlendingDataFix;
import net.minecraft.util.datafix.fixes.BlendingDataRemoveFromNetherEndFix;
import net.minecraft.util.datafix.fixes.BlockEntityBannerColorFix;
import net.minecraft.util.datafix.fixes.BlockEntityBlockStateFix;
import net.minecraft.util.datafix.fixes.BlockEntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.BlockEntityFurnaceBurnTimeFix;
import net.minecraft.util.datafix.fixes.BlockEntityIdFix;
import net.minecraft.util.datafix.fixes.BlockEntityJukeboxFix;
import net.minecraft.util.datafix.fixes.BlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.BlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.BlockEntityShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.BlockEntitySignDoubleSidedEditableTextFix;
import net.minecraft.util.datafix.fixes.BlockEntityUUIDFix;
import net.minecraft.util.datafix.fixes.BlockNameFlatteningFix;
import net.minecraft.util.datafix.fixes.BlockPosFormatAndRenamesFix;
import net.minecraft.util.datafix.fixes.BlockPropertyRenameAndFix;
import net.minecraft.util.datafix.fixes.BlockRenameFix;
import net.minecraft.util.datafix.fixes.BlockStateStructureTemplateFix;
import net.minecraft.util.datafix.fixes.BoatSplitFix;
import net.minecraft.util.datafix.fixes.CarvingStepRemoveFix;
import net.minecraft.util.datafix.fixes.CatTypeFix;
import net.minecraft.util.datafix.fixes.CauldronRenameFix;
import net.minecraft.util.datafix.fixes.CavesAndCliffsRenames;
import net.minecraft.util.datafix.fixes.ChestedHorsesInventoryZeroIndexingFix;
import net.minecraft.util.datafix.fixes.ChunkBedBlockEntityInjecterFix;
import net.minecraft.util.datafix.fixes.ChunkBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteIgnoredLightDataFix;
import net.minecraft.util.datafix.fixes.ChunkDeleteLightFix;
import net.minecraft.util.datafix.fixes.ChunkHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.ChunkLightRemoveFix;
import net.minecraft.util.datafix.fixes.ChunkPalettedStorageFix;
import net.minecraft.util.datafix.fixes.ChunkProtoTickListFix;
import net.minecraft.util.datafix.fixes.ChunkRenamesFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix2;
import net.minecraft.util.datafix.fixes.ChunkStructuresTemplateRenameFix;
import net.minecraft.util.datafix.fixes.ChunkTicketUnpackPosFix;
import net.minecraft.util.datafix.fixes.ChunkToProtochunkFix;
import net.minecraft.util.datafix.fixes.ColorlessShulkerEntityFix;
import net.minecraft.util.datafix.fixes.ContainerBlockEntityLockPredicateFix;
import net.minecraft.util.datafix.fixes.CopperGolemWeatherStateFix;
import net.minecraft.util.datafix.fixes.CriteriaRenameFix;
import net.minecraft.util.datafix.fixes.CustomModelDataExpandFix;
import net.minecraft.util.datafix.fixes.DebugProfileOverlayReferenceFix;
import net.minecraft.util.datafix.fixes.DecoratedPotFieldRenameFix;
import net.minecraft.util.datafix.fixes.DropChancesFormatFix;
import net.minecraft.util.datafix.fixes.DropInvalidSignDataFix;
import net.minecraft.util.datafix.fixes.DyeItemRenameFix;
import net.minecraft.util.datafix.fixes.EffectDurationFix;
import net.minecraft.util.datafix.fixes.EmptyItemInHotbarFix;
import net.minecraft.util.datafix.fixes.EmptyItemInVillagerTradeFix;
import net.minecraft.util.datafix.fixes.EntityArmorStandSilentFix;
import net.minecraft.util.datafix.fixes.EntityAttributeBaseValueFix;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.EntityBrushableBlockFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityCatSplitFix;
import net.minecraft.util.datafix.fixes.EntityCodSalmonFix;
import net.minecraft.util.datafix.fixes.EntityCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.EntityElderGuardianSplitFix;
import net.minecraft.util.datafix.fixes.EntityEquipmentToArmorAndHandFix;
import net.minecraft.util.datafix.fixes.EntityFallDistanceFloatToDoubleFix;
import net.minecraft.util.datafix.fixes.EntityFieldsRenameFix;
import net.minecraft.util.datafix.fixes.EntityGoatMissingStateFix;
import net.minecraft.util.datafix.fixes.EntityHealthFix;
import net.minecraft.util.datafix.fixes.EntityHorseSaddleFix;
import net.minecraft.util.datafix.fixes.EntityHorseSplitFix;
import net.minecraft.util.datafix.fixes.EntityIdFix;
import net.minecraft.util.datafix.fixes.EntityItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityMinecartIdentifiersFix;
import net.minecraft.util.datafix.fixes.EntityPaintingItemFrameDirectionFix;
import net.minecraft.util.datafix.fixes.EntityPaintingMotiveFix;
import net.minecraft.util.datafix.fixes.EntityProjectileOwnerFix;
import net.minecraft.util.datafix.fixes.EntityPufferfishRenameFix;
import net.minecraft.util.datafix.fixes.EntityRavagerRenameFix;
import net.minecraft.util.datafix.fixes.EntityRedundantChanceTagsFix;
import net.minecraft.util.datafix.fixes.EntityRidingToPassengersFix;
import net.minecraft.util.datafix.fixes.EntitySalmonSizeFix;
import net.minecraft.util.datafix.fixes.EntityShulkerColorFix;
import net.minecraft.util.datafix.fixes.EntityShulkerRotationFix;
import net.minecraft.util.datafix.fixes.EntitySkeletonSplitFix;
import net.minecraft.util.datafix.fixes.EntitySpawnerItemVariantComponentFix;
import net.minecraft.util.datafix.fixes.EntityStringUuidFix;
import net.minecraft.util.datafix.fixes.EntityTheRenameningFix;
import net.minecraft.util.datafix.fixes.EntityTippedArrowFix;
import net.minecraft.util.datafix.fixes.EntityUUIDFix;
import net.minecraft.util.datafix.fixes.EntityVariantFix;
import net.minecraft.util.datafix.fixes.EntityWolfColorFix;
import net.minecraft.util.datafix.fixes.EntityZombieSplitFix;
import net.minecraft.util.datafix.fixes.EntityZombieVillagerTypeFix;
import net.minecraft.util.datafix.fixes.EntityZombifiedPiglinRenameFix;
import net.minecraft.util.datafix.fixes.EquipmentFormatFix;
import net.minecraft.util.datafix.fixes.EquippableAssetRenameFix;
import net.minecraft.util.datafix.fixes.FeatureFlagRemoveFix;
import net.minecraft.util.datafix.fixes.FilteredBooksFix;
import net.minecraft.util.datafix.fixes.FilteredSignsFix;
import net.minecraft.util.datafix.fixes.FireResistantToDamageResistantComponentFix;
import net.minecraft.util.datafix.fixes.FixProjectileStoredItem;
import net.minecraft.util.datafix.fixes.FixWolfHealth;
import net.minecraft.util.datafix.fixes.FoodToConsumableFix;
import net.minecraft.util.datafix.fixes.ForcePoiRebuild;
import net.minecraft.util.datafix.fixes.ForcedChunkToTicketFix;
import net.minecraft.util.datafix.fixes.FurnaceRecipeFix;
import net.minecraft.util.datafix.fixes.GameRuleRegistryFix;
import net.minecraft.util.datafix.fixes.GoatHornIdFix;
import net.minecraft.util.datafix.fixes.GossipUUIDFix;
import net.minecraft.util.datafix.fixes.HeightmapRenamingFix;
import net.minecraft.util.datafix.fixes.HorseBodyArmorItemFix;
import net.minecraft.util.datafix.fixes.IglooMetadataRemovalFix;
import net.minecraft.util.datafix.fixes.InlineBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.InvalidBlockEntityLockFix;
import net.minecraft.util.datafix.fixes.InvalidLockComponentFix;
import net.minecraft.util.datafix.fixes.ItemBannerColorFix;
import net.minecraft.util.datafix.fixes.ItemCustomNameToComponentFix;
import net.minecraft.util.datafix.fixes.ItemIdFix;
import net.minecraft.util.datafix.fixes.ItemLoreFix;
import net.minecraft.util.datafix.fixes.ItemPotionFix;
import net.minecraft.util.datafix.fixes.ItemRenameFix;
import net.minecraft.util.datafix.fixes.ItemShulkerBoxColorFix;
import net.minecraft.util.datafix.fixes.ItemSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackComponentizationFix;
import net.minecraft.util.datafix.fixes.ItemStackCustomNameToOverrideComponentFix;
import net.minecraft.util.datafix.fixes.ItemStackEnchantmentNamesFix;
import net.minecraft.util.datafix.fixes.ItemStackMapIdFix;
import net.minecraft.util.datafix.fixes.ItemStackSpawnEggFix;
import net.minecraft.util.datafix.fixes.ItemStackTheFlatteningFix;
import net.minecraft.util.datafix.fixes.ItemStackUUIDFix;
import net.minecraft.util.datafix.fixes.ItemWaterPotionFix;
import net.minecraft.util.datafix.fixes.JigsawPropertiesFix;
import net.minecraft.util.datafix.fixes.JigsawRotationFix;
import net.minecraft.util.datafix.fixes.JukeboxTicksSinceSongStartedFix;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.LegacyDimensionIdFix;
import net.minecraft.util.datafix.fixes.LegacyDragonFightFix;
import net.minecraft.util.datafix.fixes.LegacyHoverEventFix;
import net.minecraft.util.datafix.fixes.LegacyWorldBorderFix;
import net.minecraft.util.datafix.fixes.LevelDataGeneratorOptionsFix;
import net.minecraft.util.datafix.fixes.LevelFlatGeneratorInfoFix;
import net.minecraft.util.datafix.fixes.LevelLegacyWorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.LevelUUIDFix;
import net.minecraft.util.datafix.fixes.LockComponentPredicateFix;
import net.minecraft.util.datafix.fixes.LodestoneCompassComponentFix;
import net.minecraft.util.datafix.fixes.MapBannerBlockPosFormatFix;
import net.minecraft.util.datafix.fixes.MapIdFix;
import net.minecraft.util.datafix.fixes.MemoryExpiryDataFix;
import net.minecraft.util.datafix.fixes.MissingDimensionFix;
import net.minecraft.util.datafix.fixes.MobEffectIdFix;
import net.minecraft.util.datafix.fixes.MobSpawnerEntityIdentifiersFix;
import net.minecraft.util.datafix.fixes.NamedEntityConvertUncheckedFix;
import net.minecraft.util.datafix.fixes.NamedEntityWriteReadFix;
import net.minecraft.util.datafix.fixes.NamespacedTypeRenameFix;
import net.minecraft.util.datafix.fixes.NewVillageFix;
import net.minecraft.util.datafix.fixes.ObjectiveRenderTypeFix;
import net.minecraft.util.datafix.fixes.OminousBannerBlockEntityRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerRarityFix;
import net.minecraft.util.datafix.fixes.OminousBannerRenameFix;
import net.minecraft.util.datafix.fixes.OptionsAccessibilityOnboardFix;
import net.minecraft.util.datafix.fixes.OptionsAddTextBackgroundFix;
import net.minecraft.util.datafix.fixes.OptionsAmbientOcclusionFix;
import net.minecraft.util.datafix.fixes.OptionsFancyGraphicsToGraphicsModeFix;
import net.minecraft.util.datafix.fixes.OptionsForceVBOFix;
import net.minecraft.util.datafix.fixes.OptionsGraphicsModeSplitFix;
import net.minecraft.util.datafix.fixes.OptionsKeyLwjgl3Fix;
import net.minecraft.util.datafix.fixes.OptionsKeyTranslationFix;
import net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguageFix;
import net.minecraft.util.datafix.fixes.OptionsMenuBlurrinessFix;
import net.minecraft.util.datafix.fixes.OptionsMusicToastFix;
import net.minecraft.util.datafix.fixes.OptionsProgrammerArtFix;
import net.minecraft.util.datafix.fixes.OptionsRenameFieldFix;
import net.minecraft.util.datafix.fixes.OptionsSetGraphicsPresetToCustomFix;
import net.minecraft.util.datafix.fixes.OverreachingTickFix;
import net.minecraft.util.datafix.fixes.ParticleUnflatteningFix;
import net.minecraft.util.datafix.fixes.PlayerEquipmentFix;
import net.minecraft.util.datafix.fixes.PlayerHeadBlockProfileFix;
import net.minecraft.util.datafix.fixes.PlayerRespawnDataFix;
import net.minecraft.util.datafix.fixes.PlayerUUIDFix;
import net.minecraft.util.datafix.fixes.PoiTypeRemoveFix;
import net.minecraft.util.datafix.fixes.PoiTypeRenameFix;
import net.minecraft.util.datafix.fixes.PrimedTntBlockStateFixer;
import net.minecraft.util.datafix.fixes.ProjectileStoredWeaponFix;
import net.minecraft.util.datafix.fixes.RaidRenamesDataFix;
import net.minecraft.util.datafix.fixes.RandomSequenceSettingsFix;
import net.minecraft.util.datafix.fixes.RecipesFix;
import net.minecraft.util.datafix.fixes.RecipesRenameningFix;
import net.minecraft.util.datafix.fixes.RedstoneWireConnectionsFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.fixes.RemapChunkStatusFix;
import net.minecraft.util.datafix.fixes.RemoveBlockEntityTagFix;
import net.minecraft.util.datafix.fixes.RemoveEmptyItemInBrushableBlockFix;
import net.minecraft.util.datafix.fixes.RemoveGolemGossipFix;
import net.minecraft.util.datafix.fixes.RenameEnchantmentsFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFansFix;
import net.minecraft.util.datafix.fixes.RenamedCoralFix;
import net.minecraft.util.datafix.fixes.ReorganizePoi;
import net.minecraft.util.datafix.fixes.SaddleEquipmentSlotFix;
import net.minecraft.util.datafix.fixes.SavedDataFeaturePoolElementFix;
import net.minecraft.util.datafix.fixes.SavedDataUUIDFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplayNameFix;
import net.minecraft.util.datafix.fixes.ScoreboardDisplaySlotFix;
import net.minecraft.util.datafix.fixes.SignTextStrictJsonFix;
import net.minecraft.util.datafix.fixes.SpawnerDataFix;
import net.minecraft.util.datafix.fixes.StatsCounterFix;
import net.minecraft.util.datafix.fixes.StatsRenameFix;
import net.minecraft.util.datafix.fixes.StriderGravityFix;
import net.minecraft.util.datafix.fixes.StructureReferenceCountFix;
import net.minecraft.util.datafix.fixes.StructureSettingsFlattenFix;
import net.minecraft.util.datafix.fixes.StructuresBecomeConfiguredFix;
import net.minecraft.util.datafix.fixes.TextComponentHoverAndClickEventFix;
import net.minecraft.util.datafix.fixes.TextComponentStringifiedFlagsFix;
import net.minecraft.util.datafix.fixes.ThrownPotionSplitFix;
import net.minecraft.util.datafix.fixes.TippedArrowPotionToItemFix;
import net.minecraft.util.datafix.fixes.TooltipDisplayComponentFix;
import net.minecraft.util.datafix.fixes.TrappedChestBlockEntityFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigFix;
import net.minecraft.util.datafix.fixes.TrialSpawnerConfigInRegistryFix;
import net.minecraft.util.datafix.fixes.TridentAnimationFix;
import net.minecraft.util.datafix.fixes.UnflattenTextComponentFix;
import net.minecraft.util.datafix.fixes.VariantRenameFix;
import net.minecraft.util.datafix.fixes.VillagerDataFix;
import net.minecraft.util.datafix.fixes.VillagerFollowRangeFix;
import net.minecraft.util.datafix.fixes.VillagerRebuildLevelAndXpFix;
import net.minecraft.util.datafix.fixes.VillagerSetCanPickUpLootFix;
import net.minecraft.util.datafix.fixes.VillagerTradeFix;
import net.minecraft.util.datafix.fixes.WallPropertyFix;
import net.minecraft.util.datafix.fixes.WeaponSmithChestLootTableFix;
import net.minecraft.util.datafix.fixes.WorldBorderWarningTimeFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsDisallowOldCustomWorldsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsFix;
import net.minecraft.util.datafix.fixes.WorldGenSettingsHeightAndBiomeFix;
import net.minecraft.util.datafix.fixes.WorldSpawnDataFix;
import net.minecraft.util.datafix.fixes.WriteAndReadFix;
import net.minecraft.util.datafix.fixes.WrittenBookPagesStrictJsonFix;
import net.minecraft.util.datafix.fixes.ZombieVillagerRebuildXpFix;
import net.minecraft.util.datafix.schemas.NamespacedSchema;
import net.minecraft.util.datafix.schemas.V100;
import net.minecraft.util.datafix.schemas.V102;
import net.minecraft.util.datafix.schemas.V1022;
import net.minecraft.util.datafix.schemas.V106;
import net.minecraft.util.datafix.schemas.V107;
import net.minecraft.util.datafix.schemas.V1125;
import net.minecraft.util.datafix.schemas.V135;
import net.minecraft.util.datafix.schemas.V143;
import net.minecraft.util.datafix.schemas.V1451;
import net.minecraft.util.datafix.schemas.V1451_1;
import net.minecraft.util.datafix.schemas.V1451_2;
import net.minecraft.util.datafix.schemas.V1451_3;
import net.minecraft.util.datafix.schemas.V1451_4;
import net.minecraft.util.datafix.schemas.V1451_5;
import net.minecraft.util.datafix.schemas.V1451_6;
import net.minecraft.util.datafix.schemas.V1458;
import net.minecraft.util.datafix.schemas.V1460;
import net.minecraft.util.datafix.schemas.V1466;
import net.minecraft.util.datafix.schemas.V1470;
import net.minecraft.util.datafix.schemas.V1481;
import net.minecraft.util.datafix.schemas.V1483;
import net.minecraft.util.datafix.schemas.V1486;
import net.minecraft.util.datafix.schemas.V1488;
import net.minecraft.util.datafix.schemas.V1510;
import net.minecraft.util.datafix.schemas.V1800;
import net.minecraft.util.datafix.schemas.V1801;
import net.minecraft.util.datafix.schemas.V1904;
import net.minecraft.util.datafix.schemas.V1906;
import net.minecraft.util.datafix.schemas.V1909;
import net.minecraft.util.datafix.schemas.V1920;
import net.minecraft.util.datafix.schemas.V1928;
import net.minecraft.util.datafix.schemas.V1929;
import net.minecraft.util.datafix.schemas.V1931;
import net.minecraft.util.datafix.schemas.V2100;
import net.minecraft.util.datafix.schemas.V2501;
import net.minecraft.util.datafix.schemas.V2502;
import net.minecraft.util.datafix.schemas.V2505;
import net.minecraft.util.datafix.schemas.V2509;
import net.minecraft.util.datafix.schemas.V2511_1;
import net.minecraft.util.datafix.schemas.V2519;
import net.minecraft.util.datafix.schemas.V2522;
import net.minecraft.util.datafix.schemas.V2551;
import net.minecraft.util.datafix.schemas.V2568;
import net.minecraft.util.datafix.schemas.V2571;
import net.minecraft.util.datafix.schemas.V2684;
import net.minecraft.util.datafix.schemas.V2686;
import net.minecraft.util.datafix.schemas.V2688;
import net.minecraft.util.datafix.schemas.V2704;
import net.minecraft.util.datafix.schemas.V2707;
import net.minecraft.util.datafix.schemas.V2831;
import net.minecraft.util.datafix.schemas.V2832;
import net.minecraft.util.datafix.schemas.V2842;
import net.minecraft.util.datafix.schemas.V3076;
import net.minecraft.util.datafix.schemas.V3078;
import net.minecraft.util.datafix.schemas.V3081;
import net.minecraft.util.datafix.schemas.V3082;
import net.minecraft.util.datafix.schemas.V3083;
import net.minecraft.util.datafix.schemas.V3202;
import net.minecraft.util.datafix.schemas.V3203;
import net.minecraft.util.datafix.schemas.V3204;
import net.minecraft.util.datafix.schemas.V3325;
import net.minecraft.util.datafix.schemas.V3326;
import net.minecraft.util.datafix.schemas.V3327;
import net.minecraft.util.datafix.schemas.V3328;
import net.minecraft.util.datafix.schemas.V3438;
import net.minecraft.util.datafix.schemas.V3439;
import net.minecraft.util.datafix.schemas.V3439_1;
import net.minecraft.util.datafix.schemas.V3448;
import net.minecraft.util.datafix.schemas.V3682;
import net.minecraft.util.datafix.schemas.V3683;
import net.minecraft.util.datafix.schemas.V3685;
import net.minecraft.util.datafix.schemas.V3689;
import net.minecraft.util.datafix.schemas.V3799;
import net.minecraft.util.datafix.schemas.V3807;
import net.minecraft.util.datafix.schemas.V3808;
import net.minecraft.util.datafix.schemas.V3808_1;
import net.minecraft.util.datafix.schemas.V3808_2;
import net.minecraft.util.datafix.schemas.V3813;
import net.minecraft.util.datafix.schemas.V3816;
import net.minecraft.util.datafix.schemas.V3818;
import net.minecraft.util.datafix.schemas.V3818_3;
import net.minecraft.util.datafix.schemas.V3818_4;
import net.minecraft.util.datafix.schemas.V3818_5;
import net.minecraft.util.datafix.schemas.V3825;
import net.minecraft.util.datafix.schemas.V3938;
import net.minecraft.util.datafix.schemas.V4059;
import net.minecraft.util.datafix.schemas.V4067;
import net.minecraft.util.datafix.schemas.V4070;
import net.minecraft.util.datafix.schemas.V4071;
import net.minecraft.util.datafix.schemas.V4290;
import net.minecraft.util.datafix.schemas.V4292;
import net.minecraft.util.datafix.schemas.V4300;
import net.minecraft.util.datafix.schemas.V4301;
import net.minecraft.util.datafix.schemas.V4302;
import net.minecraft.util.datafix.schemas.V4306;
import net.minecraft.util.datafix.schemas.V4307;
import net.minecraft.util.datafix.schemas.V4312;
import net.minecraft.util.datafix.schemas.V4420;
import net.minecraft.util.datafix.schemas.V4421;
import net.minecraft.util.datafix.schemas.V4531;
import net.minecraft.util.datafix.schemas.V4532;
import net.minecraft.util.datafix.schemas.V4533;
import net.minecraft.util.datafix.schemas.V4543;
import net.minecraft.util.datafix.schemas.V4648;
import net.minecraft.util.datafix.schemas.V4656;
import net.minecraft.util.datafix.schemas.V501;
import net.minecraft.util.datafix.schemas.V700;
import net.minecraft.util.datafix.schemas.V701;
import net.minecraft.util.datafix.schemas.V702;
import net.minecraft.util.datafix.schemas.V703;
import net.minecraft.util.datafix.schemas.V704;
import net.minecraft.util.datafix.schemas.V705;
import net.minecraft.util.datafix.schemas.V808;
import net.minecraft.util.datafix.schemas.V99;

public class DataFixers {
    private static final BiFunction<Integer, Schema, Schema> SAME = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> SAME_NAMESPACED = NamespacedSchema::new;
    private static final DataFixerBuilder.Result DATA_FIXER = DataFixers.createFixerUpper();
    public static final int BLENDING_VERSION = 4295;

    private DataFixers() {
    }

    public static DataFixer getDataFixer() {
        return DATA_FIXER.fixer();
    }

    private static DataFixerBuilder.Result createFixerUpper() {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.getCurrentVersion().dataVersion().version());
        DataFixers.addFixers(datafixerbuilder);
        return datafixerbuilder.build();
    }

    public static CompletableFuture<?> optimize(Set<DSL.TypeReference> set) {
        if (set.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("Datafixer Bootstrap").setDaemon(true).setPriority(1).build());
        return DATA_FIXER.optimize(set, (Executor)executor);
    }

    /*
     * WARNING - void declaration
     */
    private static void addFixers(DataFixerBuilder datafixerbuilder) {
        void schema286;
        void schema285;
        void schema284;
        void schema283;
        void schema282;
        void schema281;
        void schema280;
        void schema279;
        void schema278;
        void schema277;
        void schema276;
        void schema275;
        void schema274;
        void schema273;
        void schema272;
        void schema271;
        void schema270;
        void schema269;
        void schema268;
        void schema267;
        void schema266;
        void schema265;
        void schema264;
        void schema263;
        void schema262;
        void schema261;
        void schema260;
        void schema259;
        void schema258;
        void schema257;
        void schema256;
        void schema255;
        void schema254;
        void schema253;
        void schema252;
        void schema251;
        void schema250;
        void schema249;
        void schema248;
        void schema247;
        void schema246;
        void schema245;
        void schema244;
        datafixerbuilder.addSchema(99, V99::new);
        Schema schema = datafixerbuilder.addSchema(100, V100::new);
        datafixerbuilder.addFixer((DataFix)new EntityEquipmentToArmorAndHandFix(schema));
        Schema schema1 = datafixerbuilder.addSchema(101, SAME);
        datafixerbuilder.addFixer((DataFix)new VillagerSetCanPickUpLootFix(schema1));
        Schema schema2 = datafixerbuilder.addSchema(102, V102::new);
        datafixerbuilder.addFixer((DataFix)new ItemIdFix(schema2, true));
        datafixerbuilder.addFixer((DataFix)new ItemPotionFix(schema2, false));
        Schema schema3 = datafixerbuilder.addSchema(105, SAME);
        datafixerbuilder.addFixer((DataFix)new ItemSpawnEggFix(schema3, true));
        Schema schema4 = datafixerbuilder.addSchema(106, V106::new);
        datafixerbuilder.addFixer((DataFix)new MobSpawnerEntityIdentifiersFix(schema4, true));
        Schema schema5 = datafixerbuilder.addSchema(107, V107::new);
        datafixerbuilder.addFixer((DataFix)new EntityMinecartIdentifiersFix(schema5));
        Schema schema6 = datafixerbuilder.addSchema(108, SAME);
        datafixerbuilder.addFixer((DataFix)new EntityStringUuidFix(schema6, true));
        Schema schema7 = datafixerbuilder.addSchema(109, SAME);
        datafixerbuilder.addFixer((DataFix)new EntityHealthFix(schema7, true));
        Schema schema8 = datafixerbuilder.addSchema(110, SAME);
        datafixerbuilder.addFixer((DataFix)new EntityHorseSaddleFix(schema8, true));
        Schema schema9 = datafixerbuilder.addSchema(111, SAME);
        datafixerbuilder.addFixer((DataFix)new EntityPaintingItemFrameDirectionFix(schema9, true));
        Schema schema10 = datafixerbuilder.addSchema(113, SAME);
        datafixerbuilder.addFixer((DataFix)new EntityRedundantChanceTagsFix(schema10, true));
        Schema schema11 = datafixerbuilder.addSchema(135, V135::new);
        datafixerbuilder.addFixer((DataFix)new EntityRidingToPassengersFix(schema11, true));
        Schema schema12 = datafixerbuilder.addSchema(143, V143::new);
        datafixerbuilder.addFixer((DataFix)new EntityTippedArrowFix(schema12, true));
        Schema schema13 = datafixerbuilder.addSchema(147, SAME);
        datafixerbuilder.addFixer((DataFix)new EntityArmorStandSilentFix(schema13, true));
        Schema schema14 = datafixerbuilder.addSchema(165, SAME);
        datafixerbuilder.addFixer((DataFix)new SignTextStrictJsonFix(schema14));
        datafixerbuilder.addFixer((DataFix)new WrittenBookPagesStrictJsonFix(schema14));
        Schema schema15 = datafixerbuilder.addSchema(501, V501::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema15, "Add 1.10 entities fix", References.ENTITY));
        Schema schema16 = datafixerbuilder.addSchema(502, SAME);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema16, "cooked_fished item renamer", s -> Objects.equals(NamespacedSchema.ensureNamespaced(s), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : s));
        datafixerbuilder.addFixer((DataFix)new EntityZombieVillagerTypeFix(schema16, false));
        Schema schema17 = datafixerbuilder.addSchema(505, SAME);
        datafixerbuilder.addFixer((DataFix)new OptionsForceVBOFix(schema17, false));
        Schema schema18 = datafixerbuilder.addSchema(700, V700::new);
        datafixerbuilder.addFixer((DataFix)new EntityElderGuardianSplitFix(schema18, true));
        Schema schema19 = datafixerbuilder.addSchema(701, V701::new);
        datafixerbuilder.addFixer((DataFix)new EntitySkeletonSplitFix(schema19, true));
        Schema schema20 = datafixerbuilder.addSchema(702, V702::new);
        datafixerbuilder.addFixer((DataFix)new EntityZombieSplitFix(schema20));
        Schema schema21 = datafixerbuilder.addSchema(703, V703::new);
        datafixerbuilder.addFixer((DataFix)new EntityHorseSplitFix(schema21, true));
        Schema schema22 = datafixerbuilder.addSchema(704, V704::new);
        datafixerbuilder.addFixer((DataFix)new BlockEntityIdFix(schema22, true));
        Schema schema23 = datafixerbuilder.addSchema(705, V705::new);
        datafixerbuilder.addFixer((DataFix)new EntityIdFix(schema23, true));
        Schema schema24 = datafixerbuilder.addSchema(804, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ItemBannerColorFix(schema24, true));
        Schema schema25 = datafixerbuilder.addSchema(806, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ItemWaterPotionFix(schema25, false));
        Schema schema26 = datafixerbuilder.addSchema(808, V808::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema26, "added shulker box", References.BLOCK_ENTITY));
        Schema schema27 = datafixerbuilder.addSchema(808, 1, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityShulkerColorFix(schema27, false));
        Schema schema28 = datafixerbuilder.addSchema(813, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ItemShulkerBoxColorFix(schema28, false));
        datafixerbuilder.addFixer((DataFix)new BlockEntityShulkerBoxColorFix(schema28, false));
        Schema schema29 = datafixerbuilder.addSchema(816, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsLowerCaseLanguageFix(schema29, false));
        Schema schema30 = datafixerbuilder.addSchema(820, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema30, "totem item renamer", DataFixers.createRenamer("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema31 = datafixerbuilder.addSchema(1022, V1022::new);
        datafixerbuilder.addFixer((DataFix)new WriteAndReadFix(schema31, "added shoulder entities to players", References.PLAYER));
        Schema schema32 = datafixerbuilder.addSchema(1125, V1125::new);
        datafixerbuilder.addFixer((DataFix)new ChunkBedBlockEntityInjecterFix(schema32, true));
        datafixerbuilder.addFixer((DataFix)new BedItemColorFix(schema32, false));
        Schema schema33 = datafixerbuilder.addSchema(1344, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsKeyLwjgl3Fix(schema33, false));
        Schema schema34 = datafixerbuilder.addSchema(1446, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsKeyTranslationFix(schema34, false));
        Schema schema35 = datafixerbuilder.addSchema(1450, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlockStateStructureTemplateFix(schema35, false));
        Schema schema36 = datafixerbuilder.addSchema(1451, V1451::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema36, "AddTrappedChestFix", References.BLOCK_ENTITY));
        Schema schema37 = datafixerbuilder.addSchema(1451, 1, V1451_1::new);
        datafixerbuilder.addFixer((DataFix)new ChunkPalettedStorageFix(schema37, true));
        Schema schema38 = datafixerbuilder.addSchema(1451, 2, V1451_2::new);
        datafixerbuilder.addFixer((DataFix)new BlockEntityBlockStateFix(schema38, true));
        Schema schema39 = datafixerbuilder.addSchema(1451, 3, V1451_3::new);
        datafixerbuilder.addFixer((DataFix)new EntityBlockStateFix(schema39, true));
        datafixerbuilder.addFixer((DataFix)new ItemStackMapIdFix(schema39, false));
        Schema schema40 = datafixerbuilder.addSchema(1451, 4, V1451_4::new);
        datafixerbuilder.addFixer((DataFix)new BlockNameFlatteningFix(schema40, true));
        datafixerbuilder.addFixer((DataFix)new ItemStackTheFlatteningFix(schema40, false));
        Schema schema41 = datafixerbuilder.addSchema(1451, 5, V1451_5::new);
        datafixerbuilder.addFixer((DataFix)new RemoveBlockEntityTagFix(schema41, Set.of("minecraft:noteblock", "minecraft:flower_pot")));
        datafixerbuilder.addFixer((DataFix)new ItemStackSpawnEggFix(schema41, false, "minecraft:spawn_egg"));
        datafixerbuilder.addFixer((DataFix)new EntityWolfColorFix(schema41, false));
        datafixerbuilder.addFixer((DataFix)new BlockEntityBannerColorFix(schema41, false));
        datafixerbuilder.addFixer((DataFix)new LevelFlatGeneratorInfoFix(schema41, false));
        Schema schema42 = datafixerbuilder.addSchema(1451, 6, V1451_6::new);
        datafixerbuilder.addFixer((DataFix)new StatsCounterFix(schema42, true));
        datafixerbuilder.addFixer((DataFix)new BlockEntityJukeboxFix(schema42, false));
        Schema schema43 = datafixerbuilder.addSchema(1451, 7, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new VillagerTradeFix(schema43));
        Schema schema44 = datafixerbuilder.addSchema(1456, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityItemFrameDirectionFix(schema44, false));
        Schema schema45 = datafixerbuilder.addSchema(1458, V1458::new);
        datafixerbuilder.addFixer(new DataFix(schema45, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(References.PLAYER), typed -> typed.update(DSL.remainderFinder(), dynamic -> {
                    String s = dynamic.get("CustomName").asString("");
                    return s.isEmpty() ? dynamic.remove("CustomName") : dynamic.set("CustomName", LegacyComponentDataFixUtils.createPlainTextComponent(dynamic.getOps(), s));
                }));
            }
        });
        datafixerbuilder.addFixer((DataFix)new EntityCustomNameToComponentFix(schema45));
        datafixerbuilder.addFixer((DataFix)new ItemCustomNameToComponentFix(schema45));
        datafixerbuilder.addFixer((DataFix)new BlockEntityCustomNameToComponentFix(schema45));
        Schema schema46 = datafixerbuilder.addSchema(1460, V1460::new);
        datafixerbuilder.addFixer((DataFix)new EntityPaintingMotiveFix(schema46, false));
        Schema schema47 = datafixerbuilder.addSchema(1466, V1466::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema47, "Add DUMMY block entity", References.BLOCK_ENTITY));
        datafixerbuilder.addFixer((DataFix)new ChunkToProtochunkFix(schema47, true));
        Schema schema48 = datafixerbuilder.addSchema(1470, V1470::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema48, "Add 1.13 entities fix", References.ENTITY));
        Schema schema49 = datafixerbuilder.addSchema(1474, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ColorlessShulkerEntityFix(schema49, false));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema49, "Colorless shulker block fixer", s -> Objects.equals(NamespacedSchema.ensureNamespaced(s), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema49, "Colorless shulker item fixer", s -> Objects.equals(NamespacedSchema.ensureNamespaced(s), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : s));
        Schema schema50 = datafixerbuilder.addSchema(1475, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema50, "Flowing fixer", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema51 = datafixerbuilder.addSchema(1480, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema51, "Rename coral blocks", DataFixers.createRenamer(RenamedCoralFix.RENAMED_IDS)));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema51, "Rename coral items", DataFixers.createRenamer(RenamedCoralFix.RENAMED_IDS)));
        Schema schema52 = datafixerbuilder.addSchema(1481, V1481::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema52, "Add conduit", References.BLOCK_ENTITY));
        Schema schema53 = datafixerbuilder.addSchema(1483, V1483::new);
        datafixerbuilder.addFixer((DataFix)new EntityPufferfishRenameFix(schema53, true));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema53, "Rename pufferfish egg item", DataFixers.createRenamer(EntityPufferfishRenameFix.RENAMED_IDS)));
        Schema schema54 = datafixerbuilder.addSchema(1484, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema54, "Rename seagrass items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema54, "Rename seagrass blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        datafixerbuilder.addFixer((DataFix)new HeightmapRenamingFix(schema54, false));
        Schema schema55 = datafixerbuilder.addSchema(1486, V1486::new);
        datafixerbuilder.addFixer((DataFix)new EntityCodSalmonFix(schema55, true));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema55, "Rename cod/salmon egg items", DataFixers.createRenamer(EntityCodSalmonFix.RENAMED_EGG_IDS)));
        Schema schema56 = datafixerbuilder.addSchema(1487, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema56, "Rename prismarine_brick(s)_* blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema56, "Rename prismarine_brick(s)_* items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema57 = datafixerbuilder.addSchema(1488, V1488::new);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema57, "Rename kelp/kelptop", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema57, "Rename kelptop", DataFixers.createRenamer("minecraft:kelp_top", "minecraft:kelp")));
        datafixerbuilder.addFixer((DataFix)new NamedEntityWriteReadFix(schema57, true, "Command block block entity custom name fix", References.BLOCK_ENTITY, "minecraft:command_block"){

            @Override
            protected <T> Dynamic<T> fix(Dynamic<T> dynamic) {
                return BlockEntityCustomNameToComponentFix.fixTagCustomName(dynamic);
            }
        });
        datafixerbuilder.addFixer(new DataFix(schema57, false){

            protected TypeRewriteRule makeRule() {
                Type type = this.getInputSchema().getType(References.ENTITY);
                OpticFinder opticfinder = DSL.fieldFinder((String)"id", NamespacedSchema.namespacedString());
                OpticFinder opticfinder1 = type.findField("CustomName");
                OpticFinder opticfinder2 = DSL.typeFinder((Type)this.getInputSchema().getType(References.TEXT_COMPONENT));
                return this.fixTypeEverywhereTyped("Command block minecart custom name fix", type, typed -> {
                    String s = typed.getOptional(opticfinder).orElse("");
                    return !"minecraft:commandblock_minecart".equals(s) ? typed : typed.updateTyped(opticfinder1, typed1 -> typed1.update(opticfinder2, pair -> pair.mapSecond(LegacyComponentDataFixUtils::createTextComponentJson)));
                });
            }
        });
        datafixerbuilder.addFixer((DataFix)new IglooMetadataRemovalFix(schema57, false));
        Schema schema58 = datafixerbuilder.addSchema(1490, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema58, "Rename melon_block", DataFixers.createRenamer("minecraft:melon_block", "minecraft:melon")));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema58, "Rename melon_block/melon/speckled_melon", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema59 = datafixerbuilder.addSchema(1492, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkStructuresTemplateRenameFix(schema59, false));
        Schema schema60 = datafixerbuilder.addSchema(1494, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ItemStackEnchantmentNamesFix(schema60, false));
        Schema schema61 = datafixerbuilder.addSchema(1496, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LeavesFix(schema61, false));
        Schema schema62 = datafixerbuilder.addSchema(1500, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlockEntityKeepPacked(schema62, false));
        Schema schema63 = datafixerbuilder.addSchema(1501, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AdvancementsFix(schema63, false));
        Schema schema64 = datafixerbuilder.addSchema(1502, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema64, "Recipes fix", References.RECIPE, DataFixers.createRenamer(RecipesFix.RECIPES)));
        Schema schema65 = datafixerbuilder.addSchema(1506, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LevelDataGeneratorOptionsFix(schema65, false));
        Schema schema66 = datafixerbuilder.addSchema(1510, V1510::new);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema66, "Block renamening fix", DataFixers.createRenamer(EntityTheRenameningFix.RENAMED_BLOCKS)));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema66, "Item renamening fix", DataFixers.createRenamer(EntityTheRenameningFix.RENAMED_ITEMS)));
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema66, "Recipes renamening fix", References.RECIPE, DataFixers.createRenamer(RecipesRenameningFix.RECIPES)));
        datafixerbuilder.addFixer((DataFix)new EntityTheRenameningFix(schema66, true));
        datafixerbuilder.addFixer((DataFix)new StatsRenameFix(schema66, "SwimStatsRenameFix", (Map<String, String>)ImmutableMap.of((Object)"minecraft:swim_one_cm", (Object)"minecraft:walk_on_water_one_cm", (Object)"minecraft:dive_one_cm", (Object)"minecraft:walk_under_water_one_cm")));
        Schema schema67 = datafixerbuilder.addSchema(1514, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ScoreboardDisplayNameFix(schema67, "ObjectiveDisplayNameFix", References.OBJECTIVE));
        datafixerbuilder.addFixer((DataFix)new ScoreboardDisplayNameFix(schema67, "TeamDisplayNameFix", References.TEAM));
        datafixerbuilder.addFixer((DataFix)new ObjectiveRenderTypeFix(schema67));
        Schema schema68 = datafixerbuilder.addSchema(1515, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema68, "Rename coral fan blocks", DataFixers.createRenamer(RenamedCoralFansFix.RENAMED_IDS)));
        Schema schema69 = datafixerbuilder.addSchema(1624, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new TrappedChestBlockEntityFix(schema69, false));
        Schema schema70 = datafixerbuilder.addSchema(1800, V1800::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema70, "Added 1.14 mobs fix", References.ENTITY));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema70, "Rename dye items", DataFixers.createRenamer(DyeItemRenameFix.RENAMED_IDS)));
        Schema schema71 = datafixerbuilder.addSchema(1801, V1801::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema71, "Added Illager Beast", References.ENTITY));
        Schema schema72 = datafixerbuilder.addSchema(1802, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema72, "Rename sign blocks & stone slabs", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema72, "Rename sign item & stone slabs", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema73 = datafixerbuilder.addSchema(1803, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ItemLoreFix(schema73));
        Schema schema74 = datafixerbuilder.addSchema(1904, V1904::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema74, "Added Cats", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new EntityCatSplitFix(schema74, false));
        Schema schema75 = datafixerbuilder.addSchema(1905, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkStatusFix(schema75, false));
        Schema schema76 = datafixerbuilder.addSchema(1906, V1906::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema76, "Add POI Blocks", References.BLOCK_ENTITY));
        Schema schema77 = datafixerbuilder.addSchema(1909, V1909::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema77, "Add jigsaw", References.BLOCK_ENTITY));
        Schema schema78 = datafixerbuilder.addSchema(1911, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkStatusFix2(schema78, false));
        Schema schema79 = datafixerbuilder.addSchema(1914, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WeaponSmithChestLootTableFix(schema79, false));
        Schema schema80 = datafixerbuilder.addSchema(1917, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new CatTypeFix(schema80, false));
        Schema schema81 = datafixerbuilder.addSchema(1918, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new VillagerDataFix(schema81, "minecraft:villager"));
        datafixerbuilder.addFixer((DataFix)new VillagerDataFix(schema81, "minecraft:zombie_villager"));
        Schema schema82 = datafixerbuilder.addSchema(1920, V1920::new);
        datafixerbuilder.addFixer((DataFix)new NewVillageFix(schema82, false));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema82, "Add campfire", References.BLOCK_ENTITY));
        Schema schema83 = datafixerbuilder.addSchema(1925, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new MapIdFix(schema83));
        Schema schema84 = datafixerbuilder.addSchema(1928, V1928::new);
        datafixerbuilder.addFixer((DataFix)new EntityRavagerRenameFix(schema84, true));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema84, "Rename ravager egg item", DataFixers.createRenamer(EntityRavagerRenameFix.RENAMED_IDS)));
        Schema schema85 = datafixerbuilder.addSchema(1929, V1929::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema85, "Add Wandering Trader and Trader Llama", References.ENTITY));
        Schema schema86 = datafixerbuilder.addSchema(1931, V1931::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema86, "Added Fox", References.ENTITY));
        Schema schema87 = datafixerbuilder.addSchema(1936, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsAddTextBackgroundFix(schema87, false));
        Schema schema88 = datafixerbuilder.addSchema(1946, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ReorganizePoi(schema88, false));
        Schema schema89 = datafixerbuilder.addSchema(1948, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OminousBannerRenameFix(schema89));
        Schema schema90 = datafixerbuilder.addSchema(1953, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OminousBannerBlockEntityRenameFix(schema90, false));
        Schema schema91 = datafixerbuilder.addSchema(1955, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new VillagerRebuildLevelAndXpFix(schema91, false));
        datafixerbuilder.addFixer((DataFix)new ZombieVillagerRebuildXpFix(schema91, false));
        Schema schema92 = datafixerbuilder.addSchema(1961, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkLightRemoveFix(schema92, false));
        Schema schema93 = datafixerbuilder.addSchema(1963, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RemoveGolemGossipFix(schema93, false));
        Schema schema94 = datafixerbuilder.addSchema(2100, V2100::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema94, "Added Bee and Bee Stinger", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema94, "Add beehive", References.BLOCK_ENTITY));
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema94, "Rename sugar recipe", References.RECIPE, DataFixers.createRenamer("minecraft:sugar", "minecraft:sugar_from_sugar_cane")));
        datafixerbuilder.addFixer((DataFix)new AdvancementsRenameFix(schema94, false, "Rename sugar recipe advancement", DataFixers.createRenamer("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema95 = datafixerbuilder.addSchema(2202, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkBiomeFix(schema95, false));
        Schema schema96 = datafixerbuilder.addSchema(2209, SAME_NAMESPACED);
        UnaryOperator<String> unaryoperator = DataFixers.createRenamer("minecraft:bee_hive", "minecraft:beehive");
        datafixerbuilder.addFixer(ItemRenameFix.create(schema96, "Rename bee_hive item to beehive", unaryoperator));
        datafixerbuilder.addFixer((DataFix)new PoiTypeRenameFix(schema96, "Rename bee_hive poi to beehive", unaryoperator));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema96, "Rename bee_hive block to beehive", unaryoperator));
        Schema schema97 = datafixerbuilder.addSchema(2211, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new StructureReferenceCountFix(schema97, false));
        Schema schema98 = datafixerbuilder.addSchema(2218, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ForcePoiRebuild(schema98, false));
        Schema schema99 = datafixerbuilder.addSchema(2501, V2501::new);
        datafixerbuilder.addFixer((DataFix)new FurnaceRecipeFix(schema99, true));
        Schema schema100 = datafixerbuilder.addSchema(2502, V2502::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema100, "Added Hoglin", References.ENTITY));
        Schema schema101 = datafixerbuilder.addSchema(2503, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WallPropertyFix(schema101, false));
        datafixerbuilder.addFixer((DataFix)new AdvancementsRenameFix(schema101, false, "Composter category change", DataFixers.createRenamer("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema102 = datafixerbuilder.addSchema(2505, V2505::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema102, "Added Piglin", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new MemoryExpiryDataFix(schema102, "minecraft:villager"));
        Schema schema103 = datafixerbuilder.addSchema(2508, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema103, "Renamed fungi items to fungus", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema103, "Renamed fungi blocks to fungus", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema104 = datafixerbuilder.addSchema(2509, V2509::new);
        datafixerbuilder.addFixer((DataFix)new EntityZombifiedPiglinRenameFix(schema104));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema104, "Rename zombie pigman egg item", DataFixers.createRenamer(EntityZombifiedPiglinRenameFix.RENAMED_IDS)));
        Schema schema105 = datafixerbuilder.addSchema(2511, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityProjectileOwnerFix(schema105));
        Schema schema106 = datafixerbuilder.addSchema(2511, 1, V2511_1::new);
        datafixerbuilder.addFixer((DataFix)new NamedEntityConvertUncheckedFix(schema106, "SplashPotionItemFieldRenameFix", References.ENTITY, "minecraft:potion"));
        Schema schema107 = datafixerbuilder.addSchema(2514, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityUUIDFix(schema107));
        datafixerbuilder.addFixer((DataFix)new BlockEntityUUIDFix(schema107));
        datafixerbuilder.addFixer((DataFix)new PlayerUUIDFix(schema107));
        datafixerbuilder.addFixer((DataFix)new LevelUUIDFix(schema107));
        datafixerbuilder.addFixer((DataFix)new SavedDataUUIDFix(schema107));
        datafixerbuilder.addFixer((DataFix)new ItemStackUUIDFix(schema107));
        Schema schema108 = datafixerbuilder.addSchema(2516, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new GossipUUIDFix(schema108, "minecraft:villager"));
        datafixerbuilder.addFixer((DataFix)new GossipUUIDFix(schema108, "minecraft:zombie_villager"));
        Schema schema109 = datafixerbuilder.addSchema(2518, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new JigsawPropertiesFix(schema109, false));
        datafixerbuilder.addFixer((DataFix)new JigsawRotationFix(schema109));
        Schema schema110 = datafixerbuilder.addSchema(2519, V2519::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema110, "Added Strider", References.ENTITY));
        Schema schema111 = datafixerbuilder.addSchema(2522, V2522::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema111, "Added Zoglin", References.ENTITY));
        Schema schema112 = datafixerbuilder.addSchema(2523, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AttributesRenameLegacy(schema112, "Attribute renames", DataFixers.createRenamerNoNamespace((Map<String, String>)ImmutableMap.builder().put((Object)"generic.maxHealth", (Object)"minecraft:generic.max_health").put((Object)"Max Health", (Object)"minecraft:generic.max_health").put((Object)"zombie.spawnReinforcements", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"Spawn Reinforcements Chance", (Object)"minecraft:zombie.spawn_reinforcements").put((Object)"horse.jumpStrength", (Object)"minecraft:horse.jump_strength").put((Object)"Jump Strength", (Object)"minecraft:horse.jump_strength").put((Object)"generic.followRange", (Object)"minecraft:generic.follow_range").put((Object)"Follow Range", (Object)"minecraft:generic.follow_range").put((Object)"generic.knockbackResistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"Knockback Resistance", (Object)"minecraft:generic.knockback_resistance").put((Object)"generic.movementSpeed", (Object)"minecraft:generic.movement_speed").put((Object)"Movement Speed", (Object)"minecraft:generic.movement_speed").put((Object)"generic.flyingSpeed", (Object)"minecraft:generic.flying_speed").put((Object)"Flying Speed", (Object)"minecraft:generic.flying_speed").put((Object)"generic.attackDamage", (Object)"minecraft:generic.attack_damage").put((Object)"generic.attackKnockback", (Object)"minecraft:generic.attack_knockback").put((Object)"generic.attackSpeed", (Object)"minecraft:generic.attack_speed").put((Object)"generic.armorToughness", (Object)"minecraft:generic.armor_toughness").build())));
        Schema schema113 = datafixerbuilder.addSchema(2527, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BitStorageAlignFix(schema113));
        Schema schema114 = datafixerbuilder.addSchema(2528, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema114, "Rename soul fire torch and soul fire lantern", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema114, "Rename soul fire torch and soul fire lantern", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema115 = datafixerbuilder.addSchema(2529, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new StriderGravityFix(schema115, false));
        Schema schema116 = datafixerbuilder.addSchema(2531, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RedstoneWireConnectionsFix(schema116));
        Schema schema117 = datafixerbuilder.addSchema(2533, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new VillagerFollowRangeFix(schema117));
        Schema schema118 = datafixerbuilder.addSchema(2535, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityShulkerRotationFix(schema118));
        Schema schema119 = datafixerbuilder.addSchema(2537, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LegacyDimensionIdFix(schema119));
        Schema schema120 = datafixerbuilder.addSchema(2538, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LevelLegacyWorldGenSettingsFix(schema120));
        Schema schema121 = datafixerbuilder.addSchema(2550, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsFix(schema121));
        Schema schema122 = datafixerbuilder.addSchema(2551, V2551::new);
        datafixerbuilder.addFixer((DataFix)new WriteAndReadFix(schema122, "add types to WorldGenData", References.WORLD_GEN_SETTINGS));
        Schema schema123 = datafixerbuilder.addSchema(2552, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema123, "Nether biome rename", References.BIOME, DataFixers.createRenamer("minecraft:nether", "minecraft:nether_wastes")));
        Schema schema124 = datafixerbuilder.addSchema(2553, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema124, "Biomes fix", References.BIOME, DataFixers.createRenamer(BiomeFix.BIOMES)));
        Schema schema125 = datafixerbuilder.addSchema(2556, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsFancyGraphicsToGraphicsModeFix(schema125));
        Schema schema126 = datafixerbuilder.addSchema(2558, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new MissingDimensionFix(schema126, false));
        datafixerbuilder.addFixer((DataFix)new OptionsRenameFieldFix(schema126, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema127 = datafixerbuilder.addSchema(2568, V2568::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema127, "Added Piglin Brute", References.ENTITY));
        Schema schema128 = datafixerbuilder.addSchema(2571, V2571::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema128, "Added Goat", References.ENTITY));
        Schema schema129 = datafixerbuilder.addSchema(2679, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new CauldronRenameFix(schema129, false));
        Schema schema130 = datafixerbuilder.addSchema(2680, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema130, "Renamed grass path item to dirt path", DataFixers.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema130, "Renamed grass path block to dirt path", DataFixers.createRenamer("minecraft:grass_path", "minecraft:dirt_path")));
        Schema schema131 = datafixerbuilder.addSchema(2684, V2684::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema131, "Added Sculk Sensor", References.BLOCK_ENTITY));
        Schema schema132 = datafixerbuilder.addSchema(2686, V2686::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema132, "Added Axolotl", References.ENTITY));
        Schema schema133 = datafixerbuilder.addSchema(2688, V2688::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema133, "Added Glow Squid", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema133, "Added Glow Item Frame", References.ENTITY));
        Schema schema134 = datafixerbuilder.addSchema(2690, SAME_NAMESPACED);
        ImmutableMap immutablemap = ImmutableMap.builder().put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:oxidized_copper_block").put((Object)"minecraft:semi_weathered_copper_block", (Object)"minecraft:weathered_copper_block").put((Object)"minecraft:lightly_weathered_copper_block", (Object)"minecraft:exposed_copper_block").put((Object)"minecraft:weathered_cut_copper", (Object)"minecraft:oxidized_cut_copper").put((Object)"minecraft:semi_weathered_cut_copper", (Object)"minecraft:weathered_cut_copper").put((Object)"minecraft:lightly_weathered_cut_copper", (Object)"minecraft:exposed_cut_copper").put((Object)"minecraft:weathered_cut_copper_stairs", (Object)"minecraft:oxidized_cut_copper_stairs").put((Object)"minecraft:semi_weathered_cut_copper_stairs", (Object)"minecraft:weathered_cut_copper_stairs").put((Object)"minecraft:lightly_weathered_cut_copper_stairs", (Object)"minecraft:exposed_cut_copper_stairs").put((Object)"minecraft:weathered_cut_copper_slab", (Object)"minecraft:oxidized_cut_copper_slab").put((Object)"minecraft:semi_weathered_cut_copper_slab", (Object)"minecraft:weathered_cut_copper_slab").put((Object)"minecraft:lightly_weathered_cut_copper_slab", (Object)"minecraft:exposed_cut_copper_slab").put((Object)"minecraft:waxed_semi_weathered_copper", (Object)"minecraft:waxed_weathered_copper").put((Object)"minecraft:waxed_lightly_weathered_copper", (Object)"minecraft:waxed_exposed_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper", (Object)"minecraft:waxed_weathered_cut_copper").put((Object)"minecraft:waxed_lightly_weathered_cut_copper", (Object)"minecraft:waxed_exposed_cut_copper").put((Object)"minecraft:waxed_semi_weathered_cut_copper_stairs", (Object)"minecraft:waxed_weathered_cut_copper_stairs").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_stairs", (Object)"minecraft:waxed_exposed_cut_copper_stairs").put((Object)"minecraft:waxed_semi_weathered_cut_copper_slab", (Object)"minecraft:waxed_weathered_cut_copper_slab").put((Object)"minecraft:waxed_lightly_weathered_cut_copper_slab", (Object)"minecraft:waxed_exposed_cut_copper_slab").build();
        datafixerbuilder.addFixer(ItemRenameFix.create(schema134, "Renamed copper block items to new oxidized terms", DataFixers.createRenamer((Map<String, String>)immutablemap)));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema134, "Renamed copper blocks to new oxidized terms", DataFixers.createRenamer((Map<String, String>)immutablemap)));
        Schema schema135 = datafixerbuilder.addSchema(2691, SAME_NAMESPACED);
        ImmutableMap immutablemap1 = ImmutableMap.builder().put((Object)"minecraft:waxed_copper", (Object)"minecraft:waxed_copper_block").put((Object)"minecraft:oxidized_copper_block", (Object)"minecraft:oxidized_copper").put((Object)"minecraft:weathered_copper_block", (Object)"minecraft:weathered_copper").put((Object)"minecraft:exposed_copper_block", (Object)"minecraft:exposed_copper").build();
        datafixerbuilder.addFixer(ItemRenameFix.create(schema135, "Rename copper item suffixes", DataFixers.createRenamer((Map<String, String>)immutablemap1)));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema135, "Rename copper blocks suffixes", DataFixers.createRenamer((Map<String, String>)immutablemap1)));
        Schema schema136 = datafixerbuilder.addSchema(2693, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema136, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema schema137 = datafixerbuilder.addSchema(2696, SAME_NAMESPACED);
        ImmutableMap immutablemap2 = ImmutableMap.builder().put((Object)"minecraft:grimstone", (Object)"minecraft:deepslate").put((Object)"minecraft:grimstone_slab", (Object)"minecraft:cobbled_deepslate_slab").put((Object)"minecraft:grimstone_stairs", (Object)"minecraft:cobbled_deepslate_stairs").put((Object)"minecraft:grimstone_wall", (Object)"minecraft:cobbled_deepslate_wall").put((Object)"minecraft:polished_grimstone", (Object)"minecraft:polished_deepslate").put((Object)"minecraft:polished_grimstone_slab", (Object)"minecraft:polished_deepslate_slab").put((Object)"minecraft:polished_grimstone_stairs", (Object)"minecraft:polished_deepslate_stairs").put((Object)"minecraft:polished_grimstone_wall", (Object)"minecraft:polished_deepslate_wall").put((Object)"minecraft:grimstone_tiles", (Object)"minecraft:deepslate_tiles").put((Object)"minecraft:grimstone_tile_slab", (Object)"minecraft:deepslate_tile_slab").put((Object)"minecraft:grimstone_tile_stairs", (Object)"minecraft:deepslate_tile_stairs").put((Object)"minecraft:grimstone_tile_wall", (Object)"minecraft:deepslate_tile_wall").put((Object)"minecraft:grimstone_bricks", (Object)"minecraft:deepslate_bricks").put((Object)"minecraft:grimstone_brick_slab", (Object)"minecraft:deepslate_brick_slab").put((Object)"minecraft:grimstone_brick_stairs", (Object)"minecraft:deepslate_brick_stairs").put((Object)"minecraft:grimstone_brick_wall", (Object)"minecraft:deepslate_brick_wall").put((Object)"minecraft:chiseled_grimstone", (Object)"minecraft:chiseled_deepslate").build();
        datafixerbuilder.addFixer(ItemRenameFix.create(schema137, "Renamed grimstone block items to deepslate", DataFixers.createRenamer((Map<String, String>)immutablemap2)));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema137, "Renamed grimstone blocks to deepslate", DataFixers.createRenamer((Map<String, String>)immutablemap2)));
        Schema schema138 = datafixerbuilder.addSchema(2700, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create(schema138, "Renamed cave vines blocks", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:cave_vines_head", (Object)"minecraft:cave_vines", (Object)"minecraft:cave_vines_body", (Object)"minecraft:cave_vines_plant"))));
        Schema schema139 = datafixerbuilder.addSchema(2701, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new SavedDataFeaturePoolElementFix(schema139));
        Schema schema140 = datafixerbuilder.addSchema(2702, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AbstractArrowPickupFix(schema140));
        Schema schema141 = datafixerbuilder.addSchema(2704, V2704::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema141, "Added Goat", References.ENTITY));
        Schema schema142 = datafixerbuilder.addSchema(2707, V2707::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema142, "Added Marker", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema142, References.WORLD_GEN_SETTINGS, "has_increased_height_already", true));
        Schema schema143 = datafixerbuilder.addSchema(2710, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new StatsRenameFix(schema143, "Renamed play_one_minute stat to play_time", (Map<String, String>)ImmutableMap.of((Object)"minecraft:play_one_minute", (Object)"minecraft:play_time")));
        Schema schema144 = datafixerbuilder.addSchema(2717, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema144, "Rename azalea_leaves_flowers", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema144, "Rename azalea_leaves_flowers items", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:azalea_leaves_flowers", (Object)"minecraft:flowering_azalea_leaves"))));
        Schema schema145 = datafixerbuilder.addSchema(2825, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AddFlagIfNotPresentFix(schema145, References.WORLD_GEN_SETTINGS, "has_increased_height_already", false));
        Schema schema146 = datafixerbuilder.addSchema(2831, V2831::new);
        datafixerbuilder.addFixer((DataFix)new SpawnerDataFix(schema146));
        Schema schema147 = datafixerbuilder.addSchema(2832, V2832::new);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsHeightAndBiomeFix(schema147));
        datafixerbuilder.addFixer((DataFix)new ChunkHeightAndBiomeFix(schema147));
        Schema schema148 = datafixerbuilder.addSchema(2833, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema148));
        Schema schema149 = datafixerbuilder.addSchema(2838, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema149, "Caves and Cliffs biome renames", References.BIOME, DataFixers.createRenamer(CavesAndCliffsRenames.RENAMES)));
        Schema schema150 = datafixerbuilder.addSchema(2841, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkProtoTickListFix(schema150));
        Schema schema151 = datafixerbuilder.addSchema(2842, V2842::new);
        datafixerbuilder.addFixer((DataFix)new ChunkRenamesFix(schema151));
        Schema schema152 = datafixerbuilder.addSchema(2843, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OverreachingTickFix(schema152));
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema152, "Remove Deep Warm Ocean", References.BIOME, DataFixers.createRenamer("minecraft:deep_warm_ocean", "minecraft:warm_ocean")));
        Schema schema153 = datafixerbuilder.addSchema(2846, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AdvancementsRenameFix(schema153, false, "Rename some C&C part 2 advancements", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:husbandry/play_jukebox_in_meadows", (Object)"minecraft:adventure/play_jukebox_in_meadows", (Object)"minecraft:adventure/caves_and_cliff", (Object)"minecraft:adventure/fall_from_world_height", (Object)"minecraft:adventure/ride_strider_in_overworld_lava", (Object)"minecraft:nether/ride_strider_in_overworld_lava"))));
        Schema schema154 = datafixerbuilder.addSchema(2852, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WorldGenSettingsDisallowOldCustomWorldsFix(schema154));
        Schema schema155 = datafixerbuilder.addSchema(2967, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new StructureSettingsFlattenFix(schema155));
        Schema schema156 = datafixerbuilder.addSchema(2970, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new StructuresBecomeConfiguredFix(schema156));
        Schema schema157 = datafixerbuilder.addSchema(3076, V3076::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema157, "Added Sculk Catalyst", References.BLOCK_ENTITY));
        Schema schema158 = datafixerbuilder.addSchema(3077, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkDeleteIgnoredLightDataFix(schema158));
        Schema schema159 = datafixerbuilder.addSchema(3078, V3078::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema159, "Added Frog", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema159, "Added Tadpole", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema159, "Added Sculk Shrieker", References.BLOCK_ENTITY));
        Schema schema160 = datafixerbuilder.addSchema(3081, V3081::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema160, "Added Warden", References.ENTITY));
        Schema schema161 = datafixerbuilder.addSchema(3082, V3082::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema161, "Added Chest Boat", References.ENTITY));
        Schema schema162 = datafixerbuilder.addSchema(3083, V3083::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema162, "Added Allay", References.ENTITY));
        Schema schema163 = datafixerbuilder.addSchema(3084, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema163, "game_event_renames_3084", References.GAME_EVENT_NAME, DataFixers.createRenamer((Map<String, String>)ImmutableMap.builder().put((Object)"minecraft:block_press", (Object)"minecraft:block_activate").put((Object)"minecraft:block_switch", (Object)"minecraft:block_activate").put((Object)"minecraft:block_unpress", (Object)"minecraft:block_deactivate").put((Object)"minecraft:block_unswitch", (Object)"minecraft:block_deactivate").put((Object)"minecraft:drinking_finish", (Object)"minecraft:drink").put((Object)"minecraft:elytra_free_fall", (Object)"minecraft:elytra_glide").put((Object)"minecraft:entity_damaged", (Object)"minecraft:entity_damage").put((Object)"minecraft:entity_dying", (Object)"minecraft:entity_die").put((Object)"minecraft:entity_killed", (Object)"minecraft:entity_die").put((Object)"minecraft:mob_interact", (Object)"minecraft:entity_interact").put((Object)"minecraft:ravager_roar", (Object)"minecraft:entity_roar").put((Object)"minecraft:ring_bell", (Object)"minecraft:block_change").put((Object)"minecraft:shulker_close", (Object)"minecraft:container_close").put((Object)"minecraft:shulker_open", (Object)"minecraft:container_open").put((Object)"minecraft:wolf_shaking", (Object)"minecraft:entity_shake").build())));
        Schema schema164 = datafixerbuilder.addSchema(3086, SAME_NAMESPACED);
        DSL.TypeReference typereference = References.ENTITY;
        Int2ObjectOpenHashMap int2objectopenhashmap = Util.make(new Int2ObjectOpenHashMap(), int2objectopenhashmap1 -> {
            int2objectopenhashmap1.defaultReturnValue((Object)"minecraft:tabby");
            int2objectopenhashmap1.put(0, (Object)"minecraft:tabby");
            int2objectopenhashmap1.put(1, (Object)"minecraft:black");
            int2objectopenhashmap1.put(2, (Object)"minecraft:red");
            int2objectopenhashmap1.put(3, (Object)"minecraft:siamese");
            int2objectopenhashmap1.put(4, (Object)"minecraft:british");
            int2objectopenhashmap1.put(5, (Object)"minecraft:calico");
            int2objectopenhashmap1.put(6, (Object)"minecraft:persian");
            int2objectopenhashmap1.put(7, (Object)"minecraft:ragdoll");
            int2objectopenhashmap1.put(8, (Object)"minecraft:white");
            int2objectopenhashmap1.put(9, (Object)"minecraft:jellie");
            int2objectopenhashmap1.put(10, (Object)"minecraft:all_black");
        });
        Objects.requireNonNull(int2objectopenhashmap);
        datafixerbuilder.addFixer((DataFix)new EntityVariantFix(schema164, "Change cat variant type", typereference, "minecraft:cat", "CatType", arg_0 -> ((Int2ObjectOpenHashMap)int2objectopenhashmap).get(arg_0)));
        ImmutableMap immutablemap3 = ImmutableMap.builder().put((Object)"textures/entity/cat/tabby.png", (Object)"minecraft:tabby").put((Object)"textures/entity/cat/black.png", (Object)"minecraft:black").put((Object)"textures/entity/cat/red.png", (Object)"minecraft:red").put((Object)"textures/entity/cat/siamese.png", (Object)"minecraft:siamese").put((Object)"textures/entity/cat/british_shorthair.png", (Object)"minecraft:british").put((Object)"textures/entity/cat/calico.png", (Object)"minecraft:calico").put((Object)"textures/entity/cat/persian.png", (Object)"minecraft:persian").put((Object)"textures/entity/cat/ragdoll.png", (Object)"minecraft:ragdoll").put((Object)"textures/entity/cat/white.png", (Object)"minecraft:white").put((Object)"textures/entity/cat/jellie.png", (Object)"minecraft:jellie").put((Object)"textures/entity/cat/all_black.png", (Object)"minecraft:all_black").build();
        datafixerbuilder.addFixer((DataFix)new CriteriaRenameFix(schema164, "Migrate cat variant advancement", "minecraft:husbandry/complete_catalogue", s -> (String)immutablemap3.getOrDefault(s, s)));
        Schema schema165 = datafixerbuilder.addSchema(3087, SAME_NAMESPACED);
        typereference = References.ENTITY;
        int2objectopenhashmap = Util.make(new Int2ObjectOpenHashMap(), int2objectopenhashmap1 -> {
            int2objectopenhashmap1.put(0, (Object)"minecraft:temperate");
            int2objectopenhashmap1.put(1, (Object)"minecraft:warm");
            int2objectopenhashmap1.put(2, (Object)"minecraft:cold");
        });
        Objects.requireNonNull(int2objectopenhashmap);
        datafixerbuilder.addFixer((DataFix)new EntityVariantFix(schema165, "Change frog variant type", typereference, "minecraft:frog", "Variant", arg_0 -> ((Int2ObjectOpenHashMap)int2objectopenhashmap).get(arg_0)));
        Schema schema166 = datafixerbuilder.addSchema(3090, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityFieldsRenameFix(schema166, "EntityPaintingFieldsRenameFix", "minecraft:painting", Map.of("Motive", "variant", "Facing", "facing")));
        Schema schema167 = datafixerbuilder.addSchema(3093, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityGoatMissingStateFix(schema167));
        Schema schema168 = datafixerbuilder.addSchema(3094, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new GoatHornIdFix(schema168));
        Schema schema169 = datafixerbuilder.addSchema(3097, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new FilteredBooksFix(schema169));
        datafixerbuilder.addFixer((DataFix)new FilteredSignsFix(schema169));
        Map<String, String> map = Map.of("minecraft:british", "minecraft:british_shorthair");
        datafixerbuilder.addFixer((DataFix)new VariantRenameFix(schema169, "Rename british shorthair", References.ENTITY, "minecraft:cat", map));
        datafixerbuilder.addFixer((DataFix)new CriteriaRenameFix(schema169, "Migrate cat variant advancement for british shorthair", "minecraft:husbandry/complete_catalogue", s -> map.getOrDefault(s, (String)s)));
        Set<String> set = Set.of("minecraft:unemployed", "minecraft:nitwit");
        Objects.requireNonNull(set);
        datafixerbuilder.addFixer((DataFix)new PoiTypeRemoveFix(schema169, "Remove unpopulated villager PoI types", set::contains));
        Schema schema170 = datafixerbuilder.addSchema(3108, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlendingDataRemoveFromNetherEndFix(schema170));
        Schema schema171 = datafixerbuilder.addSchema(3201, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsProgrammerArtFix(schema171));
        Schema schema172 = datafixerbuilder.addSchema(3202, V3202::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema172, "Added Hanging Sign", References.BLOCK_ENTITY));
        Schema schema173 = datafixerbuilder.addSchema(3203, V3203::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema173, "Added Camel", References.ENTITY));
        Schema schema174 = datafixerbuilder.addSchema(3204, V3204::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema174, "Added Chiseled Bookshelf", References.BLOCK_ENTITY));
        Schema schema175 = datafixerbuilder.addSchema(3209, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ItemStackSpawnEggFix(schema175, false, "minecraft:pig_spawn_egg"));
        Schema schema176 = datafixerbuilder.addSchema(3214, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsAmbientOcclusionFix(schema176));
        Schema schema177 = datafixerbuilder.addSchema(3319, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsAccessibilityOnboardFix(schema177));
        Schema schema178 = datafixerbuilder.addSchema(3322, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EffectDurationFix(schema178));
        Schema schema179 = datafixerbuilder.addSchema(3325, V3325::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema179, "Added displays", References.ENTITY));
        Schema schema180 = datafixerbuilder.addSchema(3326, V3326::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema180, "Added Sniffer", References.ENTITY));
        Schema schema181 = datafixerbuilder.addSchema(3327, V3327::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema181, "Archaeology", References.BLOCK_ENTITY));
        Schema schema182 = datafixerbuilder.addSchema(3328, V3328::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema182, "Added interaction", References.ENTITY));
        Schema schema183 = datafixerbuilder.addSchema(3438, V3438::new);
        datafixerbuilder.addFixer(BlockEntityRenameFix.create(schema183, "Rename Suspicious Sand to Brushable Block", DataFixers.createRenamer("minecraft:suspicious_sand", "minecraft:brushable_block")));
        datafixerbuilder.addFixer((DataFix)new EntityBrushableBlockFieldsRenameFix(schema183));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema183, "Pottery shard renaming", DataFixers.createRenamer((Map<String, String>)ImmutableMap.of((Object)"minecraft:pottery_shard_archer", (Object)"minecraft:archer_pottery_shard", (Object)"minecraft:pottery_shard_prize", (Object)"minecraft:prize_pottery_shard", (Object)"minecraft:pottery_shard_arms_up", (Object)"minecraft:arms_up_pottery_shard", (Object)"minecraft:pottery_shard_skull", (Object)"minecraft:skull_pottery_shard"))));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema183, "Added calibrated sculk sensor", References.BLOCK_ENTITY));
        Schema schema184 = datafixerbuilder.addSchema(3439, V3439::new);
        datafixerbuilder.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix(schema184, "Updated sign text format for Signs", "minecraft:sign"));
        Schema schema185 = datafixerbuilder.addSchema(3439, 1, V3439_1::new);
        datafixerbuilder.addFixer((DataFix)new BlockEntitySignDoubleSidedEditableTextFix(schema185, "Updated sign text format for Hanging Signs", "minecraft:hanging_sign"));
        Schema schema186 = datafixerbuilder.addSchema(3440, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new NamespacedTypeRenameFix(schema186, "Replace experimental 1.20 overworld", References.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, DataFixers.createRenamer("minecraft:overworld_update_1_20", "minecraft:overworld")));
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema186, "Remove 1.20 feature toggle", Set.of("minecraft:update_1_20")));
        Schema schema187 = datafixerbuilder.addSchema(3447, SAME_NAMESPACED);
        datafixerbuilder.addFixer(ItemRenameFix.create(schema187, "Pottery shard item renaming to Pottery sherd", DataFixers.createRenamer(Stream.of("minecraft:angler_pottery_shard", "minecraft:archer_pottery_shard", "minecraft:arms_up_pottery_shard", "minecraft:blade_pottery_shard", "minecraft:brewer_pottery_shard", "minecraft:burn_pottery_shard", "minecraft:danger_pottery_shard", "minecraft:explorer_pottery_shard", "minecraft:friend_pottery_shard", "minecraft:heart_pottery_shard", "minecraft:heartbreak_pottery_shard", "minecraft:howl_pottery_shard", "minecraft:miner_pottery_shard", "minecraft:mourner_pottery_shard", "minecraft:plenty_pottery_shard", "minecraft:prize_pottery_shard", "minecraft:sheaf_pottery_shard", "minecraft:shelter_pottery_shard", "minecraft:skull_pottery_shard", "minecraft:snort_pottery_shard").collect(Collectors.toMap(Function.identity(), s -> s.replace("_pottery_shard", "_pottery_sherd"))))));
        Schema schema188 = datafixerbuilder.addSchema(3448, V3448::new);
        datafixerbuilder.addFixer((DataFix)new DecoratedPotFieldRenameFix(schema188));
        Schema schema189 = datafixerbuilder.addSchema(3450, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RemapChunkStatusFix(schema189, "Remove liquid_carvers and heightmap chunk statuses", DataFixers.createRenamer(Map.of("minecraft:liquid_carvers", "minecraft:carvers", "minecraft:heightmaps", "minecraft:spawn"))));
        Schema schema190 = datafixerbuilder.addSchema(3451, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkDeleteLightFix(schema190));
        Schema schema191 = datafixerbuilder.addSchema(3459, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LegacyDragonFightFix(schema191));
        Schema schema192 = datafixerbuilder.addSchema(3564, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new DropInvalidSignDataFix(schema192, "minecraft:sign"));
        Schema schema193 = datafixerbuilder.addSchema(3564, 1, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new DropInvalidSignDataFix(schema193, "minecraft:hanging_sign"));
        Schema schema194 = datafixerbuilder.addSchema(3565, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RandomSequenceSettingsFix(schema194));
        Schema schema195 = datafixerbuilder.addSchema(3566, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ScoreboardDisplaySlotFix(schema195));
        Schema schema196 = datafixerbuilder.addSchema(3568, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new MobEffectIdFix(schema196));
        Schema schema197 = datafixerbuilder.addSchema(3682, V3682::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema197, "Added Crafter", References.BLOCK_ENTITY));
        Schema schema198 = datafixerbuilder.addSchema(3683, V3683::new);
        datafixerbuilder.addFixer((DataFix)new PrimedTntBlockStateFixer(schema198));
        Schema schema199 = datafixerbuilder.addSchema(3685, V3685::new);
        datafixerbuilder.addFixer((DataFix)new FixProjectileStoredItem(schema199));
        Schema schema200 = datafixerbuilder.addSchema(3689, V3689::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema200, "Added Breeze", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema200, "Added Trial Spawner", References.BLOCK_ENTITY));
        Schema schema201 = datafixerbuilder.addSchema(3692, SAME_NAMESPACED);
        UnaryOperator<String> unaryoperator1 = DataFixers.createRenamer(Map.of("minecraft:grass", "minecraft:short_grass"));
        datafixerbuilder.addFixer(BlockRenameFix.create(schema201, "Rename grass block to short_grass", unaryoperator1));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema201, "Rename grass item to short_grass", unaryoperator1));
        Schema schema202 = datafixerbuilder.addSchema(3799, V3799::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema202, "Added Armadillo", References.ENTITY));
        Schema schema203 = datafixerbuilder.addSchema(3800, SAME_NAMESPACED);
        UnaryOperator<String> unaryoperator2 = DataFixers.createRenamer(Map.of("minecraft:scute", "minecraft:turtle_scute"));
        datafixerbuilder.addFixer(ItemRenameFix.create(schema203, "Rename scute item to turtle_scute", unaryoperator2));
        Schema schema204 = datafixerbuilder.addSchema(3803, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RenameEnchantmentsFix(schema204, "Rename sweeping enchant to sweeping_edge", Map.of("minecraft:sweeping", "minecraft:sweeping_edge")));
        Schema schema205 = datafixerbuilder.addSchema(3807, V3807::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema205, "Added Vault", References.BLOCK_ENTITY));
        Schema schema206 = datafixerbuilder.addSchema(3807, 1, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new MapBannerBlockPosFormatFix(schema206));
        Schema schema207 = datafixerbuilder.addSchema(3808, V3808::new);
        datafixerbuilder.addFixer((DataFix)new HorseBodyArmorItemFix(schema207, "minecraft:horse", "ArmorItem", true));
        Schema schema208 = datafixerbuilder.addSchema(3808, 1, V3808_1::new);
        datafixerbuilder.addFixer((DataFix)new HorseBodyArmorItemFix(schema208, "minecraft:llama", "DecorItem", false));
        Schema schema209 = datafixerbuilder.addSchema(3808, 2, V3808_2::new);
        datafixerbuilder.addFixer((DataFix)new HorseBodyArmorItemFix(schema209, "minecraft:trader_llama", "DecorItem", false));
        Schema schema210 = datafixerbuilder.addSchema(3809, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChestedHorsesInventoryZeroIndexingFix(schema210));
        Schema schema211 = datafixerbuilder.addSchema(3812, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new FixWolfHealth(schema211));
        Schema schema212 = datafixerbuilder.addSchema(3813, V3813::new);
        datafixerbuilder.addFixer((DataFix)new BlockPosFormatAndRenamesFix(schema212));
        Schema schema213 = datafixerbuilder.addSchema(3814, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AttributesRenameLegacy(schema213, "Rename jump strength attribute", DataFixers.createRenamer("minecraft:horse.jump_strength", "minecraft:generic.jump_strength")));
        Schema schema214 = datafixerbuilder.addSchema(3816, V3816::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema214, "Added Bogged", References.ENTITY));
        Schema schema215 = datafixerbuilder.addSchema(3818, V3818::new);
        datafixerbuilder.addFixer((DataFix)new BeehiveFieldRenameFix(schema215));
        datafixerbuilder.addFixer((DataFix)new EmptyItemInHotbarFix(schema215));
        Schema schema216 = datafixerbuilder.addSchema(3818, 1, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BannerPatternFormatFix(schema216));
        Schema schema217 = datafixerbuilder.addSchema(3818, 2, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new TippedArrowPotionToItemFix(schema217));
        Schema schema218 = datafixerbuilder.addSchema(3818, 3, V3818_3::new);
        datafixerbuilder.addFixer((DataFix)new WriteAndReadFix(schema218, "Inject data component types", References.DATA_COMPONENTS));
        Schema schema219 = datafixerbuilder.addSchema(3818, 4, V3818_4::new);
        datafixerbuilder.addFixer((DataFix)new ParticleUnflatteningFix(schema219));
        Schema schema220 = datafixerbuilder.addSchema(3818, 5, V3818_5::new);
        datafixerbuilder.addFixer((DataFix)new ItemStackComponentizationFix(schema220));
        Schema schema221 = datafixerbuilder.addSchema(3818, 6, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AreaEffectCloudPotionFix(schema221));
        Schema schema222 = datafixerbuilder.addSchema(3820, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new PlayerHeadBlockProfileFix(schema222));
        datafixerbuilder.addFixer((DataFix)new LodestoneCompassComponentFix(schema222));
        Schema schema223 = datafixerbuilder.addSchema(3825, V3825::new);
        datafixerbuilder.addFixer((DataFix)new ItemStackCustomNameToOverrideComponentFix(schema223));
        datafixerbuilder.addFixer((DataFix)new BannerEntityCustomNameToOverrideComponentFix(schema223));
        datafixerbuilder.addFixer((DataFix)new TrialSpawnerConfigFix(schema223));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema223, "Added Ominous Item Spawner", References.ENTITY));
        Schema schema224 = datafixerbuilder.addSchema(3828, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EmptyItemInVillagerTradeFix(schema224));
        Schema schema225 = datafixerbuilder.addSchema(3833, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RemoveEmptyItemInBrushableBlockFix(schema225));
        Schema schema226 = datafixerbuilder.addSchema(3938, V3938::new);
        datafixerbuilder.addFixer((DataFix)new ProjectileStoredWeaponFix(schema226));
        Schema schema227 = datafixerbuilder.addSchema(3939, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema227, "Remove 1.21 feature toggle", Set.of("minecraft:update_1_21")));
        Schema schema228 = datafixerbuilder.addSchema(3943, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsMenuBlurrinessFix(schema228));
        Schema schema229 = datafixerbuilder.addSchema(3945, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AttributeModifierIdFix(schema229));
        datafixerbuilder.addFixer((DataFix)new JukeboxTicksSinceSongStartedFix(schema229));
        Schema schema230 = datafixerbuilder.addSchema(4054, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OminousBannerRarityFix(schema230));
        Schema schema231 = datafixerbuilder.addSchema(4055, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AttributeIdPrefixFix(schema231));
        Schema schema232 = datafixerbuilder.addSchema(4057, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new CarvingStepRemoveFix(schema232));
        Schema schema233 = datafixerbuilder.addSchema(4059, V4059::new);
        datafixerbuilder.addFixer((DataFix)new FoodToConsumableFix(schema233));
        Schema schema234 = datafixerbuilder.addSchema(4061, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new TrialSpawnerConfigInRegistryFix(schema234));
        Schema schema235 = datafixerbuilder.addSchema(4064, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new FireResistantToDamageResistantComponentFix(schema235));
        Schema schema236 = datafixerbuilder.addSchema(4067, V4067::new);
        datafixerbuilder.addFixer((DataFix)new BoatSplitFix(schema236));
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix(schema236, "Remove Bundle experimental feature flag", Set.of("minecraft:bundle")));
        Schema schema237 = datafixerbuilder.addSchema(4068, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LockComponentPredicateFix(schema237));
        datafixerbuilder.addFixer((DataFix)new ContainerBlockEntityLockPredicateFix(schema237));
        Schema schema238 = datafixerbuilder.addSchema(4070, V4070::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema238, "Added Pale Oak Boat and Pale Oak Chest Boat", References.ENTITY));
        Schema schema239 = datafixerbuilder.addSchema(4071, V4071::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema239, "Added Creaking", References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new AddNewChoices(schema239, "Added Creaking Heart", References.BLOCK_ENTITY));
        Schema schema240 = datafixerbuilder.addSchema(4081, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntitySalmonSizeFix(schema240));
        Schema schema241 = datafixerbuilder.addSchema(4173, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityFieldsRenameFix(schema241, "Rename TNT Minecart fuse", "minecraft:tnt_minecart", Map.of("TNTFuse", "fuse")));
        Schema schema242 = datafixerbuilder.addSchema(4175, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EquippableAssetRenameFix(schema242));
        datafixerbuilder.addFixer((DataFix)new CustomModelDataExpandFix(schema242));
        Schema schema243 = datafixerbuilder.addSchema(4176, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new InvalidBlockEntityLockFix(schema243));
        datafixerbuilder.addFixer((DataFix)new InvalidLockComponentFix(schema243));
        Schema schema287 = datafixerbuilder.addSchema(4180, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix((Schema)schema244, "Remove Winter Drop toggle", Set.of("minecraft:winter_drop")));
        Schema schema288 = datafixerbuilder.addSchema(4181, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix((Schema)schema245, "minecraft:furnace"));
        datafixerbuilder.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix((Schema)schema245, "minecraft:smoker"));
        datafixerbuilder.addFixer((DataFix)new BlockEntityFurnaceBurnTimeFix((Schema)schema245, "minecraft:blast_furnace"));
        Schema schema289 = datafixerbuilder.addSchema(4187, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema246, "Villager follow range fix undo", "minecraft:villager", "minecraft:follow_range", d0 -> d0 == 48.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema246, "Bee follow range fix", "minecraft:bee", "minecraft:follow_range", d0 -> d0 == 48.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema246, "Allay follow range fix", "minecraft:allay", "minecraft:follow_range", d0 -> d0 == 48.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema246, "Llama follow range fix", "minecraft:llama", "minecraft:follow_range", d0 -> d0 == 40.0 ? 16.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema246, "Piglin Brute follow range fix", "minecraft:piglin_brute", "minecraft:follow_range", d0 -> d0 == 16.0 ? 12.0 : d0));
        datafixerbuilder.addFixer((DataFix)new EntityAttributeBaseValueFix((Schema)schema246, "Warden follow range fix", "minecraft:warden", "minecraft:follow_range", d0 -> d0 == 16.0 ? 24.0 : d0));
        Schema schema290 = datafixerbuilder.addSchema(4290, V4290::new);
        datafixerbuilder.addFixer((DataFix)new UnflattenTextComponentFix((Schema)schema247));
        Schema schema291 = datafixerbuilder.addSchema(4291, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LegacyHoverEventFix((Schema)schema248));
        datafixerbuilder.addFixer((DataFix)new TextComponentStringifiedFlagsFix((Schema)schema248));
        Schema schema292 = datafixerbuilder.addSchema(4292, V4292::new);
        datafixerbuilder.addFixer((DataFix)new TextComponentHoverAndClickEventFix((Schema)schema249));
        Schema schema293 = datafixerbuilder.addSchema(4293, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new DropChancesFormatFix((Schema)schema250));
        Schema schema294 = datafixerbuilder.addSchema(4294, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlockPropertyRenameAndFix((Schema)schema251, "CreakingHeartBlockStateFix", "minecraft:creaking_heart", "active", "creaking_heart_state", s -> s.equals("true") ? "awake" : "uprooted"));
        Schema schema295 = datafixerbuilder.addSchema(4295, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlendingDataFix((Schema)schema252));
        Schema schema296 = datafixerbuilder.addSchema(4296, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AreaEffectCloudDurationScaleFix((Schema)schema253));
        Schema schema297 = datafixerbuilder.addSchema(4297, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ForcedChunkToTicketFix((Schema)schema254));
        Schema schema298 = datafixerbuilder.addSchema(4299, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntitySpawnerItemVariantComponentFix((Schema)schema255));
        Schema schema299 = datafixerbuilder.addSchema(4300, V4300::new);
        datafixerbuilder.addFixer((DataFix)new SaddleEquipmentSlotFix((Schema)schema256));
        Schema schema300 = datafixerbuilder.addSchema(4301, V4301::new);
        datafixerbuilder.addFixer((DataFix)new EquipmentFormatFix((Schema)schema257));
        Schema schema301 = datafixerbuilder.addSchema(4302, V4302::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema258, "Added Test and Test Instance Block Entities", References.BLOCK_ENTITY));
        Schema schema302 = datafixerbuilder.addSchema(4303, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new EntityFallDistanceFloatToDoubleFix((Schema)schema259, References.ENTITY));
        datafixerbuilder.addFixer((DataFix)new EntityFallDistanceFloatToDoubleFix((Schema)schema259, References.PLAYER));
        Schema schema303 = datafixerbuilder.addSchema(4305, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new BlockPropertyRenameAndFix((Schema)schema260, "rename test block mode", "minecraft:test_block", "test_block_mode", "mode", s -> s));
        Schema schema304 = datafixerbuilder.addSchema(4306, V4306::new);
        datafixerbuilder.addFixer((DataFix)new ThrownPotionSplitFix((Schema)schema261));
        Schema schema305 = datafixerbuilder.addSchema(4307, V4307::new);
        datafixerbuilder.addFixer((DataFix)new TooltipDisplayComponentFix((Schema)schema262));
        Schema schema306 = datafixerbuilder.addSchema(4309, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new RaidRenamesDataFix((Schema)schema263));
        datafixerbuilder.addFixer((DataFix)new ChunkTicketUnpackPosFix((Schema)schema263));
        Schema schema307 = datafixerbuilder.addSchema(4311, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new AdvancementsRenameFix((Schema)schema264, false, "Use lodestone category change", DataFixers.createRenamer("minecraft:nether/use_lodestone", "minecraft:adventure/use_lodestone")));
        Schema schema308 = datafixerbuilder.addSchema(4312, V4312::new);
        datafixerbuilder.addFixer((DataFix)new PlayerEquipmentFix((Schema)schema265));
        Schema schema309 = datafixerbuilder.addSchema(4314, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new InlineBlockPosFormatFix((Schema)schema266));
        Schema schema310 = datafixerbuilder.addSchema(4420, V4420::new);
        datafixerbuilder.addFixer((DataFix)new NamedEntityConvertUncheckedFix((Schema)schema267, "AreaEffectCloudCustomParticleFix", References.ENTITY, "minecraft:area_effect_cloud"));
        Schema schema311 = datafixerbuilder.addSchema(4421, V4421::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema268, "Added Happy Ghast", References.ENTITY));
        Schema schema312 = datafixerbuilder.addSchema(4424, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new FeatureFlagRemoveFix((Schema)schema269, "Remove Locator Bar experimental feature flag", Set.of("minecraft:locator_bar")));
        datafixerbuilder.addFixer((DataFix)new AddFieldFix((Schema)schema269, References.PLAYER, "style", dynamic -> dynamic.createString("minecraft:default"), "locator_bar_icon"));
        datafixerbuilder.addFixer((DataFix)new AddFieldFix((Schema)schema269, References.ENTITY, "style", dynamic -> dynamic.createString("minecraft:default"), "locator_bar_icon"));
        Schema schema313 = datafixerbuilder.addSchema(4531, V4531::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema270, "Added Copper Golem", References.ENTITY));
        Schema schema314 = datafixerbuilder.addSchema(4532, V4532::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema271, "Added Copper Golem Statue Block Entity", References.BLOCK_ENTITY));
        Schema schema315 = datafixerbuilder.addSchema(4533, V4533::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema272, "Added Shelf", References.BLOCK_ENTITY));
        Schema schema316 = datafixerbuilder.addSchema(4535, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new CopperGolemWeatherStateFix((Schema)schema273));
        Schema schema317 = datafixerbuilder.addSchema(4537, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new ChunkDeleteLightFix((Schema)schema274));
        Schema schema318 = datafixerbuilder.addSchema(4541, SAME_NAMESPACED);
        datafixerbuilder.addFixer(BlockRenameFix.create((Schema)schema275, "Rename chain to iron_chain", DataFixers.createRenamer("minecraft:chain", "minecraft:iron_chain")));
        datafixerbuilder.addFixer(ItemRenameFix.create((Schema)schema275, "Rename chain to iron_chain", DataFixers.createRenamer("minecraft:chain", "minecraft:iron_chain")));
        Schema schema319 = datafixerbuilder.addSchema(4543, V4543::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema276, "Added Mannequin", References.ENTITY));
        Schema schema320 = datafixerbuilder.addSchema(4544, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new LegacyWorldBorderFix((Schema)schema277));
        Schema schema321 = datafixerbuilder.addSchema(4548, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WorldSpawnDataFix((Schema)schema278));
        datafixerbuilder.addFixer((DataFix)new PlayerRespawnDataFix((Schema)schema278));
        Schema schema322 = datafixerbuilder.addSchema(4648, V4648::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema279, "Added Nautilus and Zombie Nautilus", References.ENTITY));
        Schema schema323 = datafixerbuilder.addSchema(4649, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new TridentAnimationFix((Schema)schema280));
        Schema schema324 = datafixerbuilder.addSchema(4650, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new DebugProfileOverlayReferenceFix((Schema)schema281));
        Schema schema325 = datafixerbuilder.addSchema(4651, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)schema282, "cutoutLeaves", "false", "true", "true"));
        datafixerbuilder.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)schema282, "weatherRadius", "5", "10", "10"));
        datafixerbuilder.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)schema282, "vignette", "false", "true", "true"));
        datafixerbuilder.addFixer((DataFix)new OptionsGraphicsModeSplitFix((Schema)schema282, "improvedTransparency", "false", "false", "true"));
        datafixerbuilder.addFixer((DataFix)new OptionsSetGraphicsPresetToCustomFix((Schema)schema282));
        Schema schema326 = datafixerbuilder.addSchema(4656, V4656::new);
        datafixerbuilder.addFixer((DataFix)new AddNewChoices((Schema)schema283, "Added Parched and Camel Husk", References.ENTITY));
        Schema schema327 = datafixerbuilder.addSchema(4657, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new WorldBorderWarningTimeFix((Schema)schema284));
        Schema schema328 = datafixerbuilder.addSchema(4658, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new GameRuleRegistryFix((Schema)schema285));
        Schema schema329 = datafixerbuilder.addSchema(4661, SAME_NAMESPACED);
        datafixerbuilder.addFixer((DataFix)new OptionsMusicToastFix((Schema)schema286, false));
    }

    private static UnaryOperator<String> createRenamerNoNamespace(Map<String, String> map) {
        return s -> map.getOrDefault(s, (String)s);
    }

    private static UnaryOperator<String> createRenamer(Map<String, String> map) {
        return s -> map.getOrDefault(NamespacedSchema.ensureNamespaced(s), (String)s);
    }

    private static UnaryOperator<String> createRenamer(String s, String s1) {
        return s2 -> Objects.equals(NamespacedSchema.ensureNamespaced(s2), s) ? s1 : s2;
    }
}

