/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;
import org.jspecify.annotations.Nullable;

public abstract class DataComponentRemainderFix
extends DataFix {
    private final String name;
    private final String componentId;
    private final String newComponentId;

    public DataComponentRemainderFix(Schema var0, String var1, String var2) {
        this(var0, var1, var2, var2);
    }

    public DataComponentRemainderFix(Schema var0, String var1, String var2, String var3) {
        super(var0, false);
        this.name = var1;
        this.componentId = var2;
        this.newComponentId = var3;
    }

    public final TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.DATA_COMPONENTS);
        return this.fixTypeEverywhereTyped(this.name, var0, var02 -> var02.update(DSL.remainderFinder(), var0 -> {
            Optional var1 = var0.get(this.componentId).result();
            if (var1.isEmpty()) {
                return var0;
            }
            Dynamic var2 = this.fixComponent((Dynamic)var1.get());
            return var0.remove(this.componentId).setFieldIfPresent(this.newComponentId, Optional.ofNullable(var2));
        }));
    }

    protected abstract <T> @Nullable Dynamic<T> fixComponent(Dynamic<T> var1);
}

