/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.function.Supplier;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;

public class EntityZombieSplitFix
extends EntityRenameFix {
    private final Supplier<Type<?>> zombieVillagerType = Suppliers.memoize(() -> this.getOutputSchema().getChoiceType(References.ENTITY, "ZombieVillager"));

    public EntityZombieSplitFix(Schema var0) {
        super("EntityZombieSplitFix", var0, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String var02, Typed<?> var1) {
        String var4;
        if (!var02.equals("Zombie")) {
            return Pair.of((Object)var02, var1);
        }
        Dynamic var2 = (Dynamic)var1.getOptional(DSL.remainderFinder()).orElseThrow();
        int var3 = var2.get("ZombieType").asInt(0);
        return Pair.of((Object)var4, (Object)(switch (var3) {
            default -> {
                var4 = "Zombie";
                yield var1;
            }
            case 1, 2, 3, 4, 5 -> {
                var4 = "ZombieVillager";
                yield this.changeSchemaToZombieVillager(var1, var3 - 1);
            }
            case 6 -> {
                var4 = "Husk";
                yield var1;
            }
        }).update(DSL.remainderFinder(), var0 -> var0.remove("ZombieType")));
    }

    private Typed<?> changeSchemaToZombieVillager(Typed<?> var0, int var12) {
        return Util.writeAndReadTypedOrThrow(var0, this.zombieVillagerType.get(), var1 -> var1.set("Profession", var1.createInt(var12)));
    }
}

