/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.serialization.Dynamic;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class HeightmapRenamingFix
extends DataFix {
    public HeightmapRenamingFix(Schema var0, boolean var1) {
        super(var0, var1);
    }

    protected TypeRewriteRule makeRule() {
        Type var0 = this.getInputSchema().getType(References.CHUNK);
        OpticFinder var12 = var0.findField("Level");
        return this.fixTypeEverywhereTyped("HeightmapRenamingFix", var0, var1 -> var1.updateTyped(var12, var0 -> var0.update(DSL.remainderFinder(), this::fix)));
    }

    private Dynamic<?> fix(Dynamic<?> var0) {
        Optional var6;
        Optional var5;
        Optional var4;
        Optional var1 = var0.get("Heightmaps").result();
        if (var1.isEmpty()) {
            return var0;
        }
        Dynamic var2 = (Dynamic)var1.get();
        Optional var3 = var2.get("LIQUID").result();
        if (var3.isPresent()) {
            var2 = var2.remove("LIQUID");
            var2 = var2.set("WORLD_SURFACE_WG", (Dynamic)var3.get());
        }
        if ((var4 = var2.get("SOLID").result()).isPresent()) {
            var2 = var2.remove("SOLID");
            var2 = var2.set("OCEAN_FLOOR_WG", (Dynamic)var4.get());
            var2 = var2.set("OCEAN_FLOOR", (Dynamic)var4.get());
        }
        if ((var5 = var2.get("LIGHT").result()).isPresent()) {
            var2 = var2.remove("LIGHT");
            var2 = var2.set("LIGHT_BLOCKING", (Dynamic)var5.get());
        }
        if ((var6 = var2.get("RAIN").result()).isPresent()) {
            var2 = var2.remove("RAIN");
            var2 = var2.set("MOTION_BLOCKING", (Dynamic)var6.get());
            var2 = var2.set("MOTION_BLOCKING_NO_LEAVES", (Dynamic)var6.get());
        }
        return var0.set("Heightmaps", var2);
    }
}

