/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.util.function.Supplier;
import net.minecraft.util.datafix.ExtraDataFixUtils;
import net.minecraft.util.datafix.fixes.EntityRenameFix;
import net.minecraft.util.datafix.fixes.References;
import net.minecraft.util.datafix.schemas.NamespacedSchema;

public class ThrownPotionSplitFix
extends EntityRenameFix {
    private final Supplier<ItemIdFinder> itemIdFinder = Suppliers.memoize(() -> {
        Type var0 = this.getInputSchema().getChoiceType(References.ENTITY, "minecraft:potion");
        Type<?> var1 = ExtraDataFixUtils.patchSubType(var0, this.getInputSchema().getType(References.ENTITY), this.getOutputSchema().getType(References.ENTITY));
        OpticFinder var2 = var1.findField("Item");
        OpticFinder var3 = DSL.fieldFinder((String)"id", (Type)DSL.named((String)References.ITEM_NAME.typeName(), NamespacedSchema.namespacedString()));
        return new ItemIdFinder(var2, (OpticFinder<Pair<String, String>>)var3);
    });

    public ThrownPotionSplitFix(Schema var0) {
        super("ThrownPotionSplitFix", var0, true);
    }

    @Override
    protected Pair<String, Typed<?>> fix(String var0, Typed<?> var1) {
        if (!var0.equals("minecraft:potion")) {
            return Pair.of((Object)var0, var1);
        }
        String var2 = this.itemIdFinder.get().getItemId(var1);
        if ("minecraft:lingering_potion".equals(var2)) {
            return Pair.of((Object)"minecraft:lingering_potion", var1);
        }
        return Pair.of((Object)"minecraft:splash_potion", var1);
    }

    record ItemIdFinder(OpticFinder<?> itemFinder, OpticFinder<Pair<String, String>> itemIdFinder) {
        public String getItemId(Typed<?> var02) {
            return var02.getOptionalTyped(this.itemFinder).flatMap(var0 -> var0.getOptional(this.itemIdFinder)).map(Pair::getSecond).map(NamespacedSchema::ensureNamespaced).orElse("");
        }
    }
}

